/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.FilePdfSource;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.DocumentReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@PublicApi
public class DirectoryPdfSource {
    private transient Map<String, PdfSource> aJ = new TreeMap<String, PdfSource>();
    private String aH;

    protected DirectoryPdfSource(String name) {
        this.aH = name;
    }

    public DirectoryPdfSource(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.DoesNotExist", directory.getPath()));
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.NotDiretory", directory.getPath()));
        }
        this.aH = directory.getName();
        this.a(directory, directory.getAbsolutePath(), DocumentReader.getInstance().getSupportedFileExtensions());
    }

    public DirectoryPdfSource(String name, PdfSource ... sources) {
        this.aH = name;
        if (sources != null) {
            for (PdfSource pdfSource : sources) {
                this.addPdfSource(pdfSource);
            }
        }
    }

    private final void a(File file, String string, Set<String> set) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2;
            if (!file2.canRead()) continue;
            if (file2.isDirectory()) {
                this.a(file2, string, set);
                continue;
            }
            String string3 = file2.getName();
            int n = string3.lastIndexOf(46);
            if (n < 0 || n >= string3.length() - 1 || !set.contains(string2 = string3.substring(n + 1).toLowerCase())) continue;
            String string4 = file2.getAbsolutePath().replace(string, "");
            if (string4.startsWith(File.separator)) {
                string4 = string4.substring(1);
            }
            FilePdfSource filePdfSource = new FilePdfSource(file2, this.i(string4));
            this.addPdfSource(filePdfSource);
        }
    }

    protected void addPdfSource(PdfSource source) {
        this.aJ.put(this.i(source.getName()), source);
    }

    private String i(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0 || n >= string.length() - 1) {
            return string;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        Set<String> set = DocumentReader.getInstance().getSupportedFileExtensions();
        if (!set.contains(string2)) {
            return string;
        }
        return string.substring(0, string.length() - 1 - string2.length()) + "." + string2.toLowerCase();
    }

    public List<PdfSource> getPdfSources() {
        ArrayList<PdfSource> arrayList = new ArrayList<PdfSource>(this.aJ.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public PdfSource getPdfSource(String name) {
        return this.aJ.get(this.i(name));
    }

    public String getName() {
        return this.aH;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.aH + ", " + this.aJ.size() + " Files";
    }
}

