/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageData;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.TextSelectionUtil;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.Pair;
import com.inet.thread.SessionLocator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@InternalApi
public class CollapsePagesModelData
extends ResultModelData
implements Serializable {
    private static final Font rr = new Font("Arial", 0, 20);
    private ResultModelData rs;
    private Pair<Integer> rt = new Pair<Integer>(0, 0);

    public CollapsePagesModelData(ResultModelData rawData) {
        this.rs = rawData;
        this.cW();
    }

    void cW() {
        ResultPage resultPage;
        int n;
        super.setInfo(this.rs.getInfo());
        super.setPageImageCache(this.rs.getPageImageCache());
        CollapsableResultPage collapsableResultPage = null;
        for (n = 0; n < this.rs.getPageCount(true); ++n) {
            resultPage = this.rs.getPage(n, true);
            collapsableResultPage = new CollapsableResultPage(resultPage, resultPage.getPageOffset(), collapsableResultPage);
            super.addPage(collapsableResultPage, true);
        }
        collapsableResultPage = null;
        for (n = 0; n < this.rs.getPageCount(false); ++n) {
            resultPage = this.rs.getPage(n, false);
            collapsableResultPage = new CollapsableResultPage(resultPage, resultPage.getPageOffset(), collapsableResultPage);
            super.addPage(collapsableResultPage, false);
        }
        super.addDiffs(this.rs.getDiffs(true, true));
        if (this.rs.getProgress().getId() == State.FINISHED) {
            this.q(true);
            this.q(false);
        }
        if (PdfcSession.hasSession()) {
            ((PdfcSession)SessionLocator.getCurrent()).getStoreMap().initFontMap();
        }
    }

    public ResultModelData getOriginalData() {
        return this.rs;
    }

    @Override
    public List<? extends MutableDiffGroup> addDiffs(List<? extends MutableDiffGroup> diffs) {
        this.rs.addDiffs(diffs);
        return super.addDiffs(diffs);
    }

    @Override
    synchronized boolean setVisibleTypes(Set<DiffGroup.GroupType> types) {
        int n;
        this.rs.setVisibleTypes(types);
        for (n = 0; n < this.rs.getPageCount(true); ++n) {
            this.getPage((int)n, (boolean)true).hasDiffs = b.ru;
        }
        for (n = 0; n < this.rs.getPageCount(false); ++n) {
            this.getPage((int)n, (boolean)false).hasDiffs = b.ru;
        }
        this.clearDiffs();
        this.rt.set(true, 0);
        this.rt.set(false, 0);
        super.addDiffs(this.rs.getDiffs(true, true));
        if (this.rs.getProgress().getId() == State.FINISHED) {
            this.q(true);
            this.q(false);
        }
        return super.setVisibleTypes(types);
    }

    @Override
    boolean setDifferencesLimit(int differencesLimit) {
        boolean bl = this.rs.setDifferencesLimit(differencesLimit);
        super.setDifferencesLimit(differencesLimit);
        if (bl) {
            int n;
            for (n = 0; n < this.getPageCount(true); ++n) {
                this.getPage((int)n, (boolean)true).hasDiffs = b.rw;
            }
            for (n = 0; n < this.getPageCount(false); ++n) {
                this.getPage((int)n, (boolean)false).hasDiffs = b.rw;
            }
            this.updateDiffBounds(this.getDiffs(true, true));
        }
        return bl;
    }

    @Override
    public List<? extends MutableDiffGroup> updateDiffBounds(List<? extends MutableDiffGroup> diffs) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        ArrayList<a> arrayList = new ArrayList<a>();
        for (DiffGroup diffGroup : diffs) {
            a a2 = diffGroup instanceof a ? (a)diffGroup : new a((CompareDiffGroup)diffGroup, this.rs, this);
            arrayList.add(a2);
            if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
            this.a(a2, hashSet, true);
            this.a(a2, hashSet2, false);
        }
        this.a(hashSet, true);
        this.a(hashSet2, false);
        this.b(hashSet, true);
        this.b(hashSet2, false);
        return arrayList;
    }

    private void a(a a2, Set<Integer> set, boolean bl) {
        if (a2.r(bl) == null) {
            return;
        }
        int n = a2.s(bl);
        set.add(n);
        int n2 = a2.t(bl);
        if (n2 == n) {
            return;
        }
        if (n2 == n + 1) {
            set.add(n2);
            return;
        }
        set.add(n2);
        block0: for (Modification modification : a2.getModifications()) {
            List<PagedElement> list = modification.getAffectedElements(bl);
            if (list == null || list.size() == 0) continue;
            for (PagedElement pagedElement : list) {
                if (pagedElement.getPageIndex() <= n) continue;
                n = pagedElement.getPageIndex();
                if (n >= n2) break block0;
                set.add(n);
            }
        }
    }

    private void a(Set<Integer> set, boolean bl) {
        int n;
        int n2 = set.stream().min(Integer::compare).orElse(this.rt.get(bl));
        for (n = 0; n < Math.min(n2, this.getPageCount(bl)); ++n) {
            CollapsableResultPage collapsableResultPage = this.getPage(n, bl);
            if (collapsableResultPage.hasDiffs != b.ru) continue;
            collapsableResultPage.hasDiffs = b.rw;
        }
        if (n2 >= this.getPageCount(bl)) {
            return;
        }
        n = this.getPageCount(bl);
        boolean bl2 = "STRICT".equalsIgnoreCase(this.rs.getInfo().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        for (int i = 0; i < n; ++i) {
            CollapsableResultPage collapsableResultPage;
            CollapsableResultPage collapsableResultPage2 = this.getPage(i, bl);
            boolean bl3 = set.contains(collapsableResultPage2.getPageIndex());
            if (!bl3) continue;
            collapsableResultPage2.hasDiffs = b.rv;
            if (!bl2 || (collapsableResultPage = this.getPage(i, !bl)) == null) continue;
            collapsableResultPage.hasDiffs = b.rv;
        }
    }

    private void b(Set<Integer> set, boolean bl) {
        int n = set.stream().min(Integer::compare).orElse(this.rt.get(bl));
        if (n >= this.getPageCount(bl)) {
            return;
        }
        int n2 = this.getPageCount(bl);
        boolean bl2 = "STRICT".equalsIgnoreCase(this.rs.getInfo().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            CollapsableResultPage collapsableResultPage = this.getPage(i, bl);
            collapsableResultPage.pageOffset = n3;
            if (collapsableResultPage.hasDiffs == b.rv) {
                n4 = i;
            }
            if (bl2) {
                CollapsableResultPage collapsableResultPage2 = this.getPage(i, !bl);
                if (collapsableResultPage2 != null) {
                    n3 += Math.max(collapsableResultPage.getHeight(), collapsableResultPage2.getHeight());
                    continue;
                }
                n3 += collapsableResultPage.getHeight();
                continue;
            }
            n3 += collapsableResultPage.getHeight();
        }
        if (n4 >= 0) {
            this.rt.set(bl, n4);
        }
    }

    @Override
    public synchronized void addPage(ResultPage page, boolean first) {
        this.rs.addPage(page, first);
        super.addPage(new CollapsableResultPage(page, page.getPageOffset(), this.getPage(page.getPageIndex() - 1, first)), first);
    }

    @Override
    public void addHighlight(String typeKey, HighlightData chunk) {
        this.rs.addHighlight(typeKey, chunk);
    }

    @Override
    public LinkedHashMap<String, HighlightData> getHighlights() {
        return this.rs.getHighlights();
    }

    @Override
    protected void updateOffset(ResultPage page) {
    }

    @Override
    public void clear() {
        super.clear();
        this.rs.clear();
        this.rt.set(true, 0);
        this.rt.set(false, 0);
    }

    @Override
    public void setInfo(InfoData info) {
        super.setInfo(info);
        this.rs.setInfo(info);
    }

    @Override
    public void setProgress(ProgressState progress) {
        super.setProgress(progress);
        this.rs.setProgress(progress);
    }

    @Override
    public GUID getComparisonID() {
        return this.rs.getComparisonID();
    }

    @Override
    void finish() {
        this.q(true);
        this.q(false);
    }

    private void q(boolean bl) {
        int n = 0;
        boolean bl2 = "STRICT".equalsIgnoreCase(this.rs.getInfo().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        for (int i = 0; i < this.getPageCount(bl); ++i) {
            CollapsableResultPage collapsableResultPage;
            CollapsableResultPage collapsableResultPage2 = this.getPage(i, bl);
            collapsableResultPage2.pageOffset = n;
            if (bl2 && (collapsableResultPage = this.getPage(i, !bl)) != null) {
                if (collapsableResultPage.hasDiffs == b.rv || collapsableResultPage2.hasDiffs == b.rv) {
                    collapsableResultPage2.hasDiffs = b.rv;
                    collapsableResultPage.hasDiffs = b.rv;
                } else {
                    collapsableResultPage2.hasDiffs = b.rw;
                    collapsableResultPage.hasDiffs = b.rw;
                }
                n += Math.max(collapsableResultPage2.getHeight(), collapsableResultPage.getHeight());
                continue;
            }
            if (collapsableResultPage2.hasDiffs == b.ru) {
                collapsableResultPage2.hasDiffs = b.rw;
            }
            n += collapsableResultPage2.getHeight();
        }
    }

    @Override
    void setPageImageCache(PageImageCache pageImageCache) {
        super.setPageImageCache(pageImageCache);
        this.rs.setPageImageCache(pageImageCache);
    }

    @Override
    public void setModel(ResultModel resultModel) {
        super.setModel(resultModel);
        this.rs.setModel(resultModel);
    }

    @Override
    public CollapsableResultPage getPage(int index, boolean first) {
        ResultPage resultPage = super.getPage(index, first);
        if (resultPage != null && !(resultPage instanceof CollapsableResultPage)) {
            this.addPage(resultPage, first);
            resultPage = super.getPage(index, first);
        }
        return (CollapsableResultPage)resultPage;
    }

    public static boolean isRealPage(ResultPage page) {
        if (page instanceof CollapsableResultPage) {
            return ((CollapsableResultPage)page).hasDiffs();
        }
        return page != null;
    }

    @JsonData
    private class CollapsableResultPage
    extends ResultPage {
        private static final long serialVersionUID = 3494489928596369543L;
        private ResultPage original;
        private int pageOffset;
        private b hasDiffs;
        private CollapsableResultPage previosPage;

        protected CollapsableResultPage(ResultPage wrapped, int pageOffset, CollapsableResultPage previosPage) {
            this.original = wrapped;
            this.pageOffset = previosPage != null ? previosPage.getPageOffset() + previosPage.getHeight() : pageOffset;
            this.hasDiffs = b.ru;
            this.previosPage = previosPage;
        }

        private boolean hasDiffs() {
            return this.hasDiffs != b.rw;
        }

        @Override
        public boolean isLeft() {
            return this.original.isLeft();
        }

        @Override
        public int getHeight() {
            return this.hasDiffs() ? this.original.getHeight() : (this.previosPage == null || this.previosPage.hasDiffs() ? 35 : 0);
        }

        @Override
        public int getWidth() {
            return this.original.getWidth();
        }

        @Override
        public Dimension getSize() {
            return this.hasDiffs() ? this.original.getSize() : new Dimension(this.getWidth(), this.getHeight());
        }

        @Override
        public List<HighlightData.Highlight> getHighlights() {
            return this.hasDiffs() ? this.original.getHighlights() : null;
        }

        @Override
        public int getPageIndex() {
            return this.original.getPageIndex();
        }

        @Override
        public BufferedImage getPageImage(double scaleX, double scaleY) {
            if (this.hasDiffs()) {
                return this.original.getPageImage(scaleX, scaleY);
            }
            int n = (int)Math.round((double)this.getWidth() * scaleX);
            int n2 = (int)Math.round((double)this.getHeight() * scaleY);
            if (n > 0 && n2 > 0) {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.paint(graphics2D, scaleX, scaleY);
                return bufferedImage;
            }
            return null;
        }

        @Override
        public int getPageOffset() {
            return this.pageOffset;
        }

        @Override
        protected void setPageOffset(int yOffset) {
            this.pageOffset = yOffset;
        }

        @Override
        public boolean hasPageImage() {
            return this.original.hasPageImage();
        }

        @Override
        public void renderPage(double scale, Graphics2D g2) {
            if (this.hasDiffs()) {
                this.original.renderPage(scale, g2);
                return;
            }
            this.paint(g2, scale, scale);
        }

        protected List<TextInfo> getTextInfos() {
            return this.hasDiffs() ? TextSelectionUtil.getTextInfos(this.original) : new ArrayList();
        }

        @Override
        protected void setData(PageData data) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CPage #" + this.getPageIndex() + ", diffs=" + String.valueOf((Object)this.hasDiffs) + ", size=" + this.getWidth() + "x" + this.getHeight();
        }

        private void paint(Graphics2D g2, double scaleX, double scaleY) {
            Object object;
            int n = this.getHeight();
            if ((double)n < 1.0) {
                return;
            }
            int n2 = this.getWidth();
            int n3 = this.getPageIndex();
            int n4 = this.getPageIndex() + 1;
            while (n4 < CollapsePagesModelData.this.getPageCount(this.original.isLeft()) && !((CollapsableResultPage)(object = CollapsePagesModelData.this.getPage(n4, this.original.isLeft()))).hasDiffs()) {
                n3 = n4++;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.scale(scaleX, scaleY);
            g2.setColor(Color.white);
            g2.fillRect(0, 0, n2, n);
            g2.setColor(Color.black);
            Font font = rr;
            g2.setFont(font);
            object = n3 > this.getPageIndex() ? Msg.getMsg("Settings.onlypageswithdiffs.pageLabel.multi", this.getPageIndex() + 1, n3 + 1) : Msg.getMsg("Settings.onlypageswithdiffs.pageLabel", this.getPageIndex() + 1);
            Rectangle2D rectangle2D = font.getStringBounds((String)object, g2.getFontRenderContext());
            g2.drawString((String)object, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), (float)(((double)n - Math.abs(rectangle2D.getHeight())) / 2.0 + (double)g2.getFontMetrics().getAscent()));
        }
    }

    private static final class b
    extends Enum<b> {
        public static final /* enum */ b ru = new b();
        public static final /* enum */ b rv = new b();
        public static final /* enum */ b rw = new b();
        private static final /* synthetic */ b[] rx;

        public static b[] values() {
            return (b[])rx.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] cX() {
            return new b[]{ru, rv, rw};
        }

        static {
            rx = b.cX();
        }
    }

    private static class a
    extends CompareDiffGroup {
        public a(CompareDiffGroup compareDiffGroup, ResultModelData resultModelData, ResultModelData resultModelData2) {
            super(compareDiffGroup.getModifications(), compareDiffGroup.getBeforeFirst(), compareDiffGroup.getBeforeSecond(), compareDiffGroup.getAfterFirst(), compareDiffGroup.getAfterSecond(), compareDiffGroup.getType());
            super.setBounds(compareDiffGroup.getBounds(true) != null ? new c(compareDiffGroup.getBounds(true), resultModelData, resultModelData2, true) : null, true);
            super.setBounds(compareDiffGroup.getBounds(false) != null ? new c(compareDiffGroup.getBounds(false), resultModelData, resultModelData2, false) : null, false);
        }

        public c r(boolean bl) {
            c c2 = (c)super.getBounds(bl);
            if (c2 != null) {
                c2.update();
            }
            return c2;
        }

        @Override
        public void setBounds(Rectangle bounds, boolean first) {
            throw new IllegalStateException();
        }

        private int s(boolean bl) {
            c c2 = (c)super.getBounds(bl);
            return c2.ry.getPageIndex();
        }

        private int t(boolean bl) {
            c c2 = (c)super.getBounds(bl);
            return c2.rz.getPageIndex();
        }

        @Override
        public /* synthetic */ Rectangle getBounds(boolean bl) {
            return this.r(bl);
        }
    }

    private static class c
    extends Rectangle {
        private ResultPage ry;
        private ResultPage rz;
        private int rA;
        private int rB;

        public c(Rectangle rectangle, ResultModelData resultModelData, ResultModelData resultModelData2, boolean bl) {
            super(rectangle);
            ResultPage resultPage;
            ResultPage resultPage2 = resultModelData.getPageAt(rectangle.y, bl);
            if (resultPage2 == null) {
                resultPage2 = rectangle.y < 0 ? resultModelData.getPage(0, bl) : resultModelData.getPage(resultModelData.getPageCount(bl) - 1, bl);
            }
            if ((resultPage = resultModelData.getPageAt(rectangle.y + rectangle.height - 1, bl)) == null) {
                resultPage = resultModelData.getPage(resultModelData.getPageCount(bl) - 1, bl);
            }
            this.rA = rectangle.y - resultPage2.getPageOffset();
            this.rB = rectangle.y + rectangle.height - resultPage.getPageOffset();
            this.ry = resultModelData2.getPage(resultPage2.getPageIndex(), bl);
            this.rz = resultModelData2.getPage(resultPage.getPageIndex(), bl);
            this.update();
        }

        private void update() {
            this.y = Math.min(this.ry.getHeight(), this.rA) + this.ry.getPageOffset();
            this.height = Math.min(this.rB, this.rz.getHeight()) + this.rz.getPageOffset() - this.y;
        }
    }
}

