/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.i18n.Msg;
import com.inet.persistence.RandomAccessRead;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@JsonData
@PublicApi
public class ArrayPdfSource
extends PdfSource {
    private transient byte[] content;

    public ArrayPdfSource(String name, long lastModified, byte[] content) {
        super(name, null, lastModified, content != null ? (long)content.length : 0L);
        if (name == null) {
            throw new IllegalArgumentException(Msg.getMsg("Error.NameIsNull"));
        }
        if (content == null) {
            throw new IllegalArgumentException(Msg.getMsg("Error.ContentIsNull"));
        }
        this.content = content;
    }

    @Override
    public long getSize() {
        return this.content.length;
    }

    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    public RandomAccessRead getContent() throws IOException {
        return RandomAccessRead.wrap((byte[])this.content);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.content);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.content = (byte[])stream.readObject();
    }
}

