/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.ExportFilePresenter;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.PrintToPng;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

@PublicApi
public class DifferencesPNGPresenter
extends ExportFilePresenter {
    private int oR = 1000;
    private int oQ = 1000;
    private int pg;

    public DifferencesPNGPresenter(File rootFolder) {
        this(rootFolder, true);
    }

    public String getExtensionName() {
        return "Presenter_PNG";
    }

    public DifferencesPNGPresenter(File target, boolean isFolder) {
        if (isFolder) {
            this.s = target;
        } else {
            this.s = target.getParentFile();
            this.pn = target;
        }
    }

    @Override
    public void onComparisonDone() throws Exception {
        if (this.getModel().getDifferencesCount(true) == 0 && this.getModel().getSettings().isEnabled(Settings.EXPORT.ONLY_ON_DIFFERENCES)) {
            LOGGER.info((Object)Msg.getMsg("Export.doNothingNoDiffs", this.getModel().getComparisonParameters().getFirstFile().getName(), this.getModel().getComparisonParameters().getSecondFile().getName()));
            return;
        }
        PrintPainter printPainter = this.createAndSetupPrintPainter();
        this.pg = printPainter.calculatePages(this.oQ, this.oR, PrintToPng.IMAGE_CONTEXT);
        PrintToPng printToPng = new PrintToPng(printPainter){

            @Override
            protected OutputStream getOutputStream() throws IOException {
                return DifferencesPNGPresenter.this.getExportStream();
            }
        };
        this.applyPrintRange(printToPng);
        printToPng.setSize(this.oQ, this.oR);
        try {
            printToPng.export();
        }
        catch (Exception exception) {
            throw PdfcException.create((ErrorCode)PdfcErrorCode.errorWhilePresenting, exception, new Object[0]);
        }
        if (this.pn != null) {
            LOGGER.info((Object)Msg.getMsg("Export.pngTarget", this.pn.getAbsoluteFile()));
        }
    }

    @Override
    protected String getExtension() {
        return this.pg <= 1 ? ".png" : ".zip";
    }

    public void setSize(int width, int height) {
        this.oR = height;
        this.oQ = width;
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        DifferencesPNGPresenter differencesPNGPresenter = (DifferencesPNGPresenter)super.spawn(spawnWithParent);
        differencesPNGPresenter.s = this.s;
        differencesPNGPresenter.oR = this.oR;
        differencesPNGPresenter.oQ = this.oQ;
        return differencesPNGPresenter;
    }
}

