/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.PaintComparator;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.model.controls.ControlCheckBox;
import com.inet.pdfc.model.controls.ControlElement;
import com.inet.pdfc.model.controls.ControlList;
import com.inet.pdfc.model.controls.ControlText;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

@InternalApi
public class ElementComparator {
    public static final ElementComparator NOLOG_COMPARATOR = new ElementComparator(null);
    private ResultPrinter jX;
    private static final char[][] jY = new char[][]{{'\u00a0', ' '}, {'\u00b4', ' '}, {'\u2010', '-'}, {'\u2022', ' '}, {'\u2212', ' '}, {'\u00d7', ' '}, {'\u2019', '\''}, {',', ';'}, {'\ufb01', ' '}, {'\ufb02', ' '}, {'\u201c', '\u0093'}, {'\u201d', '\u0094'}, {'\u2013', '\u0096'}, {'\u2014', '\u0091'}, {'\u2018', '\u0091'}, {'\'', '\u0092'}, {'\u0091', '\u0097'}, {'\u03b5', '\"'}, {'\u02c6', '^'}, {'\u2192', '!'}, {'\u0097', '`'}, {'\u00b5', '\u03bc'}, {'|', 'j'}};
    private Rectangle2D jZ;

    public ElementComparator(ResultPrinter logger) {
        this.jX = logger;
    }

    public ElementComparator(ResultPrinter logger, Rectangle2D pageBounds) {
        this.jX = logger;
        this.jZ = pageBounds;
    }

    private boolean s(DrawableElement drawableElement) {
        return drawableElement instanceof ShapeElement && ((ShapeElement)drawableElement).getIsClip();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSame(DrawableElement e0, DrawableElement e1) {
        double d2;
        Class<?> clazz;
        if (e0 == null || e1 == null) {
            if (e0 != e1) return false;
            return true;
        }
        Class<?> clazz2 = e0.getClass();
        if (clazz2 != (clazz = e1.getClass()) && !clazz2.isAssignableFrom(clazz) && !clazz.isAssignableFrom(clazz2)) {
            if (this.jX == null) return false;
            this.jX.print("Different type of compared elements: " + String.valueOf(clazz2) + " <-> " + String.valueOf(clazz));
            return false;
        }
        boolean bl = true;
        Rectangle2D rectangle2D = this.a(e0, null);
        Rectangle2D rectangle2D2 = this.a(e1, rectangle2D);
        double d3 = d2 = e1.getType() == ElementType.Annotation || this.s(e1) ? 2.4000000000000004 : 0.8;
        if (bl && Math.abs(rectangle2D.getX() - rectangle2D2.getX()) > d2) {
            if (this.jX == null) return false;
            this.jX.print("Different X-Positions: " + e0.getX() + " and " + e1.getX());
            bl = false;
        }
        if (bl && Math.abs(rectangle2D.getY() - rectangle2D2.getY()) > d2 * 2.0) {
            if (this.jX == null) return false;
            this.jX.print("Different Y-Positions: " + e0.getY() + " and " + e1.getY());
            bl = false;
        }
        if (e0 instanceof AnnotationElement) {
            AnnotationElement annotationElement = (AnnotationElement)e0;
            AnnotationElement annotationElement2 = (AnnotationElement)e1;
            String string = annotationElement.getSubtype();
            String string2 = annotationElement2.getSubtype();
            if (string == null) {
                if (string2 != null) return false;
                return true;
            }
            boolean bl2 = string.equals(string2);
            return bl2;
        }
        if (e0 instanceof ImageElement) {
            ImageElement imageElement = (ImageElement)e0;
            ImageElement imageElement2 = (ImageElement)e1;
            if (Math.abs(imageElement.getWidth() - imageElement2.getWidth()) > d2) {
                if (this.jX == null) return false;
                this.jX.print("Different Widths: " + imageElement.getWidth() + " and " + imageElement2.getWidth());
                bl = false;
            }
            if (!(Math.abs(imageElement.getHeight() - imageElement2.getHeight()) > d2)) return bl;
            if (this.jX == null) return false;
            this.jX.print("Different Heights: " + imageElement.getHeight() + " and " + imageElement2.getHeight());
            return false;
        }
        if (e0 instanceof ShapeElement) {
            if (!this.a((ShapeElement)e0, (ShapeElement)e1)) return false;
            if (!bl) return false;
            return true;
        }
        if (e0 instanceof TextElement) {
            if (!this.a((TextElement)e0, (TextElement)e1)) return false;
            if (!bl) return false;
            return true;
        }
        if (!(e0 instanceof ControlElement)) return bl;
        if (!this.a((ControlElement)e0, (ControlElement)e1)) return false;
        if (!bl) return false;
        return true;
    }

    private boolean a(ControlElement controlElement, ControlElement controlElement2) {
        String string;
        String string2;
        ControlElement controlElement3;
        ControlElement controlElement4;
        if (controlElement.getFieldName() != null && !controlElement.getFieldName().equalsIgnoreCase(controlElement2.getFieldName())) {
            return false;
        }
        if (controlElement instanceof ControlCheckBox) {
            controlElement4 = (ControlCheckBox)controlElement;
            controlElement3 = (ControlCheckBox)controlElement2;
            if (((ControlCheckBox)controlElement4).isChecked() != ((ControlCheckBox)controlElement3).isChecked()) {
                return false;
            }
        }
        if (controlElement instanceof ControlList) {
            controlElement4 = (ControlList)controlElement;
            controlElement3 = (ControlList)controlElement2;
            string2 = controlElement4.getFieldValue();
            string = controlElement3.getFieldValue();
            if (string2 != null) {
                if (string == null) {
                    return false;
                }
                if (string2.equals(string)) {
                    return false;
                }
            } else if (string != null) {
                return false;
            }
        }
        if (controlElement instanceof ControlText) {
            controlElement4 = (ControlText)controlElement;
            controlElement3 = (ControlText)controlElement2;
            string2 = ((ControlText)controlElement4).getFieldValue();
            string = ((ControlText)controlElement3).getFieldValue();
            if (string2 == null) {
                return string == null;
            }
            return string2.equals(string);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(ShapeElement shapeElement, ShapeElement shapeElement2) {
        boolean bl = true;
        List<Shape> list = shapeElement2.getShapeSegments();
        List<Shape> list2 = shapeElement.getShapeSegments();
        if (list2 == null) {
            return list == null || list.size() == 0;
        }
        if (list == null) {
            return false;
        }
        Paint paint = shapeElement.getStrokePaint();
        Paint paint2 = shapeElement.getFillPaint();
        BasicStroke basicStroke = shapeElement.getStrokePaint() != null ? shapeElement.getStroke() : null;
        Paint paint3 = shapeElement2.getStrokePaint();
        Paint paint4 = shapeElement2.getFillPaint();
        BasicStroke basicStroke2 = shapeElement2.getStrokePaint() != null ? shapeElement2.getStroke() : null;
        PaintComparator paintComparator = new PaintComparator(0.01);
        if (!paintComparator.isEqual(paint, paint3)) {
            if (this.jX == null) return false;
            this.jX.print("difference in shape stroke paint");
            bl = false;
        }
        if (basicStroke == null && basicStroke2 != null || basicStroke != null && !basicStroke.equals(basicStroke2)) {
            if (this.jX == null) return false;
            this.jX.print("difference in shape basic stroke");
            bl = false;
        }
        if (paint4 == null || paint2 == null || !paint4.equals(paint2) && !paint2.equals(paint4)) {
            if (!paintComparator.canCompare(paint4)) {
                paint4 = null;
            }
            if (!paintComparator.canCompare(paint2)) {
                paint2 = null;
            }
            if (!paintComparator.isEqual(paint2, paint4)) {
                if (this.jX == null) return false;
                this.jX.print("difference in shape fill paint: REF=" + String.valueOf(paint4) + " CUR=" + String.valueOf(paint2));
                bl = false;
            }
        }
        if (shapeElement.getIsClip() && shapeElement2.getIsClip()) {
            Shape shape;
            Shape shape2 = shapeElement.getShape();
            if (shape2 == null != ((shape = shapeElement2.getShape()) == null)) {
                if (this.jX == null) return false;
                this.jX.print("different clip (" + String.valueOf(shape2) + " <-> " + String.valueOf(shape) + ")");
                return false;
            }
            if (shape2 == null && shape == null) {
                return bl;
            }
            Rectangle2D rectangle2D = ElementComparator.getNormedBounds(shape2.getBounds2D());
            Rectangle2D rectangle2D2 = ElementComparator.getNormedBounds(shape.getBounds2D());
            if (this.jZ != null) {
                Rectangle2D.intersect(rectangle2D, this.jZ, rectangle2D);
                Rectangle2D.intersect(rectangle2D2, this.jZ, rectangle2D2);
            }
            if (!(Math.abs(rectangle2D.getWidth() - rectangle2D2.getWidth()) > 3.0) && !(Math.abs(rectangle2D.getHeight() - rectangle2D2.getHeight()) > 3.0)) return bl;
            if (this.jX == null) return false;
            this.jX.print("different clip size(" + String.valueOf(shape2) + " <-> " + String.valueOf(shape) + ")");
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n < list.size() && n2 < list2.size()) {
            Shape shape;
            Shape shape3;
            Shape shape4 = list2.get(n2);
            Shape shape5 = list.get(n);
            if (shape4.getBounds2D().getWidth() == 0.0 && shape4.getBounds2D().getHeight() == 0.0) {
                ++n2;
                continue;
            }
            if (shape5.getBounds2D().getWidth() == 0.0 && shape5.getBounds2D().getHeight() == 0.0) {
                ++n;
                continue;
            }
            if (!shape4.getClass().equals(shape5.getClass())) {
                if (this.jX == null) return false;
                this.jX.print("different element types[" + n + "/" + n2 + "] in shape: " + String.valueOf(shape4.getClass()) + " and " + String.valueOf(shape5.getClass()));
                return false;
            }
            if (shape4 instanceof Line2D) {
                shape3 = (Line2D.Float)shape4;
                shape = (Line2D.Float)shape5;
                if (!ElementComparator.isLinesEqual(shape3, shape)) {
                    if (this.jX == null) return false;
                    this.jX.print("different Line2D elements");
                    bl = false;
                }
            } else if (shape4 instanceof CubicCurve2D) {
                shape3 = (CubicCurve2D.Float)shape4;
                shape = (CubicCurve2D.Float)shape5;
                if (!ElementComparator.isCubicCurvesEqual((CubicCurve2D.Float)shape3, (CubicCurve2D.Float)shape)) {
                    if (this.jX == null) return false;
                    this.jX.print("different in CubicCurve2D elements");
                    bl = false;
                }
            } else if (shape4 instanceof QuadCurve2D && !ElementComparator.isQuadCurvesEqual((QuadCurve2D.Float)(shape3 = (QuadCurve2D.Float)shape4), (QuadCurve2D.Float)(shape = (QuadCurve2D.Float)shape5))) {
                if (this.jX == null) return false;
                this.jX.print("different in QuadCurve2D elements");
                bl = false;
            }
            ++n;
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(TextElement textElement, TextElement textElement2) {
        PaintComparator paintComparator;
        String string;
        Object object;
        boolean bl = true;
        double[] dArray = textElement.getTransformMatrix();
        double[] dArray2 = textElement2.getTransformMatrix();
        double d2 = dArray[4];
        double d3 = dArray2[4];
        if (bl && Math.abs(d2 - d3) > 0.8) {
            if (this.jX == null) return false;
            this.jX.print("Different X-Positions: " + d2 + " and " + d3);
            bl = false;
        }
        double d4 = dArray[5];
        double d5 = dArray2[5];
        if (bl && Math.abs(d4 - d5) > 0.8) {
            if (this.jX == null) return false;
            this.jX.print("Different Y-Positions: " + d4 + " and " + d5);
            bl = false;
        }
        double d6 = textElement.getTextHeight();
        double d7 = textElement2.getTextHeight();
        if (bl && Math.abs(d6 - d7) > 100000.0) {
            if (textElement.getFontSize() != textElement2.getFontSize()) {
                d7 *= (double)textElement.getFontSize();
                if (Math.abs((d6 *= (double)textElement2.getFontSize()) - d7) > 1.3) {
                    if (this.jX == null) return false;
                    this.jX.print("Different text height: " + d6 + " and " + d7);
                    this.jX.print("Fonts are " + textElement.getFontInfo().getFontName() + " and " + textElement2.getFontInfo().getFontName());
                    bl = false;
                }
            } else {
                if (this.jX == null) return false;
                this.jX.print("Different text height: " + d6 + " and " + d7);
                this.jX.print("Fonts are " + textElement.getFontInfo().getFontName() + " and " + textElement2.getFontInfo().getFontName());
                bl = false;
            }
        }
        double d8 = textElement.getTextWidth();
        double d9 = textElement2.getTextWidth();
        double[] dArray3 = textElement.getCharacterWidths();
        if (bl && Math.abs(d8 - d9) > 0.8 && textElement.getKerningArray() != null) {
            object = textElement2.getCharacterWidths();
            double d10 = dArray3.length > 0 ? dArray3[dArray3.length - 1] : 0.0;
            double d11 = ((Object)object).length > 0 ? (double)object[((Object)object).length - 1] : 0.0;
            d8 -= d10 - d11;
            d9 -= dArray3.length > 0 && ((Object)object).length > 0 ? (double)(object[0] - dArray3[0]) : 0.0;
        }
        if (bl && Math.abs(d8 - d9) > 0.8 && (dArray3.length == 0 || d9 < d8 - dArray3[dArray3.length - 1] || d9 > d8)) {
            if (this.jX == null) return false;
            this.jX.print("Different text width: " + d8 + " and " + d9);
            bl = false;
        }
        object = textElement.getText();
        String string2 = textElement2.getText();
        String string3 = this.v((String)object);
        if (!string3.equals((string = this.v(string2)).replace('\u00a0', ' '))) {
            if (this.jX == null) return false;
            this.jX.print("texts differ: '" + ElementComparator.w((String)object) + "' and '" + ElementComparator.w(string2) + "'" + textElement.getFontInfo().getFontName());
            bl = false;
        }
        if (!textElement.getFontInfo().getFamilyName().equals(textElement2.getFontInfo().getFamilyName())) {
            if (this.jX == null) return false;
            bl = false;
            this.jX.print("fonts differ: '" + textElement.getFontInfo().getFamilyName() + "' and '" + textElement2.getFontInfo().getFamilyName() + "'");
        }
        if (textElement.getFontSize() != textElement2.getFontSize()) {
            double d12 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            if (Math.abs((double)textElement.getFontSize() * d12 - (double)textElement2.getFontSize()) > 0.8 && Math.abs((double)textElement.getFontSize() - (double)textElement2.getFontSize() * d12) > 0.8) {
                if (this.jX == null) return false;
                bl = false;
                this.jX.print("font sizes differ: '" + textElement.getFontSize() + "' and '" + textElement2.getFontSize() + "'");
            }
        }
        if (!(paintComparator = new PaintComparator(0.01)).isEqual(textElement.getFillPaint(), textElement2.getFillPaint())) {
            bl = false;
            if (this.jX == null) return false;
            this.jX.print("fill paint values differ: '" + String.valueOf(textElement.getFillPaint()) + "' and '" + String.valueOf(textElement2.getFillPaint()) + "'");
        }
        if (paintComparator.isEqual(textElement.getStrokePaint(), textElement2.getStrokePaint())) return bl;
        if (this.jX == null) return false;
        bl = false;
        this.jX.print("stroke paint values differ: '" + String.valueOf(textElement.getStrokePaint()) + "' and '" + String.valueOf(textElement2.getStrokePaint()) + "'");
        return bl;
    }

    private String v(String string) {
        for (char[] cArray : jY) {
            string = string.replace(cArray[0], cArray[1]);
        }
        return string;
    }

    public static boolean isQuadCurvesEqual(QuadCurve2D.Float curve1, QuadCurve2D.Float curve2) {
        if ((double)Math.abs(curve1.x1 - curve2.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.y1 - curve2.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx - curve2.ctrlx) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly - curve2.ctrly) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.x2 - curve2.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(curve1.y2 - curve2.y2) > 0.8);
    }

    public static boolean isLinesEqual(Line2D.Float firstLine, Line2D.Float secondLine) {
        if ((double)Math.abs(firstLine.x1 - secondLine.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(firstLine.y1 - secondLine.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(firstLine.x2 - secondLine.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(firstLine.y2 - secondLine.y2) > 0.8);
    }

    public static boolean isCubicCurvesEqual(CubicCurve2D.Float curve1, CubicCurve2D.Float curve2) {
        if ((double)Math.abs(curve1.x1 - curve2.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.y1 - curve2.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx1 - curve2.ctrlx1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly1 - curve2.ctrly1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx2 - curve2.ctrlx2) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly2 - curve2.ctrly2) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.x2 - curve2.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(curve1.y2 - curve2.y2) > 0.8);
    }

    private static String w(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(String.format("%02x", string.charAt(i)));
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    private Rectangle2D a(DrawableElement drawableElement, Rectangle2D rectangle2D) {
        if (drawableElement == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = drawableElement.getBounds();
        switch (drawableElement.getType()) {
            case Text: 
            case TextWord: 
            case TextInfo: 
            case TextLine: {
                return rectangle2D2;
            }
            case Shape: {
                ShapeElement shapeElement = (ShapeElement)drawableElement;
                if (!shapeElement.getIsClip() || this.jZ == null || rectangle2D2 == null) break;
                rectangle2D2 = ElementComparator.getNormedBounds(rectangle2D2);
                Rectangle2D.intersect(rectangle2D2, this.jZ, rectangle2D2);
                return rectangle2D2;
            }
        }
        if (rectangle2D2 == null) {
            if (rectangle2D != null) {
                return new Rectangle2D.Double(drawableElement.getX(), drawableElement.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            return new Rectangle2D.Double(drawableElement.getX(), drawableElement.getY(), 0.0, 0.0);
        }
        return ElementComparator.getNormedBounds(rectangle2D2);
    }

    protected static Rectangle2D getNormedBounds(Rectangle2D rect) {
        if (rect.getWidth() >= 0.0 && rect.getHeight() >= 0.0) {
            return rect;
        }
        double d2 = ElementComparator.getMinX(rect);
        double d3 = ElementComparator.getMinY(rect);
        double d4 = ElementComparator.getMaxX(rect);
        double d5 = ElementComparator.getMaxY(rect);
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    private static double getMaxX(Rectangle2D rect) {
        return rect.getWidth() > 0.0 ? rect.getMaxX() : rect.getX();
    }

    private static double getMaxY(Rectangle2D rect) {
        return rect.getHeight() > 0.0 ? rect.getMaxY() : rect.getY();
    }

    private static double getMinX(Rectangle2D rect) {
        return rect.getWidth() < 0.0 ? rect.getMaxX() : rect.getX();
    }

    private static double getMinY(Rectangle2D rect) {
        return rect.getHeight() < 0.0 ? rect.getMaxY() : rect.getY();
    }

    @FunctionalInterface
    @InternalApi
    public static interface ResultPrinter {
        public void print(String var1);
    }
}

