/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.thread;

import com.inet.annotations.InternalApi;
import com.inet.font.truetype.SessionFontFactoryCache;
import com.inet.logging.LogID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.generator.rendercache.SerializableImageCache;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PdfcSession
extends BaseRunnableSession {
    public static final String KEY_LANGUAGE_FIRST = "document.first.language";
    public static final String KEY_LANGUAGE_SECOND = "document.second.language";
    public static final String KEY_LANGUAGE_FIRST_OCR = "document.first.tess";
    public static final String KEY_LANGUAGE_SECOND_OCR = "document.second.tess";
    public static final String KEY_DOCUMENT_FILE_FIRST = "document.first.file";
    public static final String KEY_DOCUMENT_FILE_SECOND = "document.second.file";
    public static final String KEY_OCR_IN_USE = "ocr.active";
    private PdfcRenderCache bt;
    private Properties tg;
    private boolean th;
    private Supplier<PdfcRenderCache> ti;

    private PdfcSession(@Nonnull Supplier<PdfcRenderCache> storeMapProvider) {
        this.ti = storeMapProvider;
    }

    @Nonnull
    public static PdfcSession createSession(@Nonnull PdfcRenderCache storeMap) {
        return PdfcSession.createSession(() -> storeMap);
    }

    @Nonnull
    public static PdfcSession createSession(@Nonnull Supplier<PdfcRenderCache> storeMapProvider) {
        if (SessionLocator.exists() && SessionLocator.getCurrent() instanceof PdfcSession) {
            PDFCCore.LOGGER_CORE.debug((Object)"Created new session object in thread with existing session.");
            String string = LogID.getID();
            try {
                LogID.reset();
                PdfcSession pdfcSession = new PdfcSession(storeMapProvider);
                return pdfcSession;
            }
            finally {
                LogID.setID((String)string);
            }
        }
        return new PdfcSession(storeMapProvider);
    }

    @Nonnull
    public static PdfcSession getSession() {
        if (PdfcSession.hasSession()) {
            return (PdfcSession)SessionLocator.getCurrent();
        }
        throw new IllegalStateException("Missing session in current thread");
    }

    public void setThreadLocal() {
        super.setThreadLocal();
        if (!this.th) {
            SessionFontFactoryCache.startForCurrentSession();
            this.th = true;
        }
    }

    public static boolean hasSession() {
        return SessionLocator.exists() && SessionLocator.getCurrent() instanceof PdfcSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public PdfcRenderCache getStoreMap() {
        if (this.bt == null) {
            PdfcSession pdfcSession = this;
            synchronized (pdfcSession) {
                if (this.bt == null) {
                    this.bt = this.ti.get();
                }
            }
        }
        return this.bt;
    }

    public void replaceStoreMap(@Nonnull PdfcRenderCache storeMap) {
        this.bt = storeMap;
    }

    public String toString() {
        return "PDFC Session #" + System.identityHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PdfcSession pdfcSession = (PdfcSession)((Object)obj);
        return !(this.bt != null ? pdfcSession.bt == this.bt : pdfcSession.bt == null);
    }

    public long memorySize() {
        return this.bt != null ? this.bt.getMemorySize() : 0L;
    }

    public long swapSize() {
        return this.bt != null ? this.bt.getSwapSize() : 0L;
    }

    public long objectHandles() {
        return this.bt != null ? this.bt.size() : 0L;
    }

    @Nonnull
    public Properties getSessionProperties() {
        if (this.tg == null) {
            this.tg = new Properties();
        }
        return this.tg;
    }

    public void setSessionProperties(@Nullable Properties sessionProperties) {
        this.tg = sessionProperties != null ? sessionProperties : new Properties();
    }

    public void cleanUp() {
        RunnableSession runnableSession;
        Object object = runnableSession = SessionLocator.exists() ? SessionLocator.getCurrent() : new BaseRunnableSession();
        if (runnableSession != this) {
            this.setThreadLocal();
        }
        try {
            SessionFontFactoryCache.cleanupForCurrentSession();
        }
        finally {
            if (runnableSession != this) {
                this.resetThreadLocal();
                runnableSession.setThreadLocal();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    @Nullable
    public static SerializableImageCache getStoreMapFromSession() {
        RunnableSession runnableSession;
        if (SessionLocator.exists() && (runnableSession = SessionLocator.getCurrent()) instanceof PdfcSession) {
            PdfcSession pdfcSession = (PdfcSession)runnableSession;
            return pdfcSession.getStoreMap();
        }
        return null;
    }

    static {
        try {
            new SessionFontFactoryCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

