/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

@JsonData
public class ResultModelData
implements Serializable {
    private static final Comparator<ResultPage> PAGE_SEARCHER = (o1, o2) -> {
        if (o2.getPageOffset() < o1.getPageOffset()) {
            return 1;
        }
        if (o2.getPageOffset() >= o1.getPageOffset() + o1.getHeight()) {
            return -1;
        }
        return 0;
    };
    private static final long serialVersionUID = -8321040843435719927L;
    private InfoData info = new InfoData(null, null, null);
    private List<ResultPage> pagesL = new ArrayList<ResultPage>();
    private List<ResultPage> pagesR = new ArrayList<ResultPage>();
    private List<DiffGroup> diffs = new ArrayList<DiffGroup>();
    private LinkedHashMap<String, HighlightData> highlights = new LinkedHashMap();
    private ProgressState progress = new ProgressState(State.IDLE);
    private transient PageImageCache pageImageCache;
    @Deprecated
    private transient Set<DiffGroup.GroupType> visibleTypes = new HashSet<DiffGroup.GroupType>(Arrays.asList(DiffGroup.GroupType.values()));
    private transient Set<Modification.ModificationType> visibleModTypes = new HashSet<Modification.ModificationType>(Arrays.asList(Modification.ModificationType.values()));
    private transient int differencesLimit = -1;
    private List<DiffGroup> filteredDiffs = null;
    private transient List<DiffGroup> filteredDiffsNoSync = null;
    private transient List<DiffGroup> diffsNoSync = null;
    private transient GUID comparisonID = null;

    public InfoData getInfo() {
        return this.info;
    }

    public ProgressState getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressState progress) {
        if ((progress.getId() == State.CANCELED || progress.getId() == State.ERROR) && progress.getValue() == 0.0f && this.progress != null && this.progress.getValue() > 0.0f) {
            progress = new ProgressState(progress.getId(), this.progress.calculateProgressValue());
        }
        this.progress = progress;
    }

    public void setInfo(InfoData info) {
        this.info = info;
    }

    public ResultPage getPage(int index, boolean first) {
        List<ResultPage> list;
        if (index < 0) {
            return null;
        }
        List<ResultPage> list2 = list = first ? this.pagesL : this.pagesR;
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public ResultPage getPageAt(int yOffset, boolean first) {
        List<ResultPage> list;
        List<ResultPage> list2 = list = first ? this.pagesL : this.pagesR;
        if (list.isEmpty()) {
            return null;
        }
        if (yOffset < 0) {
            return list.get(0);
        }
        ResultPage resultPage = new ResultPage();
        resultPage.setPageOffset(yOffset);
        int n = Collections.binarySearch(list, resultPage, PAGE_SEARCHER);
        if (n < 0) {
            n = -(n + 1);
        }
        if (n == list.size()) {
            ResultPage resultPage2 = this.getPage(n - 1, first);
            if (yOffset < resultPage2.getPageOffset() + resultPage2.getHeight()) {
                return resultPage2;
            }
            return null;
        }
        return this.getPage(n, first);
    }

    public int getPageCount(boolean first) {
        return (first ? this.pagesL : this.pagesR).size();
    }

    public void addPage(ResultPage page, boolean first) {
        List<ResultPage> list;
        List<ResultPage> list2 = list = first ? this.pagesL : this.pagesR;
        if (list.size() <= page.getPageIndex() || list.get(page.getPageIndex()).getWidth() <= 0) {
            while (list.size() < page.getPageIndex()) {
                list.add(new ResultPage());
            }
            if (page.getPageIndex() < list.size()) {
                list.set(page.getPageIndex(), page);
            } else {
                list.add(page);
            }
        }
        this.updateOffset(page);
    }

    protected void updateOffset(ResultPage page) {
        boolean bl = "STRICT".equalsIgnoreCase(this.getInfo().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        int n = page.getPageIndex();
        if (n <= 0) {
            return;
        }
        boolean bl2 = !page.isLeft();
        ResultPage resultPage = this.getPage(n - 1, page.isLeft());
        if (bl && this.getPageCount(bl2) >= n) {
            ResultPage resultPage2 = this.getPage(n - 1, bl2);
            int n2 = Math.max(resultPage.getHeight(), resultPage2 != null ? resultPage2.getHeight() : 0);
            page.setPageOffset(resultPage.getPageOffset() + n2);
            ResultPage resultPage3 = this.getPage(n, bl2);
            if (resultPage3 != null && resultPage2 != null) {
                resultPage3.setPageOffset(resultPage2.getPageOffset() + n2);
            }
        } else {
            page.setPageOffset(resultPage.getPageOffset() + resultPage.getHeight());
        }
    }

    public static List<DiffGroup> getDifferences(boolean filtered, boolean includeSync, ResultModel model) {
        return model.getModelData().getDiffs(filtered, includeSync);
    }

    public List<DiffGroup> getDiffs(boolean filtered, boolean includeSync) {
        if (filtered) {
            if ((this.filteredDiffs == null || this.filteredDiffsNoSync == null && !includeSync) && this.diffs.size() > 0) {
                this.setVisibleModTypes(this.visibleModTypes);
            }
            if (this.filteredDiffs != null) {
                return includeSync || this.filteredDiffsNoSync == null ? this.filteredDiffs : this.filteredDiffsNoSync;
            }
            return includeSync || this.diffsNoSync == null ? this.diffs : this.diffsNoSync;
        }
        if (this.diffsNoSync == null && !includeSync) {
            this.updateFilteredDiffs();
        }
        return includeSync ? this.diffs : this.diffsNoSync;
    }

    public List<? extends MutableDiffGroup> addDiffs(List<? extends MutableDiffGroup> diffs) {
        if (diffs == null || diffs.isEmpty()) {
            return null;
        }
        if (this.diffsNoSync == null) {
            this.diffsNoSync = new ArrayList<DiffGroup>();
        }
        List<? extends MutableDiffGroup> list = this.updateDiffBounds(diffs);
        this.diffs.addAll(list);
        if (this.filteredDiffsNoSync != null) {
            int n = this.differencesLimit >= 0 ? this.differencesLimit : Integer.MAX_VALUE;
            for (DiffGroup diffGroup : this.filteredDiffs) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
                n -= diffGroup.getModifications().size();
            }
            for (DiffGroup diffGroup : list) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync) {
                    this.filteredDiffs.add(diffGroup);
                    continue;
                }
                this.diffsNoSync.add(diffGroup);
                if (n <= 0) continue;
                for (Modification modification : diffGroup.getModifications()) {
                    if (!this.visibleModTypes.contains(modification.getModificationType())) continue;
                    --n;
                    if (this.filteredDiffs.contains(diffGroup)) continue;
                    this.filteredDiffs.add(diffGroup);
                    this.filteredDiffsNoSync.add(diffGroup);
                }
            }
        } else {
            for (DiffGroup diffGroup : list) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
                this.diffsNoSync.add(diffGroup);
            }
        }
        return list;
    }

    public List<? extends MutableDiffGroup> updateDiffBounds(List<? extends MutableDiffGroup> diffs) {
        boolean bl = "CONTINUOUS".equalsIgnoreCase(this.getInfo().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        for (MutableDiffGroup mutableDiffGroup : diffs) {
            if (mutableDiffGroup.getBounds(true) == null && (mutableDiffGroup.getType() != DiffGroup.GroupType.ValidationError || mutableDiffGroup.getRemovedElements().size() > 0)) {
                mutableDiffGroup.setBounds(ResultModel.a(mutableDiffGroup, true, bl, this), true);
            }
            if (mutableDiffGroup.getBounds(false) != null || mutableDiffGroup.getType() == DiffGroup.GroupType.ValidationError && mutableDiffGroup.getAddedElements().size() <= 0) continue;
            mutableDiffGroup.setBounds(ResultModel.a(mutableDiffGroup, false, bl, this), false);
        }
        return diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, HighlightData> getHighlights() {
        LinkedHashMap<String, HighlightData> linkedHashMap = this.highlights;
        synchronized (linkedHashMap) {
            return new LinkedHashMap<String, HighlightData>(this.highlights);
        }
    }

    PageImageCache getPageImageCache() {
        return this.pageImageCache;
    }

    void setPageImageCache(PageImageCache pageImageCache) {
        this.pageImageCache = pageImageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.pageImageCache != null) {
            this.pageImageCache.clear();
        }
        this.pagesL.clear();
        this.pagesR.clear();
        this.clearDiffs();
        RunnableSession runnableSession = this.highlights;
        synchronized (runnableSession) {
            this.highlights.clear();
        }
        this.info = new InfoData(null, null, null);
        this.progress = new ProgressState(State.IDLE);
        if (SessionLocator.exists() && (runnableSession = SessionLocator.getCurrent()) instanceof PdfcSession) {
            ((PdfcSession)runnableSession).cleanUp();
        }
    }

    protected void clearDiffs() {
        this.diffs.clear();
        this.diffsNoSync = new ArrayList<DiffGroup>();
        this.filteredDiffs = null;
        this.filteredDiffsNoSync = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlight(String typeKey, HighlightData chunk) {
        LinkedHashMap<String, HighlightData> linkedHashMap = this.highlights;
        synchronized (linkedHashMap) {
            this.highlights.put(typeKey, chunk);
        }
    }

    public void setModel(ResultModel resultModel) {
        this.pagesL.forEach(p -> p.setModel(resultModel));
        this.pagesR.forEach(p -> p.setModel(resultModel));
    }

    void finish() {
    }

    @Deprecated
    boolean setVisibleTypes(Set<DiffGroup.GroupType> types) {
        HashSet<Modification.ModificationType> hashSet = new HashSet<Modification.ModificationType>();
        for (DiffGroup.GroupType groupType : types) {
            hashSet.addAll(List.of(DiffConstants.getModificationType(groupType)));
        }
        return this.setVisibleModTypes(hashSet);
    }

    boolean setVisibleModTypes(Set<Modification.ModificationType> types) {
        if (types.equals(this.visibleModTypes) && this.filteredDiffs != null) {
            return false;
        }
        this.visibleModTypes = new HashSet<Modification.ModificationType>(types);
        this.updateFilteredDiffs();
        return true;
    }

    private void updateFilteredDiffs() {
        ArrayList<DiffGroup> arrayList = new ArrayList<DiffGroup>();
        ArrayList<DiffGroup> arrayList2 = new ArrayList<DiffGroup>();
        ArrayList<DiffGroup> arrayList3 = new ArrayList<DiffGroup>();
        int n = this.differencesLimit >= 0 ? this.differencesLimit : Integer.MAX_VALUE;
        for (DiffGroup diffGroup : this.diffs) {
            if (diffGroup.getType() == DiffGroup.GroupType.Sync) {
                arrayList.add(diffGroup);
                continue;
            }
            arrayList3.add(diffGroup);
            if (n <= 0) continue;
            for (Modification modification : diffGroup.getModifications()) {
                if (!this.visibleModTypes.contains(modification.getModificationType())) continue;
                --n;
                if (arrayList.contains(diffGroup)) continue;
                arrayList.add(diffGroup);
                arrayList2.add(diffGroup);
            }
        }
        this.filteredDiffs = arrayList;
        this.filteredDiffsNoSync = arrayList2;
        this.diffsNoSync = arrayList3;
    }

    boolean setDifferencesLimit(int differencesLimit) {
        boolean bl = differencesLimit != this.differencesLimit;
        this.differencesLimit = differencesLimit;
        if (bl) {
            this.updateFilteredDiffs();
        }
        return bl;
    }

    void setComparisonID(@Nullable GUID comparisonID) {
        this.comparisonID = comparisonID;
    }

    @Nullable
    public GUID getComparisonID() {
        return this.comparisonID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultModelData createCopy() {
        ResultModelData resultModelData = new ResultModelData();
        resultModelData.differencesLimit = this.differencesLimit;
        resultModelData.diffs.addAll(this.diffs);
        resultModelData.filteredDiffs = this.filteredDiffs != null ? new ArrayList<DiffGroup>(this.filteredDiffs) : null;
        resultModelData.filteredDiffsNoSync = this.filteredDiffsNoSync != null ? new ArrayList<DiffGroup>(this.filteredDiffsNoSync) : null;
        resultModelData.diffsNoSync = this.diffsNoSync != null ? new ArrayList<DiffGroup>(this.diffsNoSync) : null;
        LinkedHashMap<String, HighlightData> linkedHashMap = this.highlights;
        synchronized (linkedHashMap) {
            resultModelData.highlights.putAll(this.highlights);
        }
        resultModelData.info = this.info;
        resultModelData.pageImageCache = this.pageImageCache;
        resultModelData.pagesL.addAll(this.pagesL);
        resultModelData.pagesR.addAll(this.pagesR);
        resultModelData.progress = this.progress;
        resultModelData.visibleTypes = new HashSet<DiffGroup.GroupType>(this.visibleTypes);
        resultModelData.visibleModTypes = new HashSet<Modification.ModificationType>(this.visibleModTypes);
        resultModelData.comparisonID = this.comparisonID;
        return resultModelData;
    }
}

