/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter.impl;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.core.OS;
import com.inet.lib.util.ColorUtils;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ArrayPdfSource;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.OutputStreamProvider;
import com.inet.pdfc.presenter.impl.datasource.ReportDataProvider;
import com.inet.pdfc.print.DisclaimerPrinter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.structure.PdfcStructureProvider;
import com.inet.pdfc.util.FileNameUtil;
import com.inet.pdfc.util.VersionData;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.StorageEntry;
import com.inet.report.Engine;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.output.DocumentOutput;
import com.inet.report.output.DocumentOutputStream;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.awt.Color;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReportPDFPresenterImpl
extends BasePresenter
implements Cloneable {
    private boolean pA;
    private boolean pB;
    private boolean pC;
    private OutputStreamProvider pG;
    private String pE;
    private String password;
    private boolean pL;
    private String pM;
    private String pN;
    private boolean pO = true;
    public static final String BATCH_PROFILE_KEY = "BatchProfile";
    private IProfile profile;

    @Nonnull
    public String getExtensionName() {
        return "Presenter_Report";
    }

    ReportPDFPresenterImpl(boolean showDiagrams, boolean showDifferences, boolean appendSettings, OutputStreamProvider provider, String exportFormat, @Nullable String password) {
        this.pA = showDiagrams;
        this.pB = showDifferences;
        this.pC = appendSettings;
        this.pG = provider;
        this.pE = exportFormat;
        this.password = password;
    }

    public ReportPDFPresenterImpl(boolean showDiagrams, boolean showDifferences, boolean appendSettings, boolean onlyComparisonsWithDiffs, OutputStreamProvider provider, String exportFormat, @Nullable String password, String batchFolder1, String batchFolder2, IProfile profile) {
        this.pA = showDiagrams;
        this.pB = showDifferences;
        this.pC = appendSettings;
        this.pG = provider;
        this.pE = exportFormat;
        this.password = password;
        this.pM = batchFolder1;
        this.pN = batchFolder2;
        this.pO = onlyComparisonsWithDiffs;
        this.profile = profile;
        this.pL = true;
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        ReportPDFPresenterImpl reportPDFPresenterImpl = new ReportPDFPresenterImpl(this.pA, this.pB, this.pC, this.pO, this.pG, this.pE, this.password, this.pM, this.pN, this.profile);
        reportPDFPresenterImpl.pL = this.pL;
        return reportPDFPresenterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComparisonDone() throws Exception {
        Object object;
        Object object2;
        ResultModel resultModel = this.getModel();
        if (this.pL) {
            if (!ReportDataProvider.hasResultProvider()) {
                return;
            }
        } else {
            if (resultModel == null) {
                return;
            }
            if (resultModel.getDifferencesCount(true) == 0 && resultModel.getSettings().isEnabled(Settings.EXPORT.ONLY_ON_DIFFERENCES)) {
                LOGGER.info((Object)Msg.getMsg("Export.doNothingNoDiffsReport", resultModel.getComparisonParameters().getFirstFile().getName(), resultModel.getComparisonParameters().getSecondFile().getName()));
                return;
            }
        }
        switch (this.pE = this.pE != null ? this.pE.toLowerCase() : "pdf") {
            case "pdf": 
            case "ods": 
            case "rtf": 
            case "xls": 
            case "xlsx": 
            case "htm.zip": {
                break;
            }
            case "html": 
            case "htm": {
                this.pE = "htm.zip";
                break;
            }
            default: {
                this.pE = "pdf";
            }
        }
        String string = ConfigurationManager.getInstance().getCurrent();
        string.put(ConfigKey.ROWSOURCE_CACHE_ENABLED, "false");
        string.put(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS, "true");
        string.put(ConfigKey.PDF_REPLACE_MISSING_CHAR, "true");
        Object object3 = string.get(ConfigKey.FONT_PATH);
        if (object3 == null || ((String)object3).isBlank()) {
            if (OS.isWindows()) {
                object2 = System.getenv("windir");
                object3 = (String)(object2 != null ? object2 : "C:\\Windows") + "\\Fonts\\";
            } else if (OS.isLinux()) {
                object3 = "/usr/share/fonts";
            } else if (OS.isMac()) {
                object3 = "/System/Library/Fonts";
            }
            string.put(ConfigKey.FONT_PATH, (String)object3);
        }
        if ((object2 = string.get(ConfigKey.FORMULA_EXPANDER_CLASS)) == null) {
            object2 = DisclaimerPrinter.class.getName();
        } else if (!((String)object2).contains(DisclaimerPrinter.class.getName())) {
            object2 = (String)object2 + ";" + DisclaimerPrinter.class.getName();
        }
        string.put(ConfigKey.FORMULA_EXPANDER_CLASS, (String)object2);
        Engine engine = new Engine(this.pE);
        if (this.pL) {
            ReportPDFPresenterImpl.setPropertiesToEngineBatchResult(engine, this.profile, this.pA, this.pB, this.pC, this.pO, this.pM, this.pN);
        } else {
            ReportPDFPresenterImpl.setPropertiesToEngineSingleResult(engine, resultModel, this.pA, this.pB, this.pC, false);
        }
        if (this.pE.equalsIgnoreCase("pdf") && this.password != null && this.password.length() > 0) {
            object = new Properties();
            ((Properties)object).setProperty("upass", this.password);
            engine.setUserProperties((Properties)object);
        }
        engine.getSummaryInfo().setAuthor(VersionData.getProductName());
        object = this.pG.getExportStream();
        try {
            if (!this.pE.equals("xls") && !this.pE.equals("rtf")) {
                engine.setDocumentOutput((DocumentOutput)new DocumentOutputStream((OutputStream)object, false));
                engine.execute();
                engine.getPageCount();
            } else {
                engine.execute();
                for (int i = 1; i <= engine.getPageCount(); ++i) {
                    ((OutputStream)object).write(engine.getPageData(i));
                }
            }
        }
        finally {
            ((OutputStream)object).close();
        }
    }

    public static void setPropertiesToEngineSingleResult(@Nonnull Engine engine, @Nonnull ResultModel comparisonModel, boolean showDiagrams, boolean showDifferences, boolean appendSettings, boolean isPreview) throws Exception {
        LinkedHashMap<String, ReportDataProvider.ComparisonDataProvider> linkedHashMap = new LinkedHashMap<String, ReportDataProvider.ComparisonDataProvider>();
        String string = FileNameUtil.getDefaultExportName("report", comparisonModel, new BasePresenter(){

            @Nonnull
            public String getExtensionName() {
                return "report";
            }

            @Override
            protected void onComparisonDone() throws Exception {
            }
        });
        linkedHashMap.put(GUID.generateNew().toString(), new ReportDataProvider.ResultModelDataProvider(string, comparisonModel));
        ResultModelData resultModelData = new ResultModelData();
        resultModelData.setInfo(new InfoData(new ArrayPdfSource("", 0L, new byte[0]), new ArrayPdfSource("", 0L, new byte[0]), 0, 0, comparisonModel.getComparisonParameters().getProfile()));
        ResultModel resultModel = new ResultModel(resultModelData);
        linkedHashMap.put(BATCH_PROFILE_KEY, new ReportDataProvider.ResultModelDataProvider("Profile", resultModel));
        ReportDataProvider.setResultProviderForSession(linkedHashMap);
        ReportPDFPresenterImpl.a(engine, false, showDiagrams, showDifferences, false, appendSettings, isPreview, null, null, ReportPDFPresenterImpl.a(comparisonModel));
    }

    @Nonnull
    private static String a(@Nonnull ResultModel resultModel) {
        Object object = "[";
        for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
            Color color = resultModel.getSettings().getColor(modificationType);
            object = ((String)object).length() <= 1 ? (String)object + ColorUtils.toCcColor((Color)new Color(color.getRed(), color.getGreen(), color.getBlue())) : (String)object + "," + ColorUtils.toCcColor((Color)new Color(color.getRed(), color.getGreen(), color.getBlue()));
        }
        object = (String)object + "]";
        return object;
    }

    public static void setPropertiesToEngineBatchResult(@Nonnull Engine engine, @Nonnull IProfile profile, boolean showDiagrams, boolean showDifferences, boolean appendSettings, boolean onlyComparisonsWithDiffs, @Nonnull String batchFolder1, @Nonnull String batchFolder2) throws Exception {
        if (!ReportDataProvider.hasResultProvider()) {
            throw new IllegalStateException("A result data provider has to be set to the current session in order for the report to be generated!");
        }
        ResultModelData resultModelData = new ResultModelData();
        resultModelData.setInfo(new InfoData(new ArrayPdfSource("", 0L, new byte[0]), new ArrayPdfSource("", 0L, new byte[0]), 0, 0, profile));
        ResultModel resultModel = new ResultModel(resultModelData);
        ReportDataProvider.addResultProviderForSession(BATCH_PROFILE_KEY, new ReportDataProvider.ResultModelDataProvider("Profile", resultModel));
        ReportPDFPresenterImpl.a(engine, onlyComparisonsWithDiffs, showDiagrams, showDifferences, onlyComparisonsWithDiffs, appendSettings, false, batchFolder1, batchFolder2, ReportPDFPresenterImpl.a(resultModel));
    }

    private static void a(@Nonnull Engine engine, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, @Nullable String string, @Nullable String string2, String string3) throws Exception {
        URL uRL;
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"com.inet.pdfc.presenter.impl.datasource.ComparisonResultDataFactory");
        if (dataSourceConfiguration == null) {
            dataSourceConfiguration = DataSourceConfigurationManager.createDataSourceConfiguration((String)"com.inet.pdfc.presenter.impl.datasource.ComparisonResultDataFactory", (int)4);
            dataSourceConfiguration.setDatabaseClassname("com.inet.pdfc.presenter.impl.datasource.ComparisonResultDataFactory");
            dataSourceConfiguration.save();
        }
        URL uRL2 = ReportPDFPresenterImpl.class.getResource("/com/inet/pdfc/presenter/PDFCReport.rpt");
        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("report/PDFCReport.rpt");
        if (persistenceEntry.exists() && persistenceEntry.size() > 0L) {
            PDFCCore.LOGGER_PRESENTER.info((Object)"ReportPresenter: Using external report file 'PDFCReport.rpt'");
            uRL2 = persistenceEntry.toURL();
        }
        engine.setReportFile(uRL2);
        engine.setLocale(ClientLocale.getThreadLocale());
        engine.setPrompt("ShowDiagrams", Boolean.toString(bl2));
        engine.setPrompt("showDifferences", Boolean.toString(bl3));
        engine.setPrompt("addCmpSettings", Boolean.toString(bl5));
        engine.setPrompt("isBatch", Boolean.toString(bl));
        if (bl) {
            engine.setPrompt("batchFolder1", string);
            engine.setPrompt("batchFolder2", string2);
            engine.setPrompt("OnlyComparisonsWithDiffs", Boolean.toString(bl4));
        } else {
            engine.setPrompt("batchFolder1", "");
            engine.setPrompt("batchFolder2", "");
            engine.setPrompt("OnlyComparisonsWithDiffs", Boolean.toString(false));
        }
        engine.setPrompt("FooterText", ConfigurationManager.getInstance().getCurrent().get(PdfcStructureProvider.KEY_EXPORT_FOOTER));
        URL uRL3 = uRL = bl6 ? null : DisclaimerPrinter.getDisclaimerURL();
        if (uRL != null) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                StorageEntry storageEntry = StorageEntry.resolve((URL)uRL);
                if (storageEntry == null || !storageEntry.exists()) {
                    uRL = null;
                }
            }
        }
        engine.setPrompt("Disclaimer", Boolean.toString(uRL != null));
        engine.setPrompt("ProductName", VersionData.getProductName());
        engine.setPrompt("ChartColor", string3);
    }

    static {
        Engine.setCreator((String)VersionData.getCreatorString(true));
    }
}

