/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.i18n.Msg;
import com.inet.persistence.RandomAccessRead;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@JsonData
@PublicApi
public class FilePdfSource
extends PdfSource {
    private transient File document;

    public FilePdfSource(File document) {
        super(document.getName(), document.getAbsolutePath(), document.lastModified(), document.length());
        if (!document.exists()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.DoesNotExist", document.getName()));
        }
        if (!document.canRead()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.CannotRead", document.getName()));
        }
        if (document.isDirectory()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.IsDiretory", document.getName()));
        }
        this.document = document;
    }

    public FilePdfSource(File pdfFile, String explicitName) {
        this(pdfFile);
        this.getMetaProperties().put("NAME", explicitName);
    }

    public FilePdfSource(File pdfFile, String explicitName, boolean setNoMetaPath) {
        this(pdfFile, explicitName);
        if (setNoMetaPath) {
            this.getMetaProperties().remove("PATH");
        }
    }

    @Override
    public long getLastModified() {
        return this.document.lastModified();
    }

    @Override
    public long getSize() {
        return this.document.length();
    }

    @Override
    public String getPath() {
        String string = super.getPath();
        if (string == null) {
            string = this.document.getAbsolutePath();
        }
        return string;
    }

    @Override
    public RandomAccessRead getContent() throws IOException {
        return RandomAccessRead.wrap((File)this.document);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.document);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.document = (File)stream.readObject();
    }
}

