/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.pdfparser;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.error.ErrorCode;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.plugin.interfaces.DocumentFontListener;
import com.inet.pdfc.plugin.pdfparser.PDFDocument;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.FileBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.data.RandomAccessBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.FontGenerationListener;
import com.inet.persistence.RandomAccessRead;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@InternalApi
public class PDFDocumentFactory
implements DocumentFactory {
    private static final I18nMessages MSG = new I18nMessages("com.inet.pdfc.plugin.pdfparser.structure.i18n.ConfigStructure", PDFDocumentFactory.class);

    @Override
    public Set<String> getSupportedFileExtensions() {
        return new HashSet<String>(){
            {
                this.add("pdf");
            }
        };
    }

    @Override
    public String getDocumentTypeName(Locale locale) {
        return MSG.getMsg(locale, "plugin.pdf.docname", new Object[0]);
    }

    @Override
    public boolean canRead(String userFileName, byte[] content) {
        if (content == null || content.length < 8) {
            return false;
        }
        if (userFileName.toLowerCase().contains("toimage")) {
            return false;
        }
        int n = Math.min(content.length - 4, 16384);
        for (int i = 0; i < n; ++i) {
            if (content[i] != 37 || content[i + 1] != 80 || content[i + 2] != 68 || content[i + 3] != 70 || content[i + 4] != 45) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canRead(String userFileName, File file) {
        boolean bl;
        if (file == null || !file.isFile() || file.length() < 8L) {
            return false;
        }
        if (userFileName.toLowerCase().contains("toimage")) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = new byte[16384];
            ((InputStream)fileInputStream).read(byArray);
            bl = this.canRead(file.getName(), byArray);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.debug((Object)iOException);
                return false;
            }
        }
        ((InputStream)fileInputStream).close();
        return bl;
    }

    @Override
    public boolean canRead(String userFileName, RandomAccessRead document) {
        try {
            if (document == null || document.length() < 8L) {
                return false;
            }
            if (userFileName.toLowerCase().contains("toimage")) {
                return false;
            }
            byte[] byArray = new byte[16384];
            document.read(byArray);
            return this.canRead(userFileName, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Document readDocumentReduced(byte[] data, String name, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        try {
            return new PDFDocument(ArrayBuffer.wrap((byte[])data), name, password, this.getFontGenerationListener(), requiredFeatures);
        }
        catch (PDFDecrypter.DecryptionExcpetion decryptionExcpetion) {
            throw new DocumentFactory.PasswordException(decryptionExcpetion.getCause(), decryptionExcpetion.getFilename(), decryptionExcpetion.wasUsingPassword());
        }
        catch (PDFParseException pDFParseException) {
            throw PdfcException.create(pDFParseException);
        }
    }

    @Override
    public Document readDocumentReduced(String userFileName, File file, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        PDFDocument pDFDocument;
        FileBuffer fileBuffer = new FileBuffer(file);
        try {
            pDFDocument = new PDFDocument((IDataBuffer)fileBuffer, userFileName, password, this.getFontGenerationListener(), requiredFeatures);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PDFDecrypter.DecryptionExcpetion decryptionExcpetion) {
                throw new DocumentFactory.PasswordException(decryptionExcpetion.getCause(), userFileName, decryptionExcpetion.wasUsingPassword());
            }
            catch (PDFParseException pDFParseException) {
                throw PdfcException.create(pDFParseException);
            }
            catch (IOException iOException) {
                throw PdfcException.create((ErrorCode)PdfcErrorCode.cannotReadDocument, iOException, new Object[0]);
            }
        }
        fileBuffer.close();
        return pDFDocument;
    }

    @Override
    public Document readDocumentReduced(String userFileName, RandomAccessRead document, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        try {
            return new PDFDocument((IDataBuffer)new RandomAccessBuffer(document), userFileName, password, this.getFontGenerationListener(), requiredFeatures);
        }
        catch (PDFDecrypter.DecryptionExcpetion decryptionExcpetion) {
            throw new DocumentFactory.PasswordException(decryptionExcpetion.getCause(), userFileName, decryptionExcpetion.wasUsingPassword());
        }
        catch (PDFParseException pDFParseException) {
            throw PdfcException.create(pDFParseException);
        }
        catch (IOException iOException) {
            throw PdfcException.create((ErrorCode)PdfcErrorCode.cannotReadDocument, iOException, new Object[0]);
        }
    }

    public FontGenerationListener getFontGenerationListener() {
        a a2 = null;
        List<DocumentFontListener> list = PluginManager.get(DocumentFontListener.class);
        if (list.size() > 0) {
            a2 = new a(list);
        }
        return a2;
    }

    private class a
    implements FontGenerationListener {
        private List<DocumentFontListener> no = new ArrayList<DocumentFontListener>();

        public a(List<DocumentFontListener> list) {
            if (list != null) {
                this.no.addAll(list);
            }
        }

        public void fontGenerated(Font font, byte[] fontFileData, Map<Character, char[]> cmapAddition) {
            for (DocumentFontListener documentFontListener : this.no) {
                documentFontListener.fontGenerated(font, fontFileData, cmapAddition);
            }
        }
    }
}

