/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.pdfparser;

import com.inet.annotations.InternalApi;
import com.inet.cache.image.SerializableImage;
import com.inet.encoder.pdf.PDFParserPlugin;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.bidi.BidiSortFilter;
import com.inet.pdfc.generator.model.text.TextModuleUtils;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.generator.rendercache.SerializableImageCache;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.DocumentProgressListener;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.ImageMetaData;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TagElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.model.controls.ControlElement;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.plugin.pdfparser.FontInfoCache;
import com.inet.pdfc.plugin.pdfparser.PDFParserProperties;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.control.ControlData;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.FontGenerationListener;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.otf.OTFFactory;
import com.inet.pdfview.structure.StructureType;
import com.inet.shared.bidi.BidiString;
import com.inet.thread.SessionLocator;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PDFDocument
implements Document {
    private static final Map<StructureType, ElementType> mv = new HashMap<StructureType, ElementType>();
    private PDFFile mw;
    private FontInfoCache mr = new FontInfoCache(true);
    private e mx;
    private Document.TextOrientation my = Document.TextOrientation.LEFTTORIGHT;
    public static final String ORIGINALORDER_FILTER_KEY = "ORIGINALORDER";

    public PDFDocument(IDataBuffer buf, String filename, String password, FontGenerationListener fontGenerationListener, DocumentFactory.FEATURE ... requiredFeatures) throws PDFParseException {
        Properties properties;
        String string;
        this.mx = new e(this.mr, requiredFeatures);
        this.mw = new PDFFile(buf, filename, password, (CacheAccess)new a(fontGenerationListener, this.mr, PDFDocument.bJ()), (ParserListener)this.mx);
        if (PdfcSession.hasSession() && "true".equals(string = (properties = PdfcSession.getSession().getSessionProperties()).getProperty("ocr.active"))) {
            this.mw.setDownScaling(false);
        }
        this.mr.setCrystalReportsExport(this.mw.isCrystalReportExport());
        this.mr.setIgnoreUnicodeMapping(this.mx.doRead(ParserListener.ELEMENT_TYPE.textNoCharMapping));
    }

    private static SerializableImageCache bJ() {
        if (SessionLocator.exists() && SessionLocator.getCurrent() instanceof PdfcSession) {
            PdfcSession pdfcSession = (PdfcSession)SessionLocator.getCurrent();
            return pdfcSession.getStoreMap();
        }
        return null;
    }

    @Override
    public Document.TextOrientation getTextOrientation() {
        return this.my;
    }

    @Override
    public Map<String, String> getMetaData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.mw.getCreationDate() != null) {
            hashMap.put("creationDate", PDFParserPlugin.convertPDFTimeToMillis((String)this.mw.getCreationDate()));
        }
        if (this.mw.getModDate() != null) {
            hashMap.put("modifiedDate", PDFParserPlugin.convertPDFTimeToMillis((String)this.mw.getModDate()));
        }
        if (this.mw.getCreator() != null || this.mw.getProducer() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mw.getProducer() != null && !this.mw.getProducer().isBlank()) {
                stringBuilder.append(this.mw.getProducer());
            }
            if (this.mw.getCreator() != null && !this.mw.getCreator().isBlank() && !this.mw.getCreator().equals(stringBuilder.toString())) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.mw.getCreator());
            }
            hashMap.put("producer", stringBuilder.toString());
        }
        if (this.mw.getTitle() != null && !this.mw.getTitle().isBlank()) {
            hashMap.put("title", this.mw.getTitle());
        }
        if (this.mw.getAuthor() != null && !this.mw.getAuthor().isBlank()) {
            hashMap.put("author", this.mw.getAuthor());
        }
        if (Objects.equals(hashMap.get("producer"), hashMap.get("author"))) {
            hashMap.remove("author");
        }
        return hashMap;
    }

    @Override
    public void setProfile(IProfile profile) {
        String string;
        if (profile.getBool(PDFParserProperties.SCAN_OTF_DIRECTORIES)) {
            string = profile.getString(PDFParserProperties.OTF_DIRECTORIES);
            String[] stringArray = string.split(";");
            boolean bl = false;
            Object object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string2 = object[i];
                if (string2.trim().isEmpty()) continue;
                bl = true;
                break;
            }
            if (!bl && ((String)(object = System.getProperty("os.name").toLowerCase())).contains("os x")) {
                stringArray = new String[2];
                stringArray[0] = "/Library/Fonts";
                String string3 = System.getProperty("user.home");
                stringArray[1] = string3 + "/Library/Fonts";
                bl = true;
            }
            if (bl) {
                OTFFactory.getInstance().getPool().init(stringArray);
            }
        }
        string = profile.getString(PDFCProperty.FILTERS);
        this.mx.mZ = string.contains(ORIGINALORDER_FILTER_KEY);
        this.mx.na = SettingUtil.isParseStructure(profile);
        if (this.mx.na) {
            this.mx.nk = true;
        }
    }

    private int bK() {
        return this.mw.getNumPages();
    }

    public Page getPage(int pageIndex) throws DocumentFactory.PasswordException {
        if (pageIndex >= 0 && pageIndex < this.bK()) {
            PDFPage pDFPage = this.mw.getPage(pageIndex);
            Exception exception = pDFPage.getRecentError();
            if (exception != null) {
                if (exception instanceof PDFDecrypter.DecryptionExcpetion) {
                    PDFDecrypter.DecryptionExcpetion decryptionExcpetion = (PDFDecrypter.DecryptionExcpetion)((Object)exception);
                    throw new DocumentFactory.PasswordException(decryptionExcpetion.getCause(), decryptionExcpetion.getFilename(), decryptionExcpetion.wasUsingPassword());
                }
                this.mx.mT.a(exception);
            }
            if (pageIndex != this.mx.mT.getPageIndex()) {
                if (exception != null) {
                    throw new IllegalStateException("Cannot read page #" + (pageIndex + 1) + " due to an error: " + exception.getMessage(), exception);
                }
                throw new IllegalStateException("Inconsistent page: requested " + (pageIndex + 1) + ", got " + (this.mx.mT.getPageIndex() + 1));
            }
            this.mx.bU();
            return this.mx.mT;
        }
        return null;
    }

    @Override
    public EnumerationProgress getPages(DocumentProgressListener listener, int skip) {
        return new b(listener, skip, -1);
    }

    @Override
    public EnumerationProgress getPages(DocumentProgressListener listener, int skip, int numOfPages) throws RuntimeException {
        return new b(listener, skip, numOfPages);
    }

    @Override
    public void close() {
        this.mw.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.mw.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public int getEstimatedPageNum() {
        return this.bK();
    }

    static {
        mv.put(StructureType.P, ElementType.Paragraph);
        mv.put(StructureType.H, ElementType.Paragraph);
        mv.put(StructureType.H1, ElementType.Paragraph);
        mv.put(StructureType.H2, ElementType.Paragraph);
        mv.put(StructureType.H3, ElementType.Paragraph);
        mv.put(StructureType.H4, ElementType.Paragraph);
        mv.put(StructureType.H5, ElementType.Paragraph);
        mv.put(StructureType.H6, ElementType.Paragraph);
        mv.put(StructureType.Div, ElementType.Block);
        mv.put(StructureType.Figure, ElementType.LayoutGroup);
        mv.put(StructureType.L, ElementType.LayoutGroup);
        mv.put(StructureType.Table, ElementType.Table);
        mv.put(StructureType.TD, ElementType.TableCell);
    }

    public static class e
    implements ParserListener {
        private com.inet.pdfc.plugin.pdfparser.c mT;
        private d mU;
        private final double mV = 5.0;
        private long mW;
        private long mX;
        private FontInfoCache mr;
        private StructureElement mY;
        private boolean mZ;
        private boolean na;
        private LinkedList<f> nb;
        private StructureElement nc = null;
        private int nd;
        private ElementID ne;
        private boolean nf = true;
        private boolean ng = false;
        private boolean nh = true;
        private boolean ni = true;
        private boolean nj = true;
        private boolean nk = true;

        public e(FontInfoCache fontInfoCache, DocumentFactory.FEATURE ... fEATUREArray) {
            if (fEATUREArray != null) {
                this.nf = false;
                this.nh = false;
                this.ni = false;
                this.nj = false;
                this.nk = false;
                block8: for (DocumentFactory.FEATURE fEATURE : fEATUREArray) {
                    switch (fEATURE) {
                        case text: {
                            this.nf = true;
                            continue block8;
                        }
                        case shapes: {
                            this.nh = true;
                            continue block8;
                        }
                        case textNoCharMapping: {
                            this.ng = true;
                            this.nf = true;
                            continue block8;
                        }
                        case images: {
                            this.ni = true;
                            continue block8;
                        }
                        case meta: {
                            this.nj = true;
                            continue block8;
                        }
                        case structure: {
                            this.nk = true;
                            continue block8;
                        }
                    }
                }
            }
            this.mr = fontInfoCache;
        }

        public boolean doRead(ParserListener.ELEMENT_TYPE type) {
            switch (type) {
                case text: {
                    return this.nf;
                }
                case textNoCharMapping: {
                    return this.ng;
                }
                case shape: {
                    return this.nh;
                }
                case image: {
                    return this.ni;
                }
                case annotation: {
                    return this.nj;
                }
                case structure: {
                    return this.nk;
                }
            }
            return true;
        }

        private boolean bO() {
            return this.mW - this.mX > 0L;
        }

        public void startPage(PDFPage page) {
            this.mY = null;
            this.nb = null;
            this.mT = new com.inet.pdfc.plugin.pdfparser.c(page);
            this.nd = page.getPageIndex();
            this.ne = new ElementID(this.nd).getDescendant();
        }

        private ElementID bP() {
            ElementID elementID = this.ne;
            this.ne = this.ne.getNext();
            return elementID;
        }

        public com.inet.pdfc.plugin.pdfparser.c bQ() {
            return this.mT;
        }

        public void addTextElement(PDFFont font, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar, boolean hasUnicodemapping) {
            int n;
            int n2;
            Object object;
            Object object2;
            FontInfo fontInfo = this.mr.getFontInfo(font);
            this.mW += BidiString.getNumberOfRightChar((String)text);
            this.mX += BidiString.getNumberOfLeftChar((String)text);
            if (!((String)text).isEmpty() && (BidiString.hasRightToLeftChars((String)text) || BidiString.hasArabicCharacters((String)text))) {
                Object object3;
                object2 = this.c((String)text, charWidths, kerning);
                if (((String)object2).isEmpty()) {
                    return;
                }
                if (((String)object2).length() != ((String)text).length()) {
                    object = new double[((String)object2).length()];
                    object3 = new double[((String)object2).length()];
                    n2 = 0;
                    for (n = 0; n < ((double[])object).length; ++n) {
                        while (charWidths[n2] == -1.0) {
                            ++n2;
                        }
                        object[n] = charWidths[n2];
                    }
                    if (kerning != null) {
                        n2 = 0;
                        for (n = 0; n < ((double[])object3).length; ++n) {
                            while (kerning[n2] == -1.0) {
                                ++n2;
                            }
                            object3[n] = kerning[n2];
                        }
                    }
                    charWidths = object;
                    kerning = object3;
                    text = object2;
                }
                if (((String)text).length() == 1 && charWidths[0] == 0.0) {
                    charWidths[0] = 1.0;
                }
                if (this.mU != null && Math.abs(this.mU.bN() - transform.getTranslateY()) >= 5.0) {
                    this.bT();
                    this.mU = null;
                }
                if (this.mU == null) {
                    object = this.bS();
                    object3 = new TextElement(fontInfo, fontSize, transform, (String)text, fillPaint, strokePaint, charWidths, kerning, replaceZeroChar, hasUnicodemapping, this.bP());
                    this.mU = new d(this.nd, ((TextElement)object3).getY());
                    this.mU.a((TextElement)object3);
                    this.mU.i(this.bS().size());
                    double d2 = transform.getTranslateY();
                    ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>();
                    for (int i = object.size() - 1; i >= 0; --i) {
                        DrawableElement drawableElement = (DrawableElement)object.get(i);
                        if (drawableElement.getType() != ElementType.Text || !(Math.abs(drawableElement.getY() - d2) < 5.0)) continue;
                        this.mU.a((TextElement)drawableElement);
                        arrayList.add(drawableElement);
                    }
                    for (DrawableElement drawableElement : arrayList) {
                        object.remove(drawableElement);
                    }
                    return;
                }
            }
            if (!((String)text).isEmpty()) {
                if (this.mU != null && Math.abs(this.mU.bN() - transform.getTranslateY()) < 5.0) {
                    object2 = new TextElement(fontInfo, fontSize, transform, (String)text, fillPaint, strokePaint, charWidths, kerning, replaceZeroChar, hasUnicodemapping, this.bP());
                    this.mU.a((TextElement)object2);
                    this.mU.i(this.bS().size());
                    return;
                }
                if (this.mU != null) {
                    this.bT();
                }
                boolean bl = false;
                if (kerning != null) {
                    for (int i = 1; i < kerning.length; ++i) {
                        if (!(kerning[i] < -charWidths[i - 1] / 2.0)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    Object object4;
                    double[] dArray;
                    Object object5;
                    double d3 = 0.0;
                    n = 0;
                    for (n2 = 1; n2 < kerning.length; ++n2) {
                        d3 += charWidths[n2 - 1];
                        if (!(kerning[n2] < -charWidths[n2 - 1] / 2.0)) continue;
                        object5 = ((String)text).substring(n, n2);
                        dArray = Arrays.copyOfRange(charWidths, n, n2);
                        object4 = Arrays.copyOfRange(kerning, n, n2);
                        if (n > 0) {
                            object4[0] = 0.0;
                        }
                        int n3 = n2;
                        charWidths[n3] = charWidths[n3] - kerning[n2];
                        TextElement textElement = new TextElement(fontInfo, fontSize, transform, (String)object5, fillPaint, strokePaint, dArray, (double[])object4, replaceZeroChar, hasUnicodemapping, this.bP());
                        this.d(textElement);
                        transform = new AffineTransform(transform);
                        transform.translate(d3 += kerning[n2], 0.0);
                        d3 = 0.0;
                        n = n2;
                    }
                    if (n < kerning.length) {
                        String string = ((String)text).substring(n, kerning.length);
                        object5 = Arrays.copyOfRange(charWidths, n, kerning.length);
                        dArray = Arrays.copyOfRange(kerning, n, kerning.length);
                        dArray[0] = 0.0;
                        object4 = new TextElement(fontInfo, fontSize, transform, string, fillPaint, strokePaint, (double[])object5, dArray, replaceZeroChar, hasUnicodemapping, this.bP());
                        this.d((TextElement)object4);
                    }
                } else {
                    object = new TextElement(fontInfo, fontSize, transform, (String)text, fillPaint, strokePaint, charWidths, kerning, replaceZeroChar, hasUnicodemapping, this.bP());
                    this.d((TextElement)object);
                }
            }
        }

        private TextElement bR() {
            List<TextElement> list = this.mU.bL();
            TextElement textElement = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                textElement = this.b(textElement, list.get(i));
            }
            this.mU = null;
            return textElement;
        }

        private void d(TextElement textElement) {
            textElement.setPageIndex(this.nd);
            if (this.mZ && this.nb == null && !this.na) {
                if (this.mY == null) {
                    this.mY = new StructureElement(ElementType.Paragraph, textElement.getBounds(), null, this.mT.getPageIndex(), this.bP());
                }
                if (this.mY.getChildren().isEmpty()) {
                    this.mY.getChildren().add(textElement);
                    this.mT.getElementList().addDrawableElement(this.mY);
                } else {
                    DrawableElement drawableElement = this.mY.getChildren().get(this.mY.getChildren().size() - 1);
                    if (textElement.getY() < drawableElement.getY() - Math.abs(drawableElement.getBounds().getHeight())) {
                        this.a(this.mY);
                        this.mY = new StructureElement(ElementType.Paragraph, textElement.getBounds(), null, this.mT.getPageIndex(), this.bP());
                        this.mT.getElementList().addDrawableElement(this.mY);
                    }
                    this.mY.getChildren().add(textElement);
                }
            } else {
                this.addElement(textElement);
            }
        }

        private List<DrawableElement> bS() {
            return this.mY != null ? this.mY.getChildren() : this.mT.getElementList().getList();
        }

        private void bT() {
            ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>();
            ArrayList<TextElement> arrayList2 = new ArrayList<TextElement>();
            ElementList elementList = this.mT.getElementList();
            if (this.bO()) {
                int n;
                int n2;
                TextElement textElement = this.bR();
                String string = new StringBuilder(textElement.getText()).reverse().toString();
                double[] dArray = textElement.getCharacterWidths();
                for (int i = 0; i < dArray.length / 2; ++i) {
                    double d2 = dArray[i];
                    dArray[i] = dArray[dArray.length - i - 1];
                    dArray[dArray.length - i - 1] = d2;
                }
                double[] dArray2 = textElement.getKerningArray();
                for (n2 = 0; n2 < dArray2.length / 2; ++n2) {
                    double d3 = dArray2[n2];
                    dArray2[n2] = dArray2[dArray2.length - n2 - 1];
                    dArray2[dArray2.length - n2 - 1] = d3;
                }
                for (n2 = dArray2.length - 1; n2 > 1; --n2) {
                    dArray2[n2] = dArray2[n2 - 1];
                }
                string = this.a(string, dArray, new double[dArray2.length]);
                string = this.b(string, dArray, new double[dArray2.length]);
                n2 = 0;
                for (n = 0; n < string.length() && TextModuleUtils.isWhitespace(string.charAt(n)); n += 1) {
                    ++n2;
                }
                if (n2 != 0) {
                    string = string.substring(n2);
                    dArray = Arrays.copyOfRange(dArray, n2, dArray.length);
                    dArray2 = Arrays.copyOfRange(dArray2, n2, dArray2.length);
                }
                textElement.setText(string);
                textElement.setCharWidths(dArray);
                textElement.setKerning(dArray2);
                arrayList2.add(textElement);
                n = 1;
                if (PdfcSession.hasSession()) {
                    n = !"true".equals(PdfcSession.getSession().getSessionProperties().getProperty("filter.nobreakiterator")) ? 1 : 0;
                }
                TextModuleUtils.convertText(0, arrayList2, arrayList, new TextModuleUtils.StyleState(), null, n != 0);
                DrawableElement drawableElement = arrayList.get(arrayList.size() - 1);
                double d4 = drawableElement.getX() + drawableElement.getBounds().getWidth() - (textElement.getX() + textElement.getBounds().getWidth());
                BidiSortFilter.swapElementsBounds(0, arrayList.size() - 1, arrayList, d4);
                for (DrawableElement drawableElement2 : arrayList) {
                    ((WordElement)drawableElement2).setStartPointX(new Point2D.Double(drawableElement2.getX(), drawableElement2.getY()));
                    Rectangle2D rectangle2D = drawableElement2.getBounds();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    ((WordElement)drawableElement2).setBounds(double_);
                    elementList.addDrawableElement(drawableElement2);
                }
            } else {
                if (this.mU.bM() >= 0 && this.mU.bM() < elementList.getList().size()) {
                    elementList.getList().addAll(this.mU.bM(), this.mU.bL());
                } else {
                    elementList.getList().addAll(this.mU.bL());
                }
                this.mU = null;
            }
        }

        private String a(String string, double[] dArray, double[] dArray2) {
            return this.a(string, dArray, dArray2, 0, string.length());
        }

        private String a(String string, double[] dArray, double[] dArray2, int n, int n2) {
            char[] cArray = string.toCharArray();
            int n3 = -1;
            int n4 = -1;
            for (int i = n; i < n2; ++i) {
                if (BidiString.isNeutralType((char)cArray[i]) && cArray[i] != ',' && cArray[i] != '.' && cArray[i] != ' ' && cArray[i] != '/' && cArray[i] != '\"') {
                    if (n3 == -1) {
                        n3 = i;
                    }
                    n4 = i;
                    continue;
                }
                if (n3 == -1) continue;
                this.a(cArray, n3, n4, dArray, dArray2);
                n3 = -1;
                n4 = -1;
            }
            if (n3 != -1) {
                this.a(cArray, n3, n4, dArray, dArray2);
            }
            return new String(cArray);
        }

        private String b(String string, double[] dArray, double[] dArray2) {
            char[] cArray = string.toCharArray();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == '/' || cArray[i] == '.') {
                    if (n == -1) {
                        n = i;
                    }
                    n2 = i;
                    continue;
                }
                if (n == -1) continue;
                this.a(cArray, n, n2, dArray, dArray2);
                cArray = this.a(new String(cArray), dArray, dArray2, n, n2 + 1).toCharArray();
                n = -1;
                n2 = -1;
            }
            if (n != -1) {
                this.a(cArray, n, n2, dArray, dArray2);
                cArray = this.a(new String(cArray), dArray, dArray2, n, n2 + 1).toCharArray();
            }
            return new String(cArray);
        }

        private void a(char[] cArray, int n, int n2, double[] dArray, double[] dArray2) {
            if (n >= n2) {
                return;
            }
            char c2 = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c2;
            double d2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d2;
            double d3 = dArray2[n];
            dArray2[n] = dArray2[n2];
            dArray2[n2] = d3;
            this.a(cArray, n + 1, n2 - 1, dArray, dArray2);
        }

        private String c(String string, double[] dArray, double[] dArray2) {
            String string2 = string;
            if (BidiString.hasArabicCharacters((String)string)) {
                HashSet<Character> hashSet = new HashSet<Character>();
                for (int i = 0; i < string.length(); ++i) {
                    if (!BidiString.isArabicOptionalCharacter((char)string.charAt(i))) continue;
                    hashSet.add(Character.valueOf(string.charAt(i)));
                    dArray[i] = -1.0;
                    if (dArray2 == null) continue;
                    dArray2[i] = -1.0;
                }
                for (Character c2 : hashSet) {
                    string2 = string2.replaceAll("[" + c2 + "]", "");
                }
            }
            return string2;
        }

        private TextElement b(TextElement textElement, TextElement textElement2) {
            int n;
            double d2;
            FontInfo fontInfo = textElement.getFontInfo();
            float f2 = textElement.getFontSize();
            String string = textElement.getLabel();
            String string2 = textElement2.getLabel();
            String string3 = string + string2;
            double[] dArray = textElement.getX() < textElement2.getX() ? textElement.getTransformMatrix() : textElement2.getTransformMatrix();
            AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, dArray[3] < 0.0 ? -1.0 : 1.0, dArray[4], dArray[5]);
            Paint paint = textElement.getFillPaint();
            Paint paint2 = textElement.getStrokePaint();
            double[] dArray2 = textElement.getCharacterWidths();
            double[] dArray3 = textElement2.getCharacterWidths();
            if (textElement.getTransformMatrix()[0] != 1.0) {
                d2 = textElement.getTransformMatrix()[0];
                n = 0;
                while (n < dArray2.length) {
                    int n2 = n++;
                    dArray2[n2] = dArray2[n2] * d2;
                }
            }
            if (textElement2.getTransformMatrix()[0] != 1.0) {
                d2 = textElement2.getTransformMatrix()[0];
                n = 0;
                while (n < dArray3.length) {
                    int n3 = n++;
                    dArray3[n3] = dArray3[n3] * d2;
                }
            }
            double[] dArray4 = this.a(dArray2, dArray3);
            double[] dArray5 = null;
            double[] dArray6 = textElement.getKerningArray();
            double[] dArray7 = textElement2.getKerningArray();
            if (dArray6 != null || dArray7 != null) {
                dArray5 = new double[textElement.getCharacterWidths().length + textElement2.getCharacterWidths().length];
                if (dArray6 != null) {
                    System.arraycopy(dArray6, 0, dArray5, 0, textElement.getCharacterWidths().length);
                }
                if (dArray7 != null) {
                    System.arraycopy(dArray7, 0, dArray5, textElement.getCharacterWidths().length, dArray7.length);
                }
            }
            TextElement textElement3 = new TextElement(fontInfo, f2, affineTransform, string3, paint, paint2, dArray4, dArray5, false, this.bP());
            textElement3.setPageIndex(this.nd);
            return textElement3;
        }

        private double[] a(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[dArray.length + dArray2.length];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
            return dArray3;
        }

        public void addShapeElement(boolean isClip, int pageIndex, Point2D offset, Shape shape, BasicStroke stroke, Paint strokePaint, Paint fillPaint) {
            this.addElement(new ShapeElement(isClip, pageIndex, offset, shape, stroke, strokePaint, fillPaint, this.bP()));
        }

        public void addImageElement(SerializableImage image, ParserListener.PDFImageMeta pdfMeta, AffineTransform bt, Shape clip, int pageIndex, boolean isType3Glyph) {
            Object object = null;
            if (SessionLocator.exists() && SessionLocator.getCurrent() instanceof PdfcSession) {
                object = PdfcSession.getStoreMapFromSession().putImage(image);
            }
            ImageElement imageElement = new ImageElement((Image)image, object, bt, clip, pageIndex, isType3Glyph, this.bP());
            ImageMetaData imageMetaData = new ImageMetaData();
            imageMetaData.put((Object)ImageMetaData.KEY.ALPHAMASK, (Object)pdfMeta.hasAlpha());
            imageMetaData.put((Object)ImageMetaData.KEY.COLORMODEL, pdfMeta.getType().name());
            imageMetaData.put((Object)ImageMetaData.KEY.FORMAT, pdfMeta.getFormat());
            imageElement.setImageMetaData(imageMetaData);
            imageElement.setyInverted(true);
            this.addElement(imageElement);
        }

        private void addElement(DrawableElement element) {
            if (this.nc != null) {
                this.nc.getChildren().add(element);
            } else {
                this.mT.getElementList().addDrawableElement(element);
            }
        }

        public void addAnnotationElement(PDFObject annotationObject, PDFPage page, PDFDecrypter decryptor, CacheAccess fontListener) {
            try {
                com.inet.pdfc.plugin.pdfparser.a a2 = new com.inet.pdfc.plugin.pdfparser.a(annotationObject, page, decryptor, fontListener, this, this.mr, this.bP());
                this.addElement(a2);
            }
            catch (PDFParseException pDFParseException) {
                PDFParser.LOGGER.warn((Object)("Could not add AnnotationElement '" + String.valueOf((Object)pDFParseException) + "'"));
            }
        }

        public void addControl(ControlData data) {
            ControlElement controlElement = com.inet.pdfc.plugin.pdfparser.b.a(data, this.bP());
            if (controlElement == null) {
                return;
            }
            double d2 = this.mT.getBounds().getHeight();
            controlElement.setY(d2 - controlElement.getBounds().getY() - controlElement.getBounds().getHeight());
            this.addElement(controlElement);
        }

        public void setCrystalReportsExport(boolean isCrystalReports) {
            this.mr.setCrystalReportsExport(isCrystalReports);
        }

        public void bU() {
            if (this.mU != null) {
                this.bT();
                this.mW = 0L;
                this.mX = 0L;
            }
            if (this.mY != null) {
                this.mY.setBounds(LocationUtils.getJoinedBounds(this.mY.getChildren()));
                this.mY = null;
            }
            if (this.nb != null) {
                while (!this.nb.isEmpty()) {
                    f f2 = this.nb.peekLast();
                    this.endStructureElement(f2.nl);
                }
            }
        }

        public void startStructureElement(@Nonnull StructureType type) {
            this.startStructureElement(type, null, null, null);
        }

        public void startStructureElement(@Nonnull StructureType type, @Nullable String lang, @Nullable String alt, @Nullable String actualText) {
            Serializable serializable;
            Object object;
            if (!this.na) {
                return;
            }
            if (this.mY != null) {
                this.a(this.mY);
                object = this.mT.getElementList().getList();
                serializable = new ArrayList<DrawableElement>(object.size());
                new StructureElement(ElementType.Block, null, (List<DrawableElement>)object, this.nd, ElementID.DUMMY).serialize((List<DrawableElement>)((Object)serializable));
                object.clear();
                object.addAll(serializable);
                this.mY = null;
            }
            if (this.nb == null) {
                this.nb = new LinkedList();
            }
            object = mv.get(type);
            serializable = null;
            if (object != null && (this.nc == null || this.nc.getType() != object)) {
                this.nc = new StructureElement((ElementType)object, null, new ArrayList<DrawableElement>(), this.nd, this.bP(), new TagElement(this.nd, this.bP(), TagElement.a.x(type.name()), lang, actualText, alt));
                serializable = this.nc;
            }
            this.nb.add(new f(type, (StructureElement)serializable));
        }

        public void endStructureElement(StructureType type) {
            if (this.nb == null || !this.na) {
                return;
            }
            f f2 = this.nb.pollLast();
            if (f2 != null && f2.nm != null) {
                Iterator<f> iterator = this.nb.descendingIterator();
                StructureElement structureElement = null;
                while (iterator.hasNext()) {
                    f f3 = iterator.next();
                    if (f3.nm == null) continue;
                    structureElement = f3.nm;
                    break;
                }
                this.nc = structureElement;
                if (!f2.nm.getChildren().isEmpty()) {
                    this.a(f2.nm);
                    this.addElement(f2.nm);
                }
            }
        }

        private void a(StructureElement structureElement) {
            List<DrawableElement> list = structureElement.getChildren();
            Rectangle2D rectangle2D = LocationUtils.getJoinedBounds(list, true);
            if (rectangle2D == null && list.size() > 0) {
                rectangle2D = LocationUtils.getJoinedBounds(list);
            }
            if (rectangle2D != null) {
                structureElement.setBounds(rectangle2D);
            }
        }
    }

    private static class a
    implements CacheAccess {
        private FontGenerationListener mB;
        private FontInfoCache mr;
        private SerializableImageCache mC;
        private Map<c, Object> mD = new HashMap<c, Object>();

        public a(FontGenerationListener fontGenerationListener, FontInfoCache fontInfoCache, SerializableImageCache serializableImageCache) {
            this.mB = fontGenerationListener;
            this.mr = fontInfoCache;
            this.mC = serializableImageCache;
        }

        public void fontGenerated(Font font, byte[] fontFileData, Map<Character, char[]> cmapAddition) {
            if (this.mB != null) {
                this.mB.fontGenerated(font, fontFileData, cmapAddition);
            }
        }

        public Object putImage(SerializableImage img) {
            if (this.mC != null) {
                c c2 = new c(img, this.mC);
                Object object = this.mD.get(c2);
                if (object == null) {
                    object = this.mC.putImage(img);
                    c2.d(object);
                    this.mD.put(c2, object);
                }
                return object;
            }
            return null;
        }

        public SerializableImage getImage(Object key) {
            if (this.mC != null) {
                return this.mC.getImage(key);
            }
            return null;
        }

        public Font deriveFont(Font font, HashMap<TextAttribute, Object> attributes) {
            return this.mr.deriveFont(font, attributes);
        }
    }

    private class b
    implements EnumerationProgress {
        private final DocumentProgressListener mE;
        private int mF;
        private final int mG;

        public b(DocumentProgressListener documentProgressListener, int n, int n2) {
            this.mE = documentProgressListener;
            this.mF = n;
            this.mG = this.mF + n2;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.mG < 0) {
                return this.mF < PDFDocument.this.bK();
            }
            return this.mF < this.mG && this.mF < PDFDocument.this.bK();
        }

        @Override
        public Page nextElement() throws PdfcException {
            if (this.mE != null) {
                this.mE.progress((double)(this.mG < 0 ? PDFDocument.this.bK() : this.mG) / (double)(this.mF + 1));
            }
            return PDFDocument.this.getPage(this.mF++);
        }

        @Override
        public double getProgress() {
            return 1.0 * (double)this.mF / (double)(this.mG < 0 ? PDFDocument.this.bK() : this.mG);
        }
    }

    private static class g
    implements Comparator<TextElement> {
        private g() {
        }

        public int c(TextElement textElement, TextElement textElement2) {
            double d2 = textElement.getX() + textElement.getCharacterWidths()[0] * textElement.getTransformMatrix()[0];
            double d3 = textElement2.getX() + textElement2.getCharacterWidths()[0] * textElement2.getTransformMatrix()[0];
            return Double.compare(d2, d3);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.c((TextElement)object, (TextElement)object2);
        }
    }

    private static class d {
        private static g mQ = new g();
        private List<TextElement> kd = new ArrayList<TextElement>();
        private int pageIndex;
        private double mR;
        private int mS = -1;

        public d(int n, double d2) {
            this.pageIndex = n;
            this.mR = d2;
        }

        public void a(TextElement textElement) {
            textElement.setPageIndex(this.pageIndex);
            this.kd.add(textElement);
        }

        public List<TextElement> bL() {
            if (this.kd.size() > 1) {
                Collections.sort(this.kd, mQ);
            }
            return this.kd;
        }

        public int bM() {
            return this.mS;
        }

        public void i(int n) {
            this.mS = n;
        }

        public double bN() {
            return this.mR;
        }
    }

    public static class c {
        private Class<? extends DataBuffer> mI;
        private Class<? extends SampleModel> mJ;
        private ColorModel mK;
        private int width;
        private int height;
        private int mL;
        private int[] mM;
        private int[] mN;
        private int[] mO;
        private Object cacheKey;
        private SerializableImageCache mC;
        private SerializableImage mP;

        public c(SerializableImage serializableImage, SerializableImageCache serializableImageCache) {
            this.mP = serializableImage;
            this.mC = serializableImageCache;
            Image image = serializableImage.getImage();
            if (image instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)image;
                WritableRaster writableRaster = bufferedImage.getRaster();
                if (writableRaster.getParent() == null) {
                    this.mI = writableRaster.getDataBuffer().getClass();
                    this.mJ = writableRaster.getSampleModel().getClass();
                }
                this.mK = bufferedImage.getColorModel();
                int n = writableRaster.getWidth();
                int n2 = writableRaster.getHeight();
                this.mM = writableRaster.getPixel(n / 4, n2 / 4, (int[])null);
                this.mN = writableRaster.getPixel(n / 2, n2 / 2, (int[])null);
                this.mO = writableRaster.getPixel(n * 3 / 4, n2 * 3 / 4, (int[])null);
                this.mL += Arrays.hashCode(this.mM) + Arrays.hashCode(this.mN) + Arrays.hashCode(this.mO);
            }
            this.width = serializableImage.getWidth();
            this.height = serializableImage.getHeight();
            this.mL += (this.width << 16) * this.height + (this.mI != null ? this.mI.hashCode() : 0) + (this.mJ != null ? this.mJ.hashCode() : 0) + (this.mK != null ? this.mK.hashCode() : 0);
        }

        public void d(Object object) {
            this.cacheKey = object;
            this.mP = null;
        }

        public int hashCode() {
            return this.mL;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof c)) {
                return false;
            }
            c c2 = (c)obj;
            if (this.width != c2.width || this.height != c2.height) {
                return false;
            }
            if (!(Objects.equals(this.mI, c2.mI) && Objects.equals(this.mJ, c2.mJ) && Objects.equals(this.mK, c2.mK))) {
                return false;
            }
            if (!Objects.deepEquals(this.mM, c2.mM)) {
                return false;
            }
            if (!Objects.deepEquals(this.mN, c2.mN)) {
                return false;
            }
            if (!Objects.deepEquals(this.mO, c2.mO)) {
                return false;
            }
            SerializableImage serializableImage = this.mP != null ? this.mP : this.mC.getImage(this.cacheKey);
            SerializableImage serializableImage2 = this.mC.getImage(c2.cacheKey);
            if (serializableImage != null && serializableImage2 != null) {
                if (serializableImage.hasRawData() || serializableImage2.hasRawData()) {
                    byte[] byArray;
                    byte[] byArray2 = serializableImage.getRawData();
                    if (byArray2.length == (byArray = serializableImage2.getRawData()).length) {
                        return Arrays.equals(byArray2, byArray);
                    }
                    return false;
                }
                if (!serializableImage.getColorModel().equals(serializableImage2.getColorModel())) {
                    return false;
                }
                WritableRaster writableRaster = serializableImage.getRaster();
                WritableRaster writableRaster2 = serializableImage2.getRaster();
                if (writableRaster.getWidth() != writableRaster2.getWidth() || writableRaster.getHeight() != writableRaster2.getHeight()) {
                    return false;
                }
                Object object = null;
                Object object2 = null;
                for (int i = 0; i < writableRaster.getHeight(); ++i) {
                    object = writableRaster.getDataElements(0, i, writableRaster.getWidth(), 1, object);
                    object2 = writableRaster2.getDataElements(0, i, writableRaster.getWidth(), 1, object2);
                    if (!(object instanceof byte[] ? !Arrays.equals((byte[])object, (byte[])object2) : (object instanceof int[] ? !Arrays.equals((int[])object, (int[])object2) : (object instanceof float[] ? !Arrays.equals((float[])object, (float[])object2) : object instanceof double[] && !Arrays.equals((double[])object, (double[])object2))))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class f {
        private StructureType nl;
        private StructureElement nm;

        public f(StructureType structureType, StructureElement structureElement) {
            this.nl = structureType;
            this.nm = structureElement;
        }

        public String toString() {
            return "(" + String.valueOf(this.nl) + ", " + String.valueOf(this.nm) + ")";
        }
    }
}

