/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.comparator;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.comparator.IElementComparator;
import com.inet.pdfc.generator.model.forms.CubicCurveShape;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.model.forms.QuadCurveShape;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.generator.postcompare.ImageComparator;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TagElement;
import com.inet.pdfc.model.TextElement;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Objects;

@InternalApi
public class BaseElementComparator
implements IElementComparator,
Serializable {
    private double de = 3.0;
    private transient ImageComparator df;

    BaseElementComparator(IProfile config) {
        this.df = new ImageComparator(config);
        this.de = Math.max(1.0E-7, config.getDouble(PDFCProperty.TOLERANCE_LINE_SIZE));
    }

    @Override
    public void init(IProfile config) {
        this.df = new ImageComparator(config);
    }

    @Override
    public boolean isEqual(DrawableElement o1, DrawableElement o2) {
        if (o1.getCompareHash() != o2.getCompareHash()) {
            return false;
        }
        ElementType elementType = o1.getType();
        if (o1.getType() != o2.getType()) {
            return false;
        }
        switch (elementType) {
            case Text: {
                return ((TextElement)o1).getText().equals(((TextElement)o2).getText());
            }
            case TextWord: {
                return ((WordElement)o1).getCompareWord().equals(((WordElement)o2).getCompareWord());
            }
            case Image: {
                return this.isEqualImage(o1, o2);
            }
            case Shape: {
                return this.isEqualShape(o1, o2);
            }
            case Curve: {
                return this.isEqualCurve(o1, o2);
            }
            case Line: {
                return this.isEqualLine(o1, o2);
            }
            case Annotation: {
                return this.a(o1, o2);
            }
            case Tag: {
                return this.b(o1, o2);
            }
            case InternalMarkup: {
                return o1.equals(o2);
            }
            case ControlCheckBox: 
            case ControlSignature: 
            case ControlText: {
                if (o1.getClass() == o2.getClass()) break;
                return false;
            }
        }
        return this.compareBounds(o1, o2);
    }

    private boolean a(DrawableElement drawableElement, DrawableElement drawableElement2) {
        AnnotationElement annotationElement = (AnnotationElement)drawableElement;
        AnnotationElement annotationElement2 = (AnnotationElement)drawableElement2;
        if (!Objects.equals(annotationElement.getSubtype(), annotationElement2.getSubtype())) {
            return false;
        }
        if (annotationElement.isLink() && annotationElement2.isLink() && !Objects.equals(annotationElement.getActionTarget(), annotationElement2.getActionTarget())) {
            return false;
        }
        return Objects.equals(annotationElement.getLabel(), annotationElement2.getLabel());
    }

    private boolean b(DrawableElement drawableElement, DrawableElement drawableElement2) {
        TagElement tagElement = (TagElement)drawableElement;
        TagElement tagElement2 = (TagElement)drawableElement2;
        return Objects.equals((Object)tagElement.getTagType(), (Object)tagElement2.getTagType());
    }

    protected boolean isEqualImage(DrawableElement o1, DrawableElement o2) {
        return this.df.isEqual((ImageElement)o1, (ImageElement)o2);
    }

    protected boolean isEqualShape(DrawableElement o1, DrawableElement o2) {
        ShapeElement shapeElement = (ShapeElement)o1;
        ShapeElement shapeElement2 = (ShapeElement)o2;
        Shape shape = shapeElement.getShape();
        Shape shape2 = shapeElement2.getShape();
        if (shape.getClass() != shape2.getClass()) {
            return false;
        }
        if (shape instanceof Line2D) {
            return this.a((Line2D)shape, (Line2D)shape2);
        }
        if (shape instanceof CubicCurve2D) {
            return this.a((CubicCurve2D)shape, (CubicCurve2D)shape2);
        }
        if (shape instanceof QuadCurve2D) {
            return this.a((QuadCurve2D)shape, (QuadCurve2D)shape2);
        }
        return this.compareBounds(o1, o2);
    }

    protected boolean isEqualLine(DrawableElement o1, DrawableElement o2) {
        if (Math.abs((o1.getRotation() - o2.getRotation()) % Math.PI) > 0.1) {
            return false;
        }
        return this.a(((LineShape)o1).getLine(), ((LineShape)o2).getLine());
    }

    protected boolean isEqualCurve(DrawableElement o1, DrawableElement o2) {
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof CubicCurveShape) {
            return this.a(((CubicCurveShape)o1).getCurveC(), ((CubicCurveShape)o2).getCurveC());
        }
        if (o1 instanceof QuadCurveShape) {
            return this.a(((QuadCurveShape)o1).getCurveQ(), ((QuadCurveShape)o2).getCurveQ());
        }
        return this.compareBounds(o1, o2);
    }

    protected boolean compareBounds(DrawableElement o1, DrawableElement o2) {
        Rectangle2D rectangle2D = o1.getBounds();
        Rectangle2D rectangle2D2 = o2.getBounds();
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (Math.abs(rectangle2D.getWidth() - rectangle2D2.getWidth()) > this.de) {
            return false;
        }
        return !(Math.abs(rectangle2D.getHeight() - rectangle2D2.getHeight()) > this.de);
    }

    private boolean a(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        return BaseElementComparator.isDifferenceEquals(quadCurve2D.getX1(), quadCurve2D.getX2(), quadCurve2D2.getX1(), quadCurve2D2.getX2(), this.de) && BaseElementComparator.isDifferenceEquals(quadCurve2D.getY1(), quadCurve2D.getY2(), quadCurve2D2.getY1(), quadCurve2D2.getY2(), this.de) && BaseElementComparator.isDifferenceEquals(quadCurve2D.getX1(), quadCurve2D.getCtrlX(), quadCurve2D2.getX1(), quadCurve2D2.getCtrlX(), this.de) && BaseElementComparator.isDifferenceEquals(quadCurve2D.getY1(), quadCurve2D.getCtrlY(), quadCurve2D2.getY1(), quadCurve2D2.getCtrlY(), this.de);
    }

    private boolean a(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2) {
        return BaseElementComparator.isDifferenceEquals(cubicCurve2D.getX1(), cubicCurve2D.getX2(), cubicCurve2D2.getX1(), cubicCurve2D2.getX2(), this.de) && BaseElementComparator.isDifferenceEquals(cubicCurve2D.getY1(), cubicCurve2D.getY2(), cubicCurve2D2.getY1(), cubicCurve2D2.getY2(), this.de) && BaseElementComparator.isDifferenceEquals(cubicCurve2D.getX1(), cubicCurve2D.getCtrlX1(), cubicCurve2D2.getX1(), cubicCurve2D2.getCtrlX1(), this.de) && BaseElementComparator.isDifferenceEquals(cubicCurve2D.getY1(), cubicCurve2D.getCtrlY1(), cubicCurve2D2.getY1(), cubicCurve2D2.getCtrlY1(), this.de) && BaseElementComparator.isDifferenceEquals(cubicCurve2D.getX1(), cubicCurve2D.getCtrlX2(), cubicCurve2D2.getX1(), cubicCurve2D2.getCtrlX2(), this.de) && BaseElementComparator.isDifferenceEquals(cubicCurve2D.getY1(), cubicCurve2D.getCtrlY2(), cubicCurve2D2.getY1(), cubicCurve2D2.getCtrlY2(), this.de);
    }

    private boolean a(Line2D line2D, Line2D line2D2) {
        Point2D point2D;
        Point2D point2D2;
        Point2D point2D3;
        Point2D point2D4;
        if (line2D.getP1().getX() < line2D.getP2().getX()) {
            point2D4 = line2D.getP1();
            point2D3 = line2D.getP2();
        } else {
            point2D4 = line2D.getP2();
            point2D3 = line2D.getP1();
        }
        if (line2D2.getP1().getX() < line2D2.getP2().getX()) {
            point2D2 = line2D2.getP1();
            point2D = line2D2.getP2();
        } else {
            point2D2 = line2D2.getP2();
            point2D = line2D2.getP1();
        }
        return BaseElementComparator.isDifferenceEquals(point2D4.getX(), point2D3.getX(), point2D2.getX(), point2D.getX(), this.de) && BaseElementComparator.isDifferenceEquals(point2D4.getY(), point2D3.getY(), point2D2.getY(), point2D.getY(), this.de);
    }

    public static boolean isDifferenceEquals(double x1Element1, double x2Element1, double x1Element2, double x2Element2, double tolerance) {
        double d2;
        double d3 = x1Element1 - x2Element1;
        double d4 = x1Element2 - x2Element2;
        if (Math.abs(d3) < tolerance / 2.0 || Math.abs(d4) < tolerance / 2.0) {
            tolerance = Math.min(tolerance, Math.max(Math.abs(d3), Math.abs(d4)) * 2.0);
        }
        return (d2 = d3 - d4) <= tolerance && d2 >= -tolerance;
    }
}

