/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.generator.filter.FilterFactory;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.util.EnumParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

@InternalApi
public class ProfileValidator {
    private static final String TEXTSTYLES = Arrays.asList(TextStyleType.values()).stream().map(Enum::name).collect(Collectors.joining(","));

    public Map<String, String> verifyConfig(DefaultProfile profile, boolean isDefaultProfile) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Properties properties = profile.getProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        Collections.sort(arrayList, (object, object2) -> object.toString().compareTo(object2.toString()));
        for (Object object3 : arrayList) {
            String string2 = object3.toString();
            if ("PROFIL_NAME".equals(object3) || "PROFIL_DESCRIPTION".equals(object3)) continue;
            PDFCProperty<?> pDFCProperty = PDFCProperty.valueOf(string2);
            if (pDFCProperty == null) {
                linkedHashMap.put(string2, Msg.getMsg("Config.validation.unknownKey", string2));
                continue;
            }
            if (pDFCProperty.isDeprecated()) {
                linkedHashMap.put(string2, Msg.getMsg("Config.validation.deprecatedKey", string2));
            }
            String string3 = profile.getString(pDFCProperty);
            if (pDFCProperty.getValidValues() == null || string3 == null) continue;
            Set set = pDFCProperty.getAvailableValues().stream().map(validValue -> validValue.getProfileValue()).collect(Collectors.toSet());
            if (pDFCProperty.getType() == Enum.class && !set.isEmpty()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string4 : EnumParser.splitEnumValues(string3)) {
                    if (string4.isBlank() || set.contains(string4.trim())) continue;
                    arrayList2.add(string4.trim());
                }
                if (!arrayList2.isEmpty()) {
                    linkedHashMap.put(pDFCProperty.name(), Msg.getMsg("Config.validation.invalidValue" + (arrayList2.size() > 1 ? "s" : ""), pDFCProperty.name(), arrayList2.stream().collect(Collectors.joining(", "))));
                }
            }
            if (pDFCProperty.getType() != String.class || set.isEmpty() || set.contains(string3.trim())) continue;
            linkedHashMap.put(pDFCProperty.name(), Msg.getMsg("Config.validation.invalidValue", pDFCProperty.name(), string3));
        }
        if (!isDefaultProfile) {
            Object object3;
            HashSet hashSet = new HashSet();
            hashSet.addAll(FilterFactory.getAvailableInputFilterKeys());
            hashSet.addAll(FilterFactory.getAvailableResultFilterKeys());
            hashSet.add("fixedorder");
            object3 = FilterFactory.getConfiguredFilterNames(profile).stream().filter(string -> !hashSet.contains(string)).collect(Collectors.toList());
            if (!object3.isEmpty()) {
                linkedHashMap.put(PDFCProperty.FILTERS.name(), Msg.getMsg("Config.validation.filtersMissing", object3.stream().collect(Collectors.joining(", "))));
            }
        }
        return linkedHashMap;
    }

    public void cleanUp(DefaultProfile profile) {
        Object object;
        Object object22;
        Properties properties = profile.getProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        for (Object object22 : arrayList) {
            object = object22.toString();
            if ("PROFIL_NAME".equals(object22) || "PROFIL_DESCRIPTION".equals(object22)) continue;
            PDFCProperty<?> pDFCProperty = PDFCProperty.valueOf((String)object);
            if (pDFCProperty == null || pDFCProperty.isDeprecated()) {
                properties.remove(object22);
                continue;
            }
            String string2 = profile.getString(pDFCProperty);
            if (pDFCProperty.getValidValues() == null || string2 == null) continue;
            Set set = pDFCProperty.getAvailableValues().stream().map(validValue -> validValue.getProfileValue()).collect(Collectors.toSet());
            if (pDFCProperty.getType() == Enum.class && !set.isEmpty()) {
                String[] stringArray;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string3 : stringArray = EnumParser.splitEnumValues(string2)) {
                    if (string3.isBlank() || !set.contains(string3.trim())) continue;
                    arrayList2.add(string3.trim());
                }
                if (arrayList2.size() != stringArray.length) {
                    properties.setProperty((String)object, arrayList2.stream().collect(Collectors.joining(", ")));
                }
            }
            if (pDFCProperty.getType() != String.class || set.isEmpty() || set.contains(string2.trim())) continue;
            properties.remove(object22);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(FilterFactory.getAvailableInputFilterKeys());
        hashSet.addAll(FilterFactory.getAvailableResultFilterKeys());
        hashSet.add("fixedorder");
        object22 = FilterFactory.getConfiguredFilterNames(profile);
        object = object22.stream().filter(string -> hashSet.contains(string)).collect(Collectors.toList());
        if (object22.size() != object.size()) {
            profile.putValue(PDFCProperty.FILTERS, object.stream().collect(Collectors.joining(", ")));
        }
    }

    public void migrateConfiguration3to4(IProfile profile) {
        String string;
        String string2 = profile.getString(PDFCProperty.COMPARE_TEXT_STYLES.name());
        if ("true".equalsIgnoreCase(string2)) {
            profile.putValue(PDFCProperty.COMPARE_TEXT_STYLES.name(), TEXTSTYLES);
        } else if ("false".equalsIgnoreCase(string2)) {
            profile.putValue(PDFCProperty.COMPARE_TEXT_STYLES.name(), "");
        }
        String string3 = profile.getString(PDFCProperty.CONTINUOUS_COMPARE.name());
        if ("true".equalsIgnoreCase(string3)) {
            profile.putValue(PDFCProperty.CONTINUOUS_COMPARE.name(), "CONTINUOUS");
            if (profile.getObject("CONTINUOUS_COMPARE_TYPES") != null) {
                string = profile.getString("CONTINUOUS_COMPARE_TYPES");
                profile.putValue(PDFCProperty.COMPARE_TYPES.name(), string);
            }
            if (profile.getObject("CONTINUOUS_FILTERS") != null) {
                string = profile.getString("CONTINUOUS_FILTERS");
                profile.putValue(PDFCProperty.FILTERS.name(), string);
            }
        } else if ("false".equalsIgnoreCase(string3)) {
            profile.putValue(PDFCProperty.CONTINUOUS_COMPARE.name(), "STRICT");
            string = this.b(profile);
            profile.putValue(PDFCProperty.COMPARE_TYPES.name(), string);
            profile.putValue(PDFCProperty.FILTERS.name(), this.c(profile));
        }
        if ((string = profile.getString("INVISIBLEELEMENTS_HIDE_ROTATION")) != null && "true".equalsIgnoreCase(string)) {
            EnumParser.modifyListProperty(PDFCProperty.FILTERS, "HIDEROTATEDTEXT", true, profile);
        }
        if (EnumParser.isInList("UNICODENORMALIZE", profile.getString(PDFCProperty.FILTERS.name())) || EnumParser.isInList("UNICODENORMALIZE", profile.getString("CONTINUOUS_FILTERS"))) {
            EnumParser.modifyListProperty(PDFCProperty.FILTERS, "UNICODENORMALIZE", false, profile);
            EnumParser.modifyListProperty(PDFCProperty.FILTERS, "TEXTTRANSFORM", true, profile);
            EnumParser.modifyListProperty("TRANSFORM_OPERATIONS", "REPLACE_CONFUSABLES", true, profile);
        }
        if (profile.getString("PROFIL_NAME") == null) {
            profile.putValue("PROFIL_NAME", "");
        }
        if (profile.getString("PROFIL_NAME") == null) {
            profile.putValue("PROFIL_NAME", "");
        }
        this.a(profile);
    }

    private void a(IProfile iProfile) {
        if (iProfile instanceof DefaultProfile) {
            Properties properties = ((DefaultProfile)iProfile).getProperties();
            properties.remove("CONTINUOUS_COMPARE_TYPES");
            properties.remove("CONTINUOUS_FILTERS");
            properties.remove("MODULES");
            properties.remove("NORMALIZERS");
            properties.remove("INVISIBLEELEMENTS_HIDE_ROTATION");
        }
    }

    private String b(IProfile iProfile) {
        if (iProfile.getObject(PDFCProperty.COMPARE_TYPES) != PDFCProperty.COMPARE_TYPES.getDefaultValue()) {
            return iProfile.getString(PDFCProperty.COMPARE_TYPES);
        }
        if (iProfile.getObject("MODULES") == null) {
            return String.valueOf((Object)CompareType.TEXT) + "," + String.valueOf((Object)CompareType.LINE) + "," + String.valueOf((Object)CompareType.IMAGE);
        }
        String string = iProfile.getString("MODULES");
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        string = string.replace("MODULE_PAGEPROPERTIES", "");
        string = string.replace("MODULE_IMAGE", CompareType.IMAGE.name());
        string = string.replace("MODULE_LINES", CompareType.LINE.name());
        string = string.replace("MODULE_TEXT_WORDORDER", CompareType.TEXT.name());
        return string;
    }

    private String c(IProfile iProfile) {
        if (iProfile.getObject(PDFCProperty.FILTERS) != PDFCProperty.FILTERS.getDefaultValue()) {
            return iProfile.getString(PDFCProperty.FILTERS);
        }
        if (iProfile.getObject("NORMALIZERS") == null) {
            return "MARGIN";
        }
        String string = iProfile.getString("NORMALIZERS");
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        string = string.replace("NORMALIZER_MARGIN", "MARGIN");
        string = string.replace("HEADER_FOOTER", "HEADERFOOTER");
        string = string.replace("INVISIBLE_ELEMENTS", "INVISIBLEELEMENTS");
        string = string.replace("UNICODE_NORMALIZE", "UNICODENORMALIZE");
        string = string.replace("REGEXP", "REGEXP");
        string = string.replace("MULTI_COLUMN", "MULTICOLUMN");
        return string;
    }
}

