/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.PageData;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.textselection.TextInfoImpl;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class ResultPage
implements Serializable {
    private static final long serialVersionUID = 740494048606944290L;
    private int height;
    private int width;
    private int yOffset;
    private int pageIndex;
    private transient PageImageCache renderSource;
    private transient ResultModel model;
    private boolean isLeft;
    private transient List<TextInfoImpl> textInfos;

    protected ResultPage(PageData data, PageImageCache renderSource, ResultModel model) {
        this.isLeft = data.isFirst();
        this.renderSource = renderSource;
        this.model = model;
        this.setData(data);
    }

    protected ResultPage() {
    }

    protected void setData(PageData data) {
        this.pageIndex = data.getPageIndex();
        this.width = Math.max(this.width, (int)Math.ceil(data.getWidth()));
        this.height = Math.max(this.height, (int)Math.ceil(data.getHeight()));
        if (this.renderSource instanceof PdfcRenderCache) {
            PdfcRenderCache pdfcRenderCache = (PdfcRenderCache)this.renderSource;
            List<TextInfoImpl> list = data.getTextInfos();
            @Nullable List<TextInfoImpl> list2 = pdfcRenderCache.getTextSelectionData(this.isLeft, this.pageIndex);
            if (list2 != null) {
                ArrayList<TextInfoImpl> arrayList = new ArrayList<TextInfoImpl>();
                for (TextInfoImpl textInfoImpl : list2) {
                    if (list.contains(textInfoImpl)) continue;
                    arrayList.add(textInfoImpl);
                }
                list.addAll(arrayList);
            }
            if (list2 != null && !list.equals(list2) || list2 == null && !list.isEmpty()) {
                pdfcRenderCache.putTextSelectionData(new ArrayList<TextInfoImpl>(list), this.isLeft, this.pageIndex);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPageOffset() {
        return this.yOffset;
    }

    protected void setPageOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public List<HighlightData.Highlight> getHighlights() {
        return this.model.getHighlightsForPage(this.pageIndex, this.isLeft);
    }

    @Nullable
    public BufferedImage getPageImage(double scale) {
        return this.getPageImage(scale, scale);
    }

    @Nullable
    public BufferedImage getPageImage(double scaleX, double scaleY) {
        return this.renderSource.getPageImage(this.isLeft, this.pageIndex, scaleX, scaleY);
    }

    public void renderPage(double scale, Graphics2D g2) {
        this.renderSource.renderPage(this.isLeft, this.pageIndex, scale, g2);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean hasPageImage() {
        return this.renderSource.hasPage(this.isLeft, this.pageIndex);
    }

    protected List<? extends TextInfo> getTextInfos() {
        if (this.textInfos != null) {
            return this.textInfos;
        }
        @Nullable List<? extends TextInfo> list = this.renderSource.getTextSelectionData(this.isLeft, this.pageIndex);
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public void setModel(ResultModel model) {
        this.model = model;
        this.renderSource = model.getPageImageCache();
    }
}

