/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;

@JsonData
@InternalApi
public class UserSession {
    private long lastAccessed = System.currentTimeMillis();
    private boolean idle;
    private String userSession;
    private GUID userID;

    private UserSession() {
    }

    public UserSession(GUID userID, String sessionID) {
        this.userID = userID;
        this.userSession = sessionID;
    }

    public GUID getUserID() {
        return this.userID;
    }

    public String getSessionID() {
        return this.userSession;
    }

    public long getLastAccess() {
        return this.lastAccessed;
    }

    public void updateAccess() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.userSession == null ? 0 : this.userSession.hashCode());
        n2 = 31 * n2 + this.userID.hashCode();
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserSession userSession = (UserSession)obj;
        if (!this.userID.equals((Object)userSession.userID)) {
            return false;
        }
        return !(this.userSession == null ? userSession.userSession != null : !this.userSession.equals(userSession.userSession));
    }

    public String toString() {
        return this.userSession + ", userID=" + String.valueOf(this.getUserID()) + ", " + (this.isIdle() ? "idle" : "not idle");
    }
}

