/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.interfaces;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.AbstractComparator;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import java.util.Locale;

@InternalApi
public interface ComparatorFactory
extends NamedExtension {
    public static AbstractComparator create(IProfile profile) throws PdfcException {
        String string = profile.getString(PDFCProperty.CONTINUOUS_COMPARE.name()).trim();
        try {
            ComparatorFactory comparatorFactory = (ComparatorFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ComparatorFactory.class, string, false);
            return comparatorFactory.createComparator(profile);
        }
        catch (IllegalStateException illegalStateException) {
            String string2 = "Comparator for key '" + string + "'";
            throw PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, illegalStateException, string2);
        }
    }

    public String getExtensionName();

    public String getDisplayName(Locale var1);

    public AbstractComparator createComparator(IProfile var1);
}

