/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.defaultrunner;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.DirectoryPdfSource;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.ComparatorProperties;
import com.inet.pdfc.generator.ComparatorProperty;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.plugin.interfaces.CompareRunner;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelUpdater;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public abstract class BaseCompareRunner
implements CompareRunner {
    private IProfile profile = new DefaultProfile();
    private List<BasePresenter> r = new ArrayList<BasePresenter>();
    protected Settings settings = new DefaultSetting();
    private DataGeneratorListener br;
    private ComparatorProperties bj = new ComparatorProperties();

    protected void notifySecondFileMissing(@Nonnull PdfSource pdf1, @Nonnull DirectoryPdfSource directory2) {
        InfoData infoData = new InfoData(pdf1, null, this.profile);
        ErrorData errorData = new ErrorData(ExceptionDataFactory.createExceptionData((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.noCorrespondingFileFound, directory2.getName(), pdf1.getName()))), 0, true);
        this.notifyPresenters(infoData, errorData);
    }

    protected void notifyFirstFileMissing(@Nonnull PdfSource pdf2, @Nonnull DirectoryPdfSource directory1) {
        InfoData infoData = new InfoData(null, pdf2, this.profile);
        ErrorData errorData = new ErrorData(ExceptionDataFactory.createExceptionData((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.noCorrespondingFileFound, directory1.getName(), pdf2.getName()))), 0, true);
        this.notifyPresenters(infoData, errorData);
    }

    protected void notifyPresenters(Chunk ... messages) {
        if (this.br != null) {
            for (Chunk chunk : messages) {
                this.br.addData(chunk);
            }
        } else {
            ResultModel resultModel = new ResultModel();
            ResultModelUpdater resultModelUpdater = new ResultModelUpdater(resultModel);
            this.r.forEach(basePresenter -> basePresenter.setModel(resultModel));
            for (Chunk chunk : messages) {
                resultModelUpdater.addData(chunk);
            }
        }
    }

    @Override
    public void setPresenters(List<BasePresenter> presenters) {
        this.r = presenters != null ? presenters : new ArrayList();
    }

    @Nonnull
    protected List<BasePresenter> getPresenters() {
        return this.r;
    }

    @Override
    public void setProfile(IProfile profile) {
        this.profile = profile != null ? new DefaultProfile(profile) : new DefaultProfile();
    }

    @Nonnull
    protected IProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void overrideDataGeneratorListener(DataGeneratorListener listener) {
        this.br = listener;
    }

    protected DataGeneratorListener getOverrideListener() {
        return this.br;
    }

    @Override
    public void setComparerProperty(ComparatorProperty key, String value) {
        this.bj.setComparerProperty(key, value);
    }

    protected ComparatorProperties getProperties() {
        return this.bj;
    }
}

