/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.InternalApi;
import com.inet.cache.PersistenceKey;
import com.inet.cache.image.ImageSerializer;
import com.inet.cache.image.SerializableImage;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.BufferedGraphicsProvider;
import com.inet.graphics.buffered.GraphicsObjectID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;

@InternalApi
public class RenderCacheBufferedGraphicsProvider
extends BufferedGraphicsProvider {
    private a il;

    public RenderCacheBufferedGraphicsProvider(@Nullable PdfcRenderCache storeMap) {
        this.il = new a(storeMap);
    }

    public void setStoreMap(@Nonnull PdfcRenderCache storeMap) {
        this.il.setStoreMap(storeMap);
    }

    public void add(int graphicsID, BufferedGraphicsCommand.MethodNames name, Object ... params) {
        Object[] objectArray = params;
        switch (name) {
            case DRAW_IMAGE_WITH_BG: 
            case DRAW_IMAGE_WITH_BUFF_IMG: 
            case DRAW_IMAGE_WITH_CORNER: 
            case DRAW_IMAGE_WITH_CORNER_AND_BG: 
            case DRAW_IMAGE_WITH_OBS: 
            case DRAW_IMAGE_WITH_SIZE: 
            case DRAW_IMAGE_WITH_SIZE_AND_BG: 
            case DRAW_IMAGE_WITH_XFORM: {
                if (params == null || params.length <= 0) break;
                boolean bl = false;
                for (int i = 0; i < params.length; ++i) {
                    Object object = params[i];
                    if (!(object instanceof Image) || object instanceof d) continue;
                    if (!bl) {
                        objectArray = Arrays.copyOf(params, params.length);
                        bl = true;
                    }
                    objectArray[i] = new d((Image)object, this.il);
                }
                break;
            }
            case ADDLAYER: 
            case SET_COMPOSITE: {
                if (params == null || params.length <= 0) break;
                boolean bl = false;
                for (int i = 0; i < params.length; ++i) {
                    BlendComposite blendComposite;
                    Object object = params[i];
                    if (!(object instanceof BlendComposite) || (blendComposite = (BlendComposite)object).getMask() == null) continue;
                    PersistenceKey persistenceKey = null;
                    BufferedImage bufferedImage = blendComposite.getMask();
                    if (bufferedImage instanceof SerializableImage) {
                        PersistenceKey persistenceKey2;
                        var11_17 = (SerializableImage)bufferedImage;
                        PersistenceKey persistenceKey3 = var11_17.getPersistenceKey();
                        if (persistenceKey3 == null && (persistenceKey2 = (PersistenceKey)this.il.getStoreMap().putImage(var11_17)) instanceof PersistenceKey) {
                            var11_17.setPersistenceKey(persistenceKey2);
                        }
                        persistenceKey = var11_17.getPersistenceKey();
                    } else {
                        var11_17 = new SerializableImage((Image)bufferedImage, null);
                        this.il.getStoreMap().putImage(var11_17);
                        persistenceKey = var11_17.getPersistenceKey();
                    }
                    if (!bl) {
                        objectArray = Arrays.copyOf(params, params.length);
                        bl = true;
                    }
                    objectArray[i] = new b(blendComposite.getMode(), blendComposite.getAlpha(), persistenceKey, this.il);
                }
                break;
            }
            case SET_FONT: {
                if (params == null || params.length <= 0) break;
                boolean bl = false;
                for (int i = 0; i < params.length; ++i) {
                    Object object = params[i];
                    if (!(object instanceof Font) || object instanceof c) continue;
                    if (!bl) {
                        objectArray = Arrays.copyOf(params, params.length);
                        bl = true;
                    }
                    objectArray[i] = new c((Font)object, this.il.getStoreMap());
                }
                break;
            }
        }
        this.add(new f(graphicsID, name, objectArray, this.il));
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="Images in the internal cache of i-net PDFC have a custom serialization format. So there is actually no Java object deserializaion in use.")
    protected Image readImage(final DataInput stream) throws IOException {
        int n = stream.readInt();
        switch (n) {
            case 0: {
                d d2 = new d(stream);
                return d2;
            }
            case 1: {
                InputStream inputStream = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return stream.readByte();
                    }

                    @Override
                    public int read(byte[] b2) throws IOException {
                        stream.readFully(b2);
                        return b2.length;
                    }

                    @Override
                    public int read(byte[] b2, int off, int len) throws IOException {
                        stream.readFully(b2, off, len);
                        return len;
                    }
                };
                return new ImageSerializer().read((InputStream)new DataInputStream(inputStream));
            }
        }
        return super.readImage(stream);
    }

    protected Composite readComposite(DataInput stream) throws IOException {
        byte by = stream.readByte();
        int n = stream.readInt();
        float f2 = stream.readFloat();
        Object object = null;
        if (by == 0) {
            object = AlphaComposite.getInstance(n, f2);
        } else if (by == 1) {
            Image image;
            BlendComposite.BlendingMode blendingMode = BlendComposite.BlendingMode.getBlendingMode((byte)stream.readByte());
            boolean bl = stream.readBoolean();
            Image image2 = null;
            if (bl) {
                Image image3;
                image = this.readImage(stream);
                if (image instanceof d) {
                    image3 = (d)image;
                    try {
                        image = this.il.getStoreMap().getImage(((d)image3).bm());
                    }
                    catch (RuntimeException runtimeException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)runtimeException);
                        image = null;
                    }
                }
                if (!(image instanceof BufferedImage) || ((BufferedImage)image).getType() != 2) {
                    image3 = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                    ((BufferedImage)image3).getGraphics().drawImage(image, 0, 0, null);
                    image2 = image3;
                } else {
                    image2 = (BufferedImage)image;
                }
            }
            image = new BlendComposite(blendingMode, f2, image2);
            object = image;
        } else {
            BlendComposite.BlendingMode blendingMode = BlendComposite.BlendingMode.getBlendingMode((byte)stream.readByte());
            int n2 = stream.readInt();
            byte[] byArray = new byte[n2];
            stream.readFully(byArray, 0, n2);
            PersistenceKey persistenceKey = PersistenceKey.create((String)new String(byArray, StandardCharsets.UTF_8));
            object = new b(blendingMode, f2, persistenceKey, this.il);
        }
        return object;
    }

    protected Font readFont(DataInput stream) throws IOException {
        return new c(stream);
    }

    private static class a {
        private PdfcRenderCache bt;

        public a(@Nullable PdfcRenderCache pdfcRenderCache) {
            this.bt = pdfcRenderCache;
        }

        @Nullable
        public PdfcRenderCache getStoreMap() {
            return this.bt;
        }

        public void setStoreMap(@Nullable PdfcRenderCache storeMap) {
            this.bt = storeMap;
        }
    }

    static class d
    extends Image {
        private int ir;
        private int is;
        private Object it;
        private a il;

        public d(Image image, a a2) {
            SerializableImage serializableImage;
            this.il = a2;
            this.ir = image.getWidth(null);
            this.is = image.getHeight(null);
            image = this.a(image);
            this.it = image instanceof SerializableImage ? ((serializableImage = (SerializableImage)image).getPersistenceKey() != null ? serializableImage.getPersistenceKey() : a2.getStoreMap().putImage((SerializableImage)image)) : a2.getStoreMap().putImage(new SerializableImage(image, null));
        }

        public d(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray, 0, n);
            this.it = PersistenceKey.create((String)new String(byArray, StandardCharsets.UTF_8));
            this.ir = dataInput.readInt();
            this.is = dataInput.readInt();
        }

        private void a(DataOutput dataOutput) throws IOException {
            byte[] byArray = this.it.toString().getBytes(StandardCharsets.UTF_8);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
            dataOutput.writeInt(this.ir);
            dataOutput.writeInt(this.is);
        }

        private Image a(Image image) {
            int n;
            BufferedImage bufferedImage;
            SampleModel sampleModel;
            Image image2 = image;
            if (image2 instanceof SerializableImage) {
                return image2;
            }
            if (image2 instanceof BufferedImage && (sampleModel = (bufferedImage = (BufferedImage)image2).getSampleModel()) instanceof MultiPixelPackedSampleModel && (n = bufferedImage.getType()) == 0) {
                ColorSpace colorSpace = ((BufferedImage)image2).getColorModel().getColorSpace();
                n = colorSpace.getType() == 1003 || colorSpace.getType() == 6 ? 10 : 2;
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
                bufferedImage2.getGraphics().drawImage(image2, 0, 0, null);
                return bufferedImage2;
            }
            return image;
        }

        public Object bm() {
            return this.it;
        }

        @Override
        public int getWidth(ImageObserver observer) {
            return this.ir;
        }

        @Override
        public int getHeight(ImageObserver observer) {
            return this.is;
        }

        @Override
        public ImageProducer getSource() {
            return this.il.getStoreMap().getImage(this.it).getImage().getSource();
        }

        @Override
        public Graphics getGraphics() {
            return this.il.getStoreMap().getImage(this.it).getImage().getGraphics();
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            return null;
        }
    }

    private static class b
    extends BlendComposite {
        private PersistenceKey ip;
        private a il;

        public b(BlendComposite.BlendingMode blendingMode, float f2, PersistenceKey persistenceKey, a a2) throws IllegalArgumentException {
            super(blendingMode, f2, null);
            this.ip = persistenceKey;
            this.il = a2;
        }

        public BufferedImage getMask() {
            SerializableImage serializableImage = this.il.getStoreMap().getImage(this.ip);
            if (serializableImage == null) {
                if (PDFCCore.LOGGER_CORE.isDebug()) {
                    PDFCCore.LOGGER_CORE.debug((Object)("Deserialization of masked image with key '" + String.valueOf(this.ip) + "' failed."));
                }
                return null;
            }
            return serializableImage.getBufferedImage();
        }
    }

    static class c
    extends Font {
        private PersistenceKey iq;

        public c(@Nonnull Font font, @Nonnull PdfcRenderCache pdfcRenderCache) {
            super(font.getName(), font.getStyle(), font.getSize());
            this.iq = pdfcRenderCache.putFont(font);
        }

        public c(@Nonnull DataInput dataInput) throws IOException {
            super("Dialog", 0, 12);
            int n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray, 0, n);
            this.iq = PersistenceKey.create((String)new String(byArray, StandardCharsets.UTF_8));
        }

        public PersistenceKey bl() {
            return this.iq;
        }

        private void a(@Nonnull DataOutput dataOutput) throws IOException {
            byte[] byArray = this.iq.keyValue().getBytes(StandardCharsets.UTF_8);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof c)) {
                return false;
            }
            c c2 = (c)obj;
            return Objects.equals(this.iq, c2.iq);
        }
    }

    static class f
    extends BufferedGraphicsCommand {
        private static Icon iv;
        private a il;

        protected f(int n, BufferedGraphicsCommand.MethodNames methodNames, Object[] objectArray, a a2) {
            super(n, methodNames, objectArray);
            this.il = a2;
        }

        protected void writeImage(DataOutput out, Image image) throws IOException {
            if (image instanceof d) {
                out.writeInt(0);
                ((d)image).a(out);
            } else if (image instanceof SerializableImage) {
                SerializableImage serializableImage = (SerializableImage)image;
                if (serializableImage.getPersistenceKey() != null) {
                    out.writeInt(0);
                    new d((Image)serializableImage, this.il).a(out);
                } else {
                    out.writeInt(1);
                    new ObjectOutputStream(new e(out)).writeObject(image);
                }
            } else {
                out.writeInt(2);
                super.writeImage(out, image);
            }
        }

        protected void writeFont(DataOutput out, Font font) throws IOException {
            if (font == null) {
                throw new NullPointerException();
            }
            if (font instanceof c) {
                ((c)font).a(out);
            } else {
                PersistenceKey persistenceKey = this.il.getStoreMap().putFont(font);
                byte[] byArray = persistenceKey.keyValue().getBytes(StandardCharsets.UTF_8);
                out.writeInt(byArray.length);
                out.write(byArray);
            }
        }

        protected void writeComposite(DataOutput out, Composite composite) throws IOException {
            if (composite instanceof b) {
                b b2 = (b)((Object)composite);
                byte[] byArray = b2.ip.toString().getBytes(StandardCharsets.UTF_8);
                out.writeByte(2);
                out.writeInt(0);
                out.writeFloat(b2.getAlpha());
                out.writeByte(b2.getMode().getId());
                out.writeInt(byArray.length);
                out.write(byArray);
            } else {
                super.writeComposite(out, composite);
            }
        }

        private static Icon bn() {
            if (iv == null) {
                try {
                    iv = (Icon)UIManager.getLookAndFeelDefaults().get("html.missingImage");
                }
                catch (Throwable throwable) {
                    iv = new ImageIcon(new BufferedImage(1, 1, 2));
                }
            }
            return iv;
        }

        public Object[] getParameters() {
            Object[] objectArray = super.getParameters();
            switch (this.getName()) {
                case DRAW_IMAGE_WITH_BG: 
                case DRAW_IMAGE_WITH_BUFF_IMG: 
                case DRAW_IMAGE_WITH_CORNER: 
                case DRAW_IMAGE_WITH_CORNER_AND_BG: 
                case DRAW_IMAGE_WITH_OBS: 
                case DRAW_IMAGE_WITH_SIZE: 
                case DRAW_IMAGE_WITH_SIZE_AND_BG: 
                case DRAW_IMAGE_WITH_XFORM: {
                    Object object = objectArray[0];
                    if (!(object instanceof d)) break;
                    d d2 = (d)object;
                    try {
                        object = this.il.getStoreMap().getImage(d2.bm());
                    }
                    catch (RuntimeException runtimeException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)runtimeException);
                        object = f.e(d2.getWidth(null), d2.getHeight(null));
                    }
                    objectArray = Arrays.copyOf(objectArray, objectArray.length);
                    objectArray[0] = object;
                    break;
                }
                case SET_FONT: {
                    Object object = objectArray[0];
                    if (!(object instanceof c)) break;
                    objectArray = Arrays.copyOf(objectArray, objectArray.length);
                    objectArray[0] = this.il.getStoreMap().getFont(((c)object).bl());
                    break;
                }
            }
            return objectArray;
        }

        public Object[] bo() {
            return super.getParameters();
        }

        private static BufferedImage e(int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            try {
                f.bn().paintIcon(new JPanel(), graphics2D, 5, 5);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bufferedImage;
        }

        public void run(LayerGraphics2D graphics, Map<GraphicsObjectID, AffineTransform> transformMap, Map<Integer, Shape> clipShapeMap) {
            super.run(graphics, transformMap, clipShapeMap);
            switch (this.getName()) {
                case DRAW_IMAGE_WITH_BG: 
                case DRAW_IMAGE_WITH_BUFF_IMG: 
                case DRAW_IMAGE_WITH_CORNER: 
                case DRAW_IMAGE_WITH_CORNER_AND_BG: 
                case DRAW_IMAGE_WITH_OBS: 
                case DRAW_IMAGE_WITH_SIZE: 
                case DRAW_IMAGE_WITH_SIZE_AND_BG: 
                case DRAW_IMAGE_WITH_XFORM: {
                    Object object = this.getParameters()[0];
                    if (object instanceof d) {
                        object = this.il.getStoreMap().getImage(((d)object).bm());
                    }
                    if (!(object instanceof Image)) break;
                    ((Image)object).flush();
                    break;
                }
            }
        }
    }

    private static class e
    extends OutputStream {
        private DataOutput iu;

        public e(DataOutput dataOutput) {
            this.iu = dataOutput;
        }

        @Override
        public void write(int b2) throws IOException {
            this.iu.writeByte(b2);
        }

        @Override
        public void write(byte[] b2) throws IOException {
            this.iu.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            this.iu.write(b2, off, len);
        }
    }
}

