/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.HighlightSetting;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.plugin.ServerPluginManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@InternalApi
public class SettingUtil {
    private static final List<ColorSetting> aX = new ArrayList<ColorSetting>();

    public static List<ColorSetting> getFilterSettings() {
        return new ArrayList<ColorSetting>(aX);
    }

    public static Set<ColorSetting> getAvailableColorSetting() {
        HashSet<ColorSetting> hashSet = new HashSet<ColorSetting>();
        Collections.addAll(hashSet, Modification.ModificationType.values());
        Collections.addAll(hashSet, Settings.METAOPTION.values());
        hashSet.addAll(SettingUtil.getFilterSettings());
        return hashSet;
    }

    public static Set<VisibilitySetting> getAvailableVisibilitySetting() {
        HashSet<VisibilitySetting> hashSet = new HashSet<VisibilitySetting>();
        Collections.addAll(hashSet, Modification.ModificationType.values());
        Collections.addAll(hashSet, Settings.OPTION.values());
        Collections.addAll(hashSet, Settings.EXPORT.values());
        hashSet.addAll(SettingUtil.getFilterSettings());
        return hashSet;
    }

    public static void setAllOutlineMarkerSetting(Color color, Settings settings) {
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            settings.setMarkerColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), DiffConstants.getMarkerColor(groupType).getAlpha()), groupType);
        }
    }

    public static Color hexToColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return null;
        }
        String string = hex.replace("#", "").toLowerCase();
        if (string.matches("[0-9a-f]+")) {
            if (string.length() == 6) {
                return new Color(Integer.valueOf(string.substring(0, 2), 16), Integer.valueOf(string.substring(2, 4), 16), Integer.valueOf(string.substring(4, 6), 16));
            }
            if (string.length() == 8) {
                return new Color(Integer.valueOf(string.substring(0, 2), 16), Integer.valueOf(string.substring(2, 4), 16), Integer.valueOf(string.substring(4, 6), 16), Integer.valueOf(string.substring(6, 8), 16));
            }
        }
        return null;
    }

    public static boolean isParseStructure(IProfile profile) {
        if (profile.getBool("USE_PDF_STRUCTURE")) {
            return ServerPluginManager.getInstance().isPluginLoaded("parser.pdf.config");
        }
        return profile.getBool(PDFCProperty.COMPARE_TAGS);
    }

    public static boolean isUseStructureInFilters(IProfile profile) {
        if (profile.getBool("USE_PDF_STRUCTURE") || profile.getString(PDFCProperty.FILTERS).contains("ORIGINALORDER")) {
            return ServerPluginManager.getInstance().isPluginLoaded("parser.pdf.config");
        }
        return false;
    }

    static {
        ServerPluginManager.getInstance().get(ISortFilterFactory.class).forEach(iSortFilterFactory -> aX.add(new HighlightSetting(iSortFilterFactory.getExtensionName())));
    }
}

