/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.InternalApi;
import com.inet.config.LicenseInfo;
import com.inet.pdfc.PDFC;
import com.inet.pdfc.PDFCVersion;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.util.VersionData;
import com.inet.shared.utils.Version;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class LicenseModel {
    private LicenseInfo c;

    public LicenseModel(@Nullable LicenseInfo info) {
        this.c = info;
    }

    @Nullable
    public String getLicensee() {
        return this.c != null ? this.c.getLicensee() : "";
    }

    @Nonnull
    public String getLicenseInfoText() {
        if (this.c == null) {
            return Msg.getMsg("License.NoLicense");
        }
        String string = this.c.getErrorMessage();
        if (string != null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLicenseTypeString());
        if (this.getExpirationDate() != null && this.getHardwareHash() != null) {
            int n = this.getDaysLeft();
            if (n <= 0) {
                stringBuilder.append(", ");
                stringBuilder.append(Msg.getMsg("License.ExpiredGUI"));
            } else if (!this.isPerpetual()) {
                stringBuilder.append(", ");
                stringBuilder.append((String)(n != 1 ? n + " " + Msg.getMsg("License.nDaysRemaining") : Msg.getMsg("License.OneDayRemaining")));
            }
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getLicenseTypeString() {
        if (this.c == null) {
            return "";
        }
        return this.c.getDisplayName();
    }

    public int getDaysLeft() {
        if (this.c == null) {
            return -1;
        }
        Date date = this.a();
        if (date == null) {
            return 111111;
        }
        int n = (int)Math.ceil((double)(date.getTime() - System.currentTimeMillis() + 86400000L) / 60.0 / 60.0 / 24.0 / 1000.0);
        return n;
    }

    public boolean isNoLicense() {
        return this.c == null || this.c.getAttributes().get("version") == null;
    }

    public boolean isTrial() {
        if (this.c == null) {
            return true;
        }
        return this.c.isTrial();
    }

    public boolean isPerpetual() {
        if (this.c == null) {
            return false;
        }
        if (!this.c.getAttributes().containsKey("expires")) {
            return true;
        }
        int n = this.getDaysLeft();
        return n >= 73000;
    }

    public boolean isAPI() {
        if (this.c == null) {
            return false;
        }
        return "true".equals(this.c.getAttributes().get("api"));
    }

    public boolean isServer() {
        if (this.c == null) {
            return false;
        }
        return "true".equals(this.c.getAttributes().get("server"));
    }

    public boolean isCommandLine() {
        if (this.c == null) {
            return false;
        }
        return "true".equals(this.c.getAttributes().get("commandline"));
    }

    public boolean isGUI() {
        if (this.c == null) {
            return false;
        }
        return "true".equals(this.c.getAttributes().get("gui"));
    }

    public boolean isExpired() {
        if (this.c == null) {
            return true;
        }
        return this.getDaysLeft() <= 0;
    }

    public boolean isBetaExpired() {
        Date date = Version.getTechnicalBuildExpirationDate();
        return date != null && !PDFCVersion.aw.before(date);
    }

    public boolean isSufficientMajorVersion() {
        return this.getLicenseVersion() >= VersionData.getMajor();
    }

    public Date getExpirationDate() {
        return this.a();
    }

    public String getAdditionalInfo() {
        if (this.c == null) {
            return "";
        }
        return (String)this.c.getAttributes().get("additional");
    }

    public String getKey() {
        if (this.c == null) {
            return "";
        }
        return (String)this.c.getAttributes().get("key");
    }

    public String getHardwareHash() {
        if (this.c == null) {
            return null;
        }
        return (String)this.c.getAttributes().get("hwid");
    }

    public int getLicenseVersion() {
        if (this.c == null) {
            return VersionData.getMajor();
        }
        String string = (String)this.c.getAttributes().get("version");
        return new Version(string != null ? string : PDFC.getVersion(false, false)).getMajor();
    }

    public boolean isValid() {
        if (this.c == null) {
            return false;
        }
        return this.c.getErrorMessage() == null || this.c.getErrorMessage().length() == 0;
    }

    private final Date a() {
        if (this.c == null) {
            return new Date();
        }
        String string = (String)this.c.getAttributes().get("expires");
        if (string == null) {
            return null;
        }
        try {
            return java.sql.Date.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Date();
        }
    }
}

