/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model.controls;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.i18n.a;
import java.awt.geom.Rectangle2D;

@JsonData
@InternalApi
public abstract class ControlElement
extends DrawableElementXY {
    public static final int STATE_NOT_DEFINED = 0;
    public static final int NO_TOGGLE_TO_OFF_PATTERN = 16384;
    public static final int RADIO_PATTERN = 32768;
    public static final int PUSH_BUTTON_PATTERN = 65536;
    public static final int RADIOS_IN_UNISON_PATTERN = 0x2000000;
    private String fieldValue;
    private String fieldName;
    private ElementList pdfObjList;
    private double w;
    private double h;
    private int stateID = 0;

    ControlElement(String fieldName, String fieldValue, int pageIndex, Rectangle2D bounds, ElementID id) {
        super(pageIndex, id);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.pdfObjList = new ElementList(pageIndex);
        if (bounds != null) {
            this.setX(bounds.getX());
            this.setY(bounds.getY());
            this.w = bounds.getWidth();
            this.h = bounds.getHeight();
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.w, this.h);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public final ElementList getObjectList() {
        return this.pdfObjList;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    void setFieldValue(String value) {
        this.fieldValue = value;
    }

    public void setStateID(int stateid) {
        this.stateID = stateid;
    }

    public int getStateID() {
        return this.stateID;
    }

    public boolean isStateUndefined() {
        return this.stateID == 0;
    }

    @Override
    public String getLabel() {
        Rectangle2D rectangle2D = this.getBounds();
        return a.getMsg("ElementType." + String.valueOf(this.getType()), Integer.toString((int)Math.abs(rectangle2D.getWidth())), Integer.toString((int)Math.abs(rectangle2D.getHeight())));
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        if (string.startsWith("Control")) {
            string = string.substring(7);
        }
        return "Control(" + string + ")" + (String)(this.getFieldValue() != null ? " = '" + this.getFieldValue() + "'" : "");
    }
}

