/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class Page
implements PagedElement,
Serializable {
    private int pageIndex;
    private float width;
    private float height;
    private int kt;
    private ElementList ku;
    private transient boolean kv;
    protected int dpi = 72;

    public Page(int pageIndex, float width, float height, int rotation) {
        this.pageIndex = pageIndex;
        this.width = width;
        this.height = height;
        this.kt = rotation;
        this.ku = new ElementList(pageIndex);
    }

    public abstract BufferedImage getImage(int var1, int var2, @Nullable Rectangle2D var3, boolean var4, boolean var5);

    public void renderPage(@Nonnull Graphics2D graphics, Rectangle2D imgBounds) {
        BufferedImage bufferedImage = this.getImage((int)Math.ceil(this.getWidth()), (int)Math.ceil(this.getHeight()), null, true, true);
        if (bufferedImage != null) {
            graphics.drawImage((Image)bufferedImage, 0, 0, null);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getRotation() {
        return this.kt;
    }

    public AffineTransform getInitialTransform(double width, double height, Rectangle2D clip) {
        AffineTransform affineTransform = new AffineTransform();
        switch (this.getRotation()) {
            case 0: {
                affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, height);
                break;
            }
            case 90: {
                affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                break;
            }
            case 180: {
                affineTransform = new AffineTransform(-1.0, 0.0, 0.0, 1.0, width, 0.0);
                break;
            }
            case 270: {
                affineTransform = new AffineTransform(0.0, -1.0, -1.0, 0.0, width, height);
            }
        }
        if (clip == null) {
            clip = this.getBounds();
        }
        double d2 = width / clip.getWidth();
        double d3 = height / clip.getHeight();
        affineTransform.scale(d2, d3);
        affineTransform.translate(-clip.getMinX(), -clip.getMinY());
        return affineTransform;
    }

    public ElementList getElementList() {
        return this.ku;
    }

    public abstract Exception getRecentError();

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.kv) {
            return null;
        }
        this.kv = true;
        try {
            Rectangle2D rectangle2D = this.getPageBounds(PageBoundaries.CropBox);
            if (rectangle2D != null) {
                Rectangle2D rectangle2D2 = rectangle2D;
                return rectangle2D2;
            }
            rectangle2D = this.getPageBounds(PageBoundaries.MediaBox);
            if (rectangle2D != null) {
                Rectangle2D rectangle2D3 = rectangle2D;
                return rectangle2D3;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            return float_;
        }
        finally {
            this.kv = false;
        }
    }

    @Override
    public ElementType getType() {
        return ElementType.Page;
    }

    @Override
    public String getLabel() {
        return "Page " + (this.getPageIndex() + 1);
    }

    public Rectangle2D getPageBounds(PageBoundaries ref) {
        return ref == PageBoundaries.MediaBox ? this.getBounds() : null;
    }

    public abstract void releaseResources();

    public int getDPI() {
        return this.dpi;
    }

    @InternalApi
    public static final class PageBoundaries
    extends Enum<PageBoundaries> {
        public static final /* enum */ PageBoundaries MediaBox = new PageBoundaries();
        public static final /* enum */ PageBoundaries CropBox = new PageBoundaries();
        public static final /* enum */ PageBoundaries BleedBox = new PageBoundaries();
        public static final /* enum */ PageBoundaries TrimBox = new PageBoundaries();
        public static final /* enum */ PageBoundaries ArtBox = new PageBoundaries();
        private static final /* synthetic */ PageBoundaries[] kw;

        public static PageBoundaries[] values() {
            return (PageBoundaries[])kw.clone();
        }

        public static PageBoundaries valueOf(String name) {
            return Enum.valueOf(PageBoundaries.class, name);
        }

        private static /* synthetic */ PageBoundaries[] bB() {
            return new PageBoundaries[]{MediaBox, CropBox, BleedBox, TrimBox, ArtBox};
        }

        static {
            kw = PageBoundaries.bB();
        }
    }
}

