/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.font.cache.AWTFontMetricsCache;
import com.inet.pdfc.model.FontInfo;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;

@InternalApi
public class AWTFontInfo
implements FontInfo,
Serializable {
    private Font ji;
    private boolean hasWhiteSpace;
    private float jj = Float.NaN;
    private double jk = Double.NaN;
    private int jl = -1;
    private float jm = -1.0f;

    public AWTFontInfo(Font font) {
        this.ji = font;
        this.hasWhiteSpace = this.getMetrics(12).getFont().canDisplay(' ');
    }

    @Override
    public double getWSWidth(float fontSize) {
        if (fontSize == this.jj) {
            return this.jk;
        }
        this.jk = (double)this.getMetrics((int)(fontSize * 200.0f)).charWidth(' ') / 10.0;
        this.jj = fontSize;
        return this.jk;
    }

    @Override
    public boolean hasWhiteSpace() {
        return this.hasWhiteSpace;
    }

    @Override
    public FontMetrics getMetrics(int size) {
        return AWTFontMetricsCache.getFontMetrics((Font)this.ji.deriveFont((float)size));
    }

    @Override
    public float getAscend(int size) {
        if (size == this.jl) {
            return this.jm;
        }
        this.jm = this.getMetrics(size).getAscent();
        this.jl = size;
        return this.jm;
    }

    @Override
    public String getFamilyName() {
        return this.ji.getFamily();
    }

    @Override
    public int getStyle() {
        return this.ji.getStyle();
    }

    @Override
    public String getFontName() {
        return this.ji.getFontName();
    }
}

