/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.cache.InetSerializable;
import com.inet.cache.MemorySize;
import com.inet.cache.image.SerializableImage;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.GraphicsObjectID;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphics;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphicsProvider;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphicsWithSizeSerializer;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.shared.utils.BlendComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@JsonData
@InternalApi
public class RenderCacheBufferedGraphicsWithSize
implements InetSerializable<RenderCacheBufferedGraphicsWithSize, RenderCacheBufferedGraphicsWithSizeSerializer>,
MemorySize,
Externalizable {
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final RenderCacheBufferedGraphicsWithSizeSerializer SERIALIZER = new RenderCacheBufferedGraphicsWithSizeSerializer();
    private RenderCacheBufferedGraphics graphics;
    private int width;
    private int height;
    private int commandsForSize = 0;
    private long cachedSize;

    public RenderCacheBufferedGraphicsWithSize() {
    }

    public RenderCacheBufferedGraphicsWithSize(RenderCacheBufferedGraphics graphics, int width, int height) {
        this.graphics = graphics;
        this.width = width;
        this.height = height;
    }

    public long getSizeInMemory() {
        List list = this.graphics.getGraphicsProvider().getList();
        if (this.commandsForSize == list.size()) {
            return this.cachedSize;
        }
        long l = 24L;
        l += (long)(8 + 8 * list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray;
            BufferedGraphicsCommand bufferedGraphicsCommand = (BufferedGraphicsCommand)list.get(i);
            l += 16L;
            for (Object object : objectArray = bufferedGraphicsCommand.getClass() == RenderCacheBufferedGraphicsProvider.f.class ? ((RenderCacheBufferedGraphicsProvider.f)bufferedGraphicsCommand).bo() : bufferedGraphicsCommand.getParameters()) {
                l += 8L;
                if (object == null) continue;
                l += this.getSizeOfObject(object);
            }
        }
        this.commandsForSize = list.size();
        this.cachedSize = l;
        return l;
    }

    private long getSizeOfObject(Object obj) {
        if (obj instanceof Color) {
            return 24L;
        }
        if (obj instanceof Rectangle2D.Double) {
            return 64L;
        }
        if (obj instanceof Rectangle2D.Float) {
            return 32L;
        }
        if (obj instanceof Rectangle) {
            return 32L;
        }
        if (obj instanceof AffineTransform) {
            return 112L;
        }
        if (obj instanceof GraphicsObjectID) {
            return 8L;
        }
        if (obj instanceof BlendComposite) {
            BlendComposite blendComposite = (BlendComposite)obj;
            long l = 16L;
            if (blendComposite.getBackdrop() != null) {
                l += this.getImageSize(blendComposite.getBackdrop());
            }
            if (blendComposite.getMask() != null) {
                l += this.getImageSize(blendComposite.getMask());
            }
            return l;
        }
        if (obj instanceof RenderCacheBufferedGraphicsProvider.d) {
            return 60L;
        }
        if (obj instanceof RenderCacheBufferedGraphicsProvider.c) {
            return 44L;
        }
        if (obj instanceof Font) {
            return 144 + ((Font)obj).getName().length() * 2;
        }
        if (obj instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)obj;
            float[] fArray = new float[6];
            long l = 24L;
            PathIterator pathIterator = generalPath.getPathIterator(IDENTITY);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 3: {
                        l += 51L;
                        break;
                    }
                    case 2: {
                        l += 35L;
                        break;
                    }
                    case 0: 
                    case 1: {
                        l += 19L;
                        break;
                    }
                }
                pathIterator.next();
            }
            return l;
        }
        if (obj.getClass() == BufferedImage.class) {
            return new SerializableImage((Image)((BufferedImage)obj), null).getSizeInMemory();
        }
        if (obj.getClass().getName().startsWith("sun.awt.SunHints")) {
            return 8L;
        }
        return MemorySize.getSizeOfObject((Object)obj);
    }

    private long getImageSize(BufferedImage img) {
        return img instanceof SerializableImage ? ((SerializableImage)img).getSizeInMemory() : new SerializableImage((Image)img, null).getSizeInMemory();
    }

    public RenderCacheBufferedGraphics getGraphics() {
        return this.graphics;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public RenderCacheBufferedGraphicsWithSizeSerializer getSerializer() {
        return SERIALIZER;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.getWidth());
        out.writeInt(this.getHeight());
        this.getGraphics().writeTo(out);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput dis) throws IOException, ClassNotFoundException {
        this.width = dis.readInt();
        this.height = dis.readInt();
        PdfcRenderCache pdfcRenderCache = PdfcSession.getSession().getStoreMap();
        this.graphics = new RenderCacheBufferedGraphics(pdfcRenderCache);
        this.graphics.readFrom(dis);
    }
}

