/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.config.PdfSource;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.StorageEntry;
import java.io.IOException;
import java.net.URL;

@JsonData
@InternalApi
public class StorageEntryPdfSource
extends PdfSource {
    private transient StorageEntry entry;

    public StorageEntryPdfSource(StorageEntry entry, URL location) {
        super(entry.getName(), entry.getPath(), entry.lastModified(), entry.size());
        this.entry = entry;
    }

    public StorageEntryPdfSource(StorageEntry entry, URL location, String explicitName) {
        this(entry, location);
        this.getMetaProperties().put("NAME", explicitName);
    }

    public StorageEntryPdfSource(StorageEntry entry, URL location, String explicitName, boolean setNoMetaPath) {
        this(entry, location, explicitName);
        if (setNoMetaPath) {
            this.getMetaProperties().remove("PATH");
        }
    }

    @Override
    public long getLastModified() {
        return this.entry.lastModified();
    }

    @Override
    public long getSize() {
        return this.entry.size();
    }

    @Override
    public String getPath() {
        String string = super.getPath();
        if (string == null) {
            string = this.entry.getPath();
        }
        return string;
    }

    @Override
    public RandomAccessRead getContent() throws IOException {
        RandomAccessRead randomAccessRead = this.entry.getRandomAccessRead();
        if (randomAccessRead == null) {
            throw new IOException(this.entry.getName() + " cannot be read since it's missing the 'RandomAccess' feature.");
        }
        return randomAccessRead;
    }
}

