/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.tess4j.util.LoggHelper;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Hocr2PdfParser
implements ContentHandler,
ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());
    public static final String SPACE = " ";
    public static final String BBOX = "bbox";
    public static final String TITLE = "title";
    public static final String SEMICOL = ";";
    public static final String DIV = "div";
    public static final String SPAN = "span";
    public static final String OCRX_WORD = "ocrx_word";
    public static final String OCR_WORD = "ocr_word";
    public static final String OCR_LINE = "ocr_line";
    public static final String CLASS = "class";
    public static final String OCR_PAGE = "ocr_page";
    private final RenderingMode renderingMode;
    private final PDFont font;
    private final boolean useHocrLineToY;
    private float xPageScaling;
    private float yPageScaling;
    private final StringBuilder text = new StringBuilder();
    private String[] coordsText;
    private String[] coordsLine;
    private PDPageContentStream pdfPageCanvas = null;
    private PDRectangle pdfPageBBox = null;
    private final PDDocument pdDocument;
    private final String hocrFilepath;

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.finishCurrentPage();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.text.setLength(0);
        this.coordsText = null;
        String string4 = attributes.getValue(CLASS);
        if (SPAN.equals(string3) || SPAN.equals(string2)) {
            logger.debug("start of span, there is a new text or line");
            if (OCRX_WORD.equals(string4) || OCR_WORD.equals(string4)) {
                this.coordsText = this.readBboxCoordsFromAttributs(attributes);
            } else if (OCR_LINE.equals(string4)) {
                this.coordsLine = this.readBboxCoordsFromAttributs(attributes);
            } else {
                logger.debug("ignore {0} : {1}", new Object[]{CLASS, string4});
            }
        } else if (DIV.equals(string3) || DIV.equals(string2)) {
            if (OCR_PAGE.equals(string4)) {
                logger.debug("start div, start of page and close the previous page");
                this.finishCurrentPage();
                this.beginNewPage(this.convertHocrAttributsToPageNum(attributes), this.readBboxCoordsFromAttributs(attributes));
            } else {
                logger.debug("ignore {0} : {1}", new Object[]{CLASS, string4});
            }
        } else {
            logger.debug("ignore qName : {0} or localName :{1} ", new Object[]{string3, string2});
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.coordsText != null && this.text.length() > 0) {
            logger.debug("OCRed word span closed, coords: {0} {1}", new Object[]{this.coordsText, this.text});
            if (this.useHocrLineToY) {
                this.coordsText[2] = this.coordsLine[2];
                this.coordsText[4] = this.coordsLine[4];
            }
            this.addTextToPDF(this.coordsText, this.text.toString());
        } else {
            logger.debug("ignore endElement no text readed");
        }
        this.coordsText = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.text.append(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.warn("warning: " + sAXParseException.getMessage());
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.error("error: " + sAXParseException.getMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.error("fatalError: " + sAXParseException.getMessage());
    }

    private String[] readBboxCoordsFromAttributs(Attributes attributes) {
        String string = attributes.getValue(TITLE);
        int n = string.indexOf(BBOX);
        int n2 = string.indexOf(SEMICOL, n);
        return string.substring(n, n2).split(SPACE);
    }

    private Integer convertHocrAttributsToPageNum(Attributes attributes) {
        String string = attributes.getValue("id");
        return Integer.valueOf(string.split("_")[1], 10) - 1;
    }

    private void beginNewPage(Integer n, String[] stringArray) throws SAXException {
        try {
            PDPage pDPage = this.pdDocument.getPage(n.intValue());
            this.pdfPageBBox = pDPage.getBBox();
            this.pdfPageCanvas = new PDPageContentStream(this.pdDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true, true);
            float f = Float.valueOf(stringArray[3]).floatValue() - Float.valueOf(stringArray[1]).floatValue();
            float f2 = Float.valueOf(stringArray[4]).floatValue() - Float.valueOf(stringArray[2]).floatValue();
            this.xPageScaling = this.pdfPageBBox.getWidth() / f;
            this.yPageScaling = this.pdfPageBBox.getHeight() / f2;
            logger.debug("Load page {0} with scaling {1}x{2}", new Object[]{n, Float.valueOf(this.xPageScaling), Float.valueOf(this.yPageScaling)});
        }
        catch (IOException | NumberFormatException exception) {
            throw new SAXException(exception.getMessage());
        }
    }

    private void finishCurrentPage() {
        if (this.pdfPageCanvas != null) {
            IOUtils.closeQuietly((Closeable)this.pdfPageCanvas);
        }
    }

    public void addTextToPDF(String[] stringArray, String string) throws SAXException {
        try {
            PDRectangle pDRectangle = new PDRectangle((float)Integer.valueOf(stringArray[1]).intValue(), (float)Integer.valueOf(stringArray[4]).intValue(), (float)(Integer.valueOf(stringArray[3]) - Integer.valueOf(stringArray[1])), (float)(Integer.valueOf(stringArray[4]) - Integer.valueOf(stringArray[2])));
            float f = pDRectangle.getWidth() * this.xPageScaling;
            float f2 = f * 1000.0f / this.font.getStringWidth(string);
            float f3 = pDRectangle.getLowerLeftX() * this.xPageScaling;
            float f4 = this.pdfPageBBox.getHeight() - pDRectangle.getLowerLeftY() * this.yPageScaling;
            this.printTextAtCoordinates(string, f2, f3, f4);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    private void printTextAtCoordinates(String string, float f, float f2, float f3) throws IOException {
        logger.debug("Text,{1},{2},{3},{4},{5},{6}", new Object[]{Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f), Float.valueOf(this.pdfPageBBox.getWidth()), Float.valueOf(this.pdfPageBBox.getHeight()), string});
        this.pdfPageCanvas.setFont(this.font, f);
        this.pdfPageCanvas.saveGraphicsState();
        this.pdfPageCanvas.beginText();
        this.pdfPageCanvas.setRenderingMode(this.renderingMode);
        this.pdfPageCanvas.setNonStrokingColor(Color.red);
        this.pdfPageCanvas.setLineWidth(0.0f);
        this.pdfPageCanvas.newLineAtOffset(f2, f3);
        this.pdfPageCanvas.showText(string);
        this.pdfPageCanvas.endText();
        this.pdfPageCanvas.restoreGraphicsState();
    }

    public Hocr2PdfParser(String string, PDDocument pDDocument, boolean bl, boolean bl2, String string2) throws IOException {
        this.hocrFilepath = string;
        this.pdDocument = pDDocument;
        this.useHocrLineToY = bl2;
        this.renderingMode = bl ? RenderingMode.FILL : RenderingMode.NEITHER;
        this.font = string2 != null ? new PDType1Font(Standard14Fonts.FontName.valueOf((String)string2)) : new PDType1Font(Standard14Fonts.FontName.HELVETICA);
    }

    public void parse() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setErrorHandler(this);
        xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
        try (FileInputStream fileInputStream = new FileInputStream(this.hocrFilepath);){
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF8"));
            bufferedReader.readLine();
            Reader reader = new Reader(){

                @Override
                public int read(char[] cArray, int n, int n2) throws IOException {
                    int n3 = bufferedReader.read(cArray, n, n2);
                    for (int i = 0; i < n3; ++i) {
                        char c = cArray[i + n];
                        if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || '\u10000' <= c && c <= '\u10ffff') continue;
                        cArray[i + n] = 32;
                    }
                    return n3;
                }

                @Override
                public void close() throws IOException {
                    bufferedReader.close();
                }
            };
            xMLReader.parse(new InputSource(reader));
        }
    }
}

