/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.ocr.tesseract;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.ocr.OcrWord;
import com.inet.pdfc.ocr.tesseract.TesseractBase;
import com.inet.pdfc.ocr.tesseract.TesseractPlugin;
import com.inet.pdfc.thread.PdfcSession;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.SuppressFBWarnings;
import net.sourceforge.tess4j.TessAPI;
import net.sourceforge.tess4j.Tesseract;
import net.sourceforge.tess4j.Word;
import net.sourceforge.tess4j.util.LoadLibs;

@InternalApi
public class TesseractLibUsage
extends TesseractBase {
    private Boolean d = null;

    public String getOcrName() {
        try {
            return "Tesseract " + TessAPI.INSTANCE.TessVersion();
        }
        catch (Exception exception) {
            return "Tesseract couldn't read version";
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only administrative users are allowed to access paths here. | SwingGui should no problem")
    public List<OcrWord> getWords(BufferedImage image) {
        Object object;
        if (PdfcSession.hasSession()) {
            PdfcSession.getSession().getSessionProperties().setProperty("ocr.active", "true");
        }
        ArrayList<OcrWord> arrayList = new ArrayList<OcrWord>();
        File file = this.getLanguageFolder();
        if (LOGGER.isDebug()) {
            System.setProperty("jna.debug_load", "true");
            LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.defaultFolder", new Object[]{file == null ? file : file.getAbsolutePath(), new File(".").getAbsolutePath()}));
            object = new File(file, this.language + "traineddata");
            LOGGER.debug((Object)("Exist = " + ((File)object).exists()));
            LOGGER.debug((Object)("Read Access = " + ((File)object).canRead()));
            object = new File(file, "eng.traineddata");
            LOGGER.debug((Object)("English Exist = " + ((File)object).exists()));
            LOGGER.debug((Object)("English Read Access = " + ((File)object).canRead()));
        }
        if (file == null || image == null) {
            return arrayList;
        }
        if (LOGGER.isDebug()) {
            LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.usedFolder", new Object[]{file.getAbsolutePath(), this.getAvailableLanguage(), image}));
        }
        object = new Tesseract();
        object.setDatapath(file.getAbsolutePath());
        object.setLanguage(this.language);
        long l = System.currentTimeMillis();
        List list = object.getWords(image, 3);
        for (Word word : list) {
            OcrWord ocrWord = new OcrWord(word.getBoundingBox(), new Font("Arial", 0, (int)word.getBoundingBox().getHeight()), word.getText(), (double)word.getConfidence());
            arrayList.add(ocrWord);
        }
        long l2 = System.currentTimeMillis() - l;
        LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.timeneeded", new Object[]{l2, arrayList.size()}));
        if (LOGGER.isDebug()) {
            System.setProperty("jna.debug_load", "false");
        }
        return arrayList;
    }

    @Override
    public boolean tryTesseract() {
        if (this.d == null && TesseractLibUsage.isWindows()) {
            try {
                TesseractBase.LOGGER.info((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.load.lib", new Object[]{LoadLibs.getTesseractLibName()}));
            }
            catch (Throwable throwable) {
                TesseractBase.LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.notload.lib", new Object[]{throwable}));
                this.d = false;
                return false;
            }
            try {
                BufferedImage bufferedImage = this.createTestImage();
                List<OcrWord> list = this.getWords(bufferedImage);
                for (OcrWord ocrWord : list) {
                    TesseractBase.LOGGER.debug((Object)("Testresult " + String.valueOf(ocrWord)));
                }
                if (!list.isEmpty()) {
                    TesseractBase.LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.active", new Object[0]));
                    this.d = true;
                }
                TesseractBase.LOGGER.warn((Object)(TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.disable", new Object[0]) + TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.noresult", new Object[0])));
            }
            catch (Error error) {
                Object object = error.toString();
                for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                    object = (String)object + "\n" + String.valueOf(stackTraceElement);
                }
                System.setProperty("jna.debug_load", "false");
                TesseractBase.LOGGER.warn((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseractwin.critical", new Object[]{object}));
                this.d = false;
            }
        }
        return this.d;
    }
}

