/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.ocr.tesseract;

import com.inet.annotations.InternalApi;
import com.inet.classloader.BaseLocator;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.http.servlet.ClientLocale;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.config.LanguageValues;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.ocr.Language;
import com.inet.pdfc.ocr.MissingTesseractException;
import com.inet.pdfc.ocr.OcrUsage;
import com.inet.pdfc.ocr.OcrWord;
import com.inet.pdfc.ocr.tesseract.TesseractPlugin;
import com.inet.pdfc.util.FilteredGraphics;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public abstract class TesseractBase
implements OcrUsage {
    public static final String LOGGER_NAME = "OCRExtension";
    public static final Logger LOGGER = LogManager.getLogger((String)"OCRExtension");
    protected String language = "eng";
    private static Set<String> a = new HashSet<String>();
    private static final HashSet<String> b = new HashSet();

    public TesseractBase() {
        b.add("/usr/bin/tesseract");
        b.add("/usr/local/bin/tesseract");
    }

    public void setLanguage(Language language) {
        if (language == null) {
            LOGGER.debug((Object)TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseract.notSupported", new Object[]{language}));
            return;
        }
        this.language = language.getTesseract();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only administrative users are allowed to access paths here. | SwingGui should no problem")
    private List<File> a() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File((String)OcrUsage.PATHLANGUAGEVALUE.get());
        if (!((String)OcrUsage.PATHLANGUAGEVALUE.get()).isEmpty()) {
            arrayList.add(file);
            return arrayList;
        }
        file = new File(new File(BaseLocator.getBaseDirectory().createChild("lang").getPath()), "tessdata");
        if (file.exists()) {
            arrayList.add(file);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalStateException(TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.languagepath.error", new Object[]{file.getAbsolutePath()}));
        }
        return arrayList;
    }

    protected File getLanguageFolder() {
        List<File> list = this.a();
        for (File object2 : list) {
            if (!this.a(object2, this.language)) continue;
            return object2;
        }
        Object object3 = (String)LanguageValues.TESS_MAP.get(this.language);
        if (object3 == null && this.language.length() > 3) {
            object3 = (String)LanguageValues.TESS_MAP.get(this.language.substring(0, 3));
        }
        if (object3 == null) {
            LOGGER.error((Object)("Language unknow for " + this.language));
        }
        String string = new Locale((String)(object3 == null ? "eng" : object3)).getDisplayLanguage();
        this.language = (String)LanguageValues.ISO_TO_TESS.get(ClientLocale.getThreadLocale().getLanguage());
        for (File file : list) {
            if (!this.a(file, this.language)) continue;
            if (!a.contains(string)) {
                String string2 = new Locale((String)LanguageValues.TESS_MAP.get(this.language)).getDisplayLanguage();
                LOGGER.error((Object)("There is no language file for " + string + " installed in the Tesseract data folder. OCR will use the current user language of " + string2 + " instead."));
                object3 = "eng";
                a.add(string);
            }
            return file;
        }
        this.language = "eng";
        for (File file : list) {
            if (!this.a(file, this.language)) continue;
            if (!a.contains(string)) {
                LOGGER.error((Object)("There is no language file for " + string + " installed in the Tesseract data folder. OCR will use the default language of English instead."));
                a.add(string);
            }
            return file;
        }
        String string3 = list.isEmpty() ? new File(".").getAbsolutePath() : list.get(0).getAbsolutePath();
        throw new RuntimeException(TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseract.error", new Object[]{this.language, string3}));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only administrative users are allowed to access paths here. | SwingGui should no problem")
    private boolean a(File file, String string) {
        return new File(file, string + ".traineddata").exists();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only administrative users are allowed to access paths here. | SwingGui should no problem")
    protected String getAvailableLanguage() {
        Object object = "";
        File file = this.getLanguageFolder();
        if (file == null) {
            return "no language available";
        }
        for (String string : Objects.requireNonNull(file.list())) {
            if (!string.contains(".traineddata")) continue;
            object = (String)object + new File(string).getName().replace(".traineddata", ",");
        }
        if (((String)object).endsWith(",")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public List<OcrWord> getWords(Page page, GraphicsFilter filter, boolean first) throws IOException {
        if (page == null) {
            return new ArrayList<OcrWord>();
        }
        double d = 300.0 / (double)page.getDPI();
        int n = (int)Math.ceil((double)page.getWidth() * d);
        int n2 = (int)Math.ceil((double)page.getHeight() * d);
        while (n > 10000 || n2 > 10000) {
            n = (int)Math.ceil((double)page.getWidth() * (d *= 0.99));
            n2 = (int)Math.ceil((double)page.getHeight() * d);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale(d, d);
        FilteredGraphics.usageFilter((Page)page, (boolean)first, (GraphicsFilter)filter, (Graphics2D)graphics2D);
        try {
            List<OcrWord> list = this.getWords(bufferedImage);
            this.a(list, d);
            return list;
        }
        catch (Error error) {
            if (error.getMessage().toLowerCase().contains("Invalid memory access".toLowerCase())) {
                throw new RuntimeException(TesseractPlugin.MSGUSAGE.getMsg("pdfc.ocr.tesseract.error.invalidMemory", new Object[]{first ? TesseractPlugin.MSGUSAGE.getMsg("pdfc.first", new Object[0]) : TesseractPlugin.MSGUSAGE.getMsg("pdfc.second", new Object[0])}));
            }
            throw error;
        }
    }

    public abstract List<OcrWord> getWords(BufferedImage var1);

    private void a(List<OcrWord> list, double d) {
        for (OcrWord ocrWord : list) {
            this.a(ocrWord, d);
        }
    }

    private void a(OcrWord ocrWord, double d) {
        Rectangle rectangle = ocrWord.getArea();
        double d2 = (double)rectangle.x / d;
        double d3 = (double)rectangle.y / d;
        double d4 = (double)rectangle.width / d;
        double d5 = (double)rectangle.height / d;
        ocrWord.getArea().setBounds((int)d2, (int)(d3 + d5), (int)d4, (int)(-d5));
    }

    public List<String> getInstalledLanguageFiles() {
        String string = this.getAvailableLanguage();
        if (string.isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(string.split(",")));
    }

    public static String readErrorProcess(Process process) {
        return TesseractBase.a(new BufferedReader(new InputStreamReader(process.getErrorStream())));
    }

    public static String readProcess(Process process) {
        return TesseractBase.a(new BufferedReader(new InputStreamReader(process.getInputStream())));
    }

    private static String a(BufferedReader bufferedReader) {
        Object object = "";
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                object = (String)object + string + "\n";
            }
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)("Programm error cann't be read '" + (String)object + "'\n" + String.valueOf(iOException)));
        }
        return object;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows");
    }

    public String getTesseractCommand() {
        String string = (String)OcrUsage.PATHTESSERACTVALUE.get();
        if (TesseractBase.isWindows()) {
            return "\"" + string + "\"";
        }
        if (string.equals(OcrUsage.PATHTESSERACT.getDefault())) {
            for (String string2 : b) {
                try {
                    if (!new File(string2).exists()) continue;
                    return string2;
                }
                catch (Throwable throwable) {
                    LOGGER.warn((Object)("No check for " + string2));
                }
            }
            return string;
        }
        return string;
    }

    public String getVersion() {
        String string = TesseractPlugin.MSGUSAGE.getMsg("tesseract.notfound", new Object[0]);
        String string2 = TesseractBase.executeCommad(this.getTesseractCommand() + " --version");
        return string2.contains("Command") ? string : string2.split("\n")[0];
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="No command injection possible because they are define internal.")
    public static String executeCommad(String command) {
        Object object = "Command error '" + command + "'";
        try {
            int n;
            LOGGER.debug((Object)("Execute = " + Arrays.toString(TesseractBase.splittCommand(command))));
            ProcessBuilder processBuilder = new ProcessBuilder(TesseractBase.splittCommand(command));
            if (!TesseractBase.isWindows()) {
                processBuilder.environment().putIfAbsent("SHELL", "/bin/sh");
            }
            Process process = processBuilder.start();
            for (n = 0; process.isAlive() && n < 6000; ++n) {
                Thread.sleep(100L);
            }
            if (n == 6000) {
                LOGGER.error((Object)TesseractPlugin.MSGUSAGE.getMsg("tesseract.configuration.error", new Object[]{command}));
            }
            if (((String)(object = TesseractBase.readProcess(process))).isEmpty()) {
                String string = TesseractBase.readErrorProcess(process);
                Object object2 = "";
                String[] stringArray = string.split("\n");
                Object object3 = "";
                for (String string2 : stringArray) {
                    if (string2.trim().isEmpty()) continue;
                    if (string2.endsWith("with Leptonica") || string2.startsWith("Warning: Invalid resolution") || string2.startsWith("Estimating resolution")) {
                        object2 = (String)object2 + string2 + "\n";
                        continue;
                    }
                    object3 = (String)object3 + string2 + "\n";
                }
                LOGGER.debug((Object)("Error filtered '" + (String)object2 + "'"));
                if (!((String)object3).isEmpty()) {
                    LOGGER.debug((Object)("Process Error channel '" + (String)object3 + "'"));
                    throw new MissingTesseractException(TesseractPlugin.MSGUSAGE.getMsg("tesseract.error.unexpected", new Object[]{object3}));
                }
                object = object2;
            }
        }
        catch (IOException | InterruptedException exception) {
            LOGGER.warn((Object)((String)object + "'\n" + String.valueOf(exception)));
            throw new MissingTesseractException(TesseractPlugin.MSGUSAGE.getMsg("tesseract.error.notesseract", new Object[]{exception}));
        }
        return object;
    }

    public static String[] splittCommand(String command) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = command.split("\"");
        boolean bl = false;
        for (String string : stringArray) {
            string = string.trim();
            if (bl) {
                if (!string.isEmpty()) {
                    arrayList.add(string);
                }
            } else {
                for (String string2 : string.split(" ")) {
                    if (string2.trim().isEmpty()) continue;
                    arrayList.add(string2.trim());
                }
            }
            bl = !bl;
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean tryTesseract() {
        TesseractBase.executeCommad(this.getTesseractCommand());
        try {
            List<OcrWord> list = this.getWords(this.createTestImage());
            for (OcrWord ocrWord : list) {
                LOGGER.debug((Object)("Testresult " + String.valueOf(ocrWord)));
            }
            if (!list.isEmpty()) {
                return true;
            }
            throw new MissingTesseractException(TesseractPlugin.MSGUSAGE.getMsg("tesseract.disable", new Object[0]));
        }
        catch (Error error) {
            throw new MissingTesseractException(TesseractPlugin.MSGUSAGE.getMsg("tesseract.critical", new Object[]{error}), (Throwable)error);
        }
    }

    protected BufferedImage createTestImage() {
        BufferedImage bufferedImage = new BufferedImage(1000, 1000, 12);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("monospace", 1, 50));
        graphics2D.drawString("That is a TEST!", 200, 200);
        return bufferedImage;
    }
}

