/*
 * Decompiled with CFR 0.152.
 */
package com.recognition.software.jdeskew;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.sourceforge.tess4j.util.LoggHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    public static boolean isBlack(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage.getType() == 12) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n3 = writableRaster.getSample(n, n2, 0);
            return n3 == 0;
        }
        int n4 = 140;
        return ImageUtil.isBlack(bufferedImage, n, n2, n4);
    }

    public static boolean isBlack(BufferedImage bufferedImage, int n, int n2, int n3) {
        double d = 0.0;
        if (n < 0 || n2 < 0 || n > bufferedImage.getWidth() || n2 > bufferedImage.getHeight()) {
            return false;
        }
        try {
            int n4 = bufferedImage.getRGB(n, n2);
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            d = (double)n5 * 0.299 + (double)n6 * 0.587 + (double)n7 * 0.114;
        }
        catch (Exception exception) {
            logger.warn("", (Throwable)exception);
        }
        return d < (double)n3;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, double d, int n, int n2) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[]{0, 0, n3, 0, n3, n4, 0, n4};
        double d2 = Math.toRadians(d);
        for (int i = 0; i < nArray.length; i += 2) {
            int n9 = (int)(Math.cos(d2) * (double)(nArray[i] - n) - Math.sin(d2) * (double)(nArray[i + 1] - n2) + (double)n);
            int n10 = (int)(Math.sin(d2) * (double)(nArray[i] - n) + Math.cos(d2) * (double)(nArray[i + 1] - n2) + (double)n2);
            if (n9 > n6) {
                n6 = n9;
            }
            if (n9 < n8) {
                n8 = n9;
            }
            if (n10 > n5) {
                n5 = n10;
            }
            if (n10 >= n7) continue;
            n7 = n10;
        }
        n -= n8;
        n2 -= n7;
        BufferedImage bufferedImage2 = new BufferedImage(n6 - n8, n5 - n7, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setBackground(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2, n, n2);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)bufferedImage, -n8, -n7, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

