/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection.api.provider;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.EncodingFunctions;
import com.inet.oauth.connection.api.provider.OauthConnectionProvider;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.oauth.connection.structure.OauthSettings;
import java.net.URL;
import javax.annotation.Nonnull;

@InternalApi
public class DropboxConnectionProvider
extends OauthConnectionProvider {
    public static final String NAME = "dropbox";

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return "Dropbox";
    }

    @Override
    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/oauth/connection/images/dropbox_32.png");
    }

    @Override
    String a(@Nonnull OauthSettings oauthSettings) {
        return "https://www.dropbox.com/.well-known/openid-configuration";
    }

    @Override
    @Nonnull
    public String getAuthenticationURL(@Nonnull OauthSettings settings, String state, String scope) {
        return super.getAuthenticationURL(settings, state, scope) + "&token_access_type=offline";
    }

    @Override
    @Nonnull
    public String getTokenData(OauthSettings settings, String code, String refresh_token) {
        StringBuilder stringBuilder = new StringBuilder();
        if (code != null) {
            stringBuilder.append("grant_type=authorization_code&code=").append(EncodingFunctions.encodeUrlParameter((String)code));
            stringBuilder.append("&redirect_uri=").append(EncodingFunctions.encodeUrlParameter((String)OauthAccessTokenManager.getRedirectUrl()));
        } else {
            stringBuilder.append("grant_type=refresh_token&refresh_token=").append(EncodingFunctions.encodeUrlParameter((String)refresh_token));
        }
        stringBuilder.append("&client_id=").append(EncodingFunctions.encodeUrlParameter((String)settings.getClientID()));
        stringBuilder.append("&client_secret=").append(EncodingFunctions.encodeUrlParameter((String)settings.getClientSecret()));
        return stringBuilder.toString();
    }
}

