/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection.structure;

import com.inet.annotations.JsonData;
import com.inet.config.SystemID;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@JsonData
public class OauthSettings {
    private static SecretKey key;
    String provider;
    String clientID;
    String clientSecret;
    private transient String decryptedClientSecret;
    String tenant;

    @Nonnull
    public String getProviderID() {
        return this.provider;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        String string = this.decryptedClientSecret;
        if (string == null) {
            this.decryptedClientSecret = string = OauthSettings.decrypt(this.clientSecret);
        }
        return string;
    }

    public String getTenant() {
        return this.tenant;
    }

    @Nonnull
    private static SecretKey getSecretKey() throws GeneralSecurityException {
        SecretKey secretKey = key;
        if (secretKey == null) {
            List list = SystemID.get();
            String string = list.isEmpty() ? "oauth.connection" : (String)list.get(0);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), string.getBytes(StandardCharsets.UTF_8), 65536, 256);
            key = secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(pBEKeySpec).getEncoded(), "AES");
        }
        return secretKey;
    }

    static String encrypt(String input) {
        if (input == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] byArray = new byte[16];
            new SecureRandom().nextBytes(byArray);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
            cipher.init(1, (Key)OauthSettings.getSecretKey(), gCMParameterSpec);
            byte[] byArray2 = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            System.arraycopy(byArray2, 0, byArray3, 16, byArray2.length);
            return Base64.getEncoder().encodeToString(byArray3);
        }
        catch (Exception exception) {
            return input;
        }
    }

    static String decrypt(String input) {
        if (input == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] byArray = Base64.getDecoder().decode(input);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray, 0, 16);
            cipher.init(2, (Key)OauthSettings.getSecretKey(), gCMParameterSpec);
            byte[] byArray2 = cipher.doFinal(byArray, 16, byArray.length - 16);
            return new String(byArray2, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return input;
        }
    }
}

