/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection.api.provider;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.EncodingFunctions;
import com.inet.oauth.connection.api.provider.a;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.oauth.connection.structure.OauthSettings;
import java.net.URL;
import javax.annotation.Nonnull;

@InternalApi
public abstract class OauthConnectionProvider {
    private a c;
    private OauthSettings d;

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract String getDisplayName();

    public abstract URL getIconURL();

    abstract String a(@Nonnull OauthSettings var1);

    protected a getEndPoints(@Nonnull OauthSettings settings) {
        a a2 = this.c;
        if (a2 == null || settings != this.d) {
            this.c = a2 = new a(this.a(settings));
            this.d = settings;
        }
        return a2;
    }

    @Nonnull
    public String getAuthenticationURL(@Nonnull OauthSettings settings) {
        return this.getEndPoints((OauthSettings)settings).e;
    }

    @Nonnull
    public String getAuthenticationURL(@Nonnull OauthSettings settings, String state, @Nonnull String scope) {
        String string = settings.getClientID();
        return this.getAuthenticationURL(settings) + "?response_type=code&client_id=" + EncodingFunctions.encodeUrlParameter((String)string) + "&redirect_uri=" + EncodingFunctions.encodeUrlParameter((String)OauthAccessTokenManager.getRedirectUrl()) + "&scope=" + EncodingFunctions.encodeUrlParameter((String)scope) + "&state=" + EncodingFunctions.encodeUrlParameter((String)state);
    }

    @Nonnull
    public String getTokenURL(@Nonnull OauthSettings settings) {
        return this.getEndPoints((OauthSettings)settings).f;
    }

    @Nonnull
    public String getTokenData(OauthSettings settings, String code, String refresh_token) {
        StringBuilder stringBuilder = new StringBuilder();
        if (code != null) {
            stringBuilder.append("grant_type=authorization_code&code=").append(EncodingFunctions.encodeUrlParameter((String)code));
            stringBuilder.append("&redirect_uri=").append(EncodingFunctions.encodeUrlParameter((String)OauthAccessTokenManager.getRedirectUrl()));
        } else {
            stringBuilder.append("grant_type=refresh_token&refresh_token=").append(EncodingFunctions.encodeUrlParameter((String)refresh_token));
        }
        stringBuilder.append("&client_id=").append(EncodingFunctions.encodeUrlParameter((String)settings.getClientID()));
        stringBuilder.append("&client_secret=").append(EncodingFunctions.encodeUrlParameter((String)settings.getClientSecret()));
        return stringBuilder.toString();
    }
}

