/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.structure;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.I18NChooserProperty;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.notificationui.NotificationServerPlugin;
import com.inet.notificationui.server.NotificationTime;
import com.inet.notificationui.server.UserDefinedNotificationGenerator;
import com.inet.notificationui.structure.NotificationTargetConfigProperty;
import com.inet.notificationui.structure.b;
import com.inet.usersandgroups.api.ui.TargetValue;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;

@JsonData
public class NotificationConfigProperty
extends ItemListConfigProperty {
    public static final String ADD_NOTIFICATION_TEMPLATE = "notificationtemplate.add";
    public static final String ADD_NOTIFICATION_TEMPLATE_GROUP = "notificationtemplate.add.group";
    public static final String ADD_NOTIFICATION_TEMPLATE_GROUP_TARGET = "notificationtemplate.add.group.target";
    public static final String ADD_NOTIFICATION_TEMPLATE_GROUP_TIME = "notificationtemplate.add.group.time";

    public NotificationConfigProperty(@Nonnull b provider, @Nonnull ConfigStructureSettings settings) {
        this(0, provider, settings, NotificationConfigProperty.createRowAction(provider, settings));
    }

    public NotificationConfigProperty(int sortid, b provider, ConfigStructureSettings settings, ConfigRowAction configRowAction) {
        super(sortid, NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS.getKey(), "ItemList" + NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS.getKey(), NotificationConfigProperty.getValue(settings), provider.translate(settings, ADD_NOTIFICATION_TEMPLATE, new Object[0]), new ConfigRowAction[]{configRowAction});
    }

    private static ArrayList<HashMap<String, String>> getValue(ConfigStructureSettings settings) {
        String string = settings.getChangedValue(NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS.getKey());
        if (string != null) {
            ArrayList arrayList = (ArrayList)new Json().fromJson(string, ArrayList.class, new Type[]{HashMap.class});
            return arrayList;
        }
        String string2 = settings.getValue(NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS.getKey());
        ArrayList<HashMap<String, String>> arrayList = new ArrayList<HashMap<String, String>>();
        if (!StringFunctions.isEmpty((String)string2)) {
            ArrayList arrayList2 = new ArrayList();
            try {
                arrayList2 = (ArrayList)new Json().fromJson(string2, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{UserDefinedNotificationGenerator.class}), new HashMap());
            }
            catch (JsonException jsonException) {
                LogManager.getApplicationLogger().warn((Object)jsonException);
            }
            for (UserDefinedNotificationGenerator userDefinedNotificationGenerator : arrayList2) {
                arrayList.add(NotificationConfigProperty.templateToMap(userDefinedNotificationGenerator));
            }
        }
        return arrayList;
    }

    private static HashMap<String, String> templateToMap(UserDefinedNotificationGenerator userDefinedNotificationTemplate) {
        ArrayList<DayOfWeek> arrayList;
        Json json = new Json();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("i18nchooser", "");
        hashMap.put("preview", "");
        hashMap.put("id", userDefinedNotificationTemplate.getId() == null ? "" : userDefinedNotificationTemplate.getId().toString());
        hashMap.put("title", json.toJson(userDefinedNotificationTemplate.getTitles()));
        hashMap.put("message", json.toJson(userDefinedNotificationTemplate.getMessages()));
        hashMap.put("targetURL", userDefinedNotificationTemplate.getTargetURL() == null ? "" : userDefinedNotificationTemplate.getTargetURL());
        hashMap.put("targets", json.toJson((Object)TargetValue.getValue(userDefinedNotificationTemplate.getReceiver())));
        hashMap.put("critical", Boolean.toString(userDefinedNotificationTemplate.isCritical()));
        hashMap.put("permanent", Boolean.toString(userDefinedNotificationTemplate.isPermanent()));
        NotificationTime notificationTime = userDefinedNotificationTemplate.getNotificationTime();
        if (notificationTime == null) {
            notificationTime = new NotificationTime();
        }
        hashMap.put("notificationWeekDays", (arrayList = notificationTime.getWeekday()) == null ? null : json.toJson(arrayList));
        NotificationTime.TimeRange timeRange = notificationTime.getTimeRange();
        hashMap.put("notificationTimeRange", timeRange == null ? null : json.toJson((Object)timeRange));
        NotificationTime.DateRange dateRange = notificationTime.getDateRange();
        NotificationTime.DateRangeDescription dateRangeDescription = dateRange == null ? new NotificationTime.DateRangeDescription(null, null) : new NotificationTime.DateRangeDescription(NotificationTime.DateRangeDescription.toDate(dateRange.getStartDate()), NotificationTime.DateRangeDescription.toDate(dateRange.getEndDate()));
        hashMap.put("notificationDateRange", json.toJson((Object)dateRangeDescription));
        return hashMap;
    }

    public static UserDefinedNotificationGenerator mapToTemplate(HashMap<String, String> map) {
        Object object;
        HashMap hashMap = (HashMap)new Json().fromJson(map.get("message"), (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}));
        HashMap hashMap2 = (HashMap)new Json().fromJson(map.get("title"), (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}));
        NotificationConfigProperty.migrateEnglishToDefault(hashMap, Locale.getDefault().getLanguage());
        NotificationConfigProperty.migrateEnglishToDefault(hashMap2, Locale.getDefault().getLanguage());
        UserDefinedNotificationGenerator userDefinedNotificationGenerator = new UserDefinedNotificationGenerator(hashMap2, hashMap);
        String string = map.get("id");
        if (string != null) {
            userDefinedNotificationGenerator.setId(GUID.valueOf((String)string));
        }
        userDefinedNotificationGenerator.setCritical(Boolean.parseBoolean(map.get("critical")));
        userDefinedNotificationGenerator.setPermanent(Boolean.parseBoolean(map.get("permanent")));
        String string2 = map.get("targets");
        if (string2 != null && !string2.isEmpty() && !"null".equalsIgnoreCase(string2)) {
            userDefinedNotificationGenerator.setReceiver(TargetValue.getReceivers((String)string2));
        }
        String string3 = map.get("notificationWeekDays");
        String string4 = map.get("notificationDateRange");
        String string5 = map.get("notificationTimeRange");
        NotificationTime notificationTime = new NotificationTime();
        if (!StringFunctions.isEmpty((String)string3)) {
            notificationTime.setWeekdays((ArrayList)new Json().fromJson(string3, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{DayOfWeek.class})));
        }
        if (!StringFunctions.isEmpty((String)string4)) {
            object = (NotificationTime.DateRangeDescription)new Json().fromJson(string4, NotificationTime.DateRangeDescription.class);
            NotificationTime.DateRange dateRange = new NotificationTime.DateRange(NotificationTime.DateRangeDescription.parseDate(((NotificationTime.DateRangeDescription)object).getStartDate()), NotificationTime.DateRangeDescription.parseDate(((NotificationTime.DateRangeDescription)object).getEndDate()));
            notificationTime.setDateRange(dateRange);
        }
        if (!StringFunctions.isEmpty((String)string5)) {
            notificationTime.setTimeRange((NotificationTime.TimeRange)new Json().fromJson(string5, NotificationTime.TimeRange.class));
        }
        userDefinedNotificationGenerator.setTimeRestriction(notificationTime);
        object = map.get("targetURL");
        if (!StringFunctions.isEmpty((String)object)) {
            userDefinedNotificationGenerator.setTargetURL((String)object);
        }
        return userDefinedNotificationGenerator;
    }

    public static void migrateEnglishToDefault(HashMap<String, String> texts, String systemLanguage) {
        if (texts.containsKey("en")) {
            String string = texts.get("en");
            if (!StringFunctions.isEmpty((String)string)) {
                String string2 = texts.get("default");
                if (!StringFunctions.isEmpty((String)string2) && !texts.containsKey(systemLanguage)) {
                    texts.put(systemLanguage, string2);
                }
                texts.put("default", string);
            }
            texts.remove("en");
        }
    }

    private static ConfigRowAction createRowAction(b provider, ConfigStructureSettings settings) {
        ConfigAction configAction = new ConfigAction(ADD_NOTIFICATION_TEMPLATE, provider.translate(settings, ADD_NOTIFICATION_TEMPLATE, new Object[0]));
        ConfigCategory configCategory = new ConfigCategory(0, ADD_NOTIFICATION_TEMPLATE, provider.translate(settings, ADD_NOTIFICATION_TEMPLATE, new Object[0]), "components-notification");
        ArrayList<ConfigPropertyGroup> arrayList = new ArrayList<ConfigPropertyGroup>();
        arrayList.add(new ConfigPropertyGroup(0, ADD_NOTIFICATION_TEMPLATE_GROUP, null));
        arrayList.add(new ConfigPropertyGroup(1, ADD_NOTIFICATION_TEMPLATE_GROUP_TIME, provider.translate(settings, ADD_NOTIFICATION_TEMPLATE_GROUP_TIME, new Object[0])));
        arrayList.add(new ConfigPropertyGroup(2, ADD_NOTIFICATION_TEMPLATE_GROUP_TARGET, provider.translate(settings, ADD_NOTIFICATION_TEMPLATE_GROUP_TARGET, new Object[0])));
        HashMap hashMap = new HashMap();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        hashMap.put(ADD_NOTIFICATION_TEMPLATE_GROUP, arrayList2);
        int n = 0;
        arrayList2.add(new I18NChooserProperty(n++, "i18nchooser", ""));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "MultiLingualText", provider.translate(settings, "notificationtemplate.title", new Object[0]), "title", new Json().toJson(new HashMap()), ""));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "MultiLingualMultiLineText", provider.translate(settings, "notificationtemplate.message", new Object[0]), "message", new Json().toJson(new HashMap()), ""));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "SimpleText", provider.translate(settings, "notificationtemplate.targetURL", new Object[0]), "targetURL", "", provider.translate(settings, "notificationtemplate.targetURL.placeholder", new Object[0])));
        arrayList2.add(new BooleanConfigProperty(n++, "permanent", "Boolean", provider.translate(settings, "notificationtemplate.permanent.hint", new Object[0]), provider.translate(settings, "notificationtemplate.permanent", new Object[0]), "", (Object)Boolean.FALSE.toString()));
        arrayList2.add(new BooleanConfigProperty(n++, "critical", "Boolean", provider.translate(settings, "notificationtemplate.critical.hint", new Object[0]), provider.translate(settings, "notificationtemplate.critical", new Object[0]), "", (Object)Boolean.FALSE.toString()));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "notificationtemplate.preview", provider.translate(settings, "notificationtemplate.preview", new Object[0]), "preview", "", ""));
        arrayList2 = new ArrayList();
        hashMap.put(ADD_NOTIFICATION_TEMPLATE_GROUP_TIME, arrayList2);
        arrayList2.add(NotificationConfigProperty.propWith(n++, "NotificationWeekDays", provider.translate(settings, "notification.weekdays.label", new Object[0]), "notificationWeekDays", new Json().toJson(new NotificationTime().getWeekday()), ""));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "NotificationDateRange", provider.translate(settings, "notification.date.label", new Object[0]), "notificationDateRange", new Json().toJson((Object)new NotificationTime.DateRangeDescription(null, null)), NotificationTime.DateRangeDescription.getExtendedDatePattern()));
        arrayList2.add(NotificationConfigProperty.propWith(n++, "NotificationTimeRange", provider.translate(settings, "notification.time.label", new Object[0]), "notificationTimeRange", new Json().toJson((Object)new NotificationTime.TimeRange(null, null)), ""));
        arrayList2 = new ArrayList();
        hashMap.put(ADD_NOTIFICATION_TEMPLATE_GROUP_TARGET, arrayList2);
        arrayList2.add((Object)new NotificationTargetConfigProperty(n++, "targets", provider.translate(settings, "notificationtemplate.userFilter", new Object[0]), ""));
        return new ConfigRowAction(configAction, null, configCategory, arrayList, hashMap, null);
    }

    private static ConfigProperty propWith(int sortid, String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(sortid, keyName, type, label, (Object)value, null, placeholder);
    }
}

