/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server.webpush;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.notificationui.server.webpush.b;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.annotation.Nonnull;

@JsonData
class WebPushKeyPair {
    private String privateKey;
    private String publicKey;
    private transient ECPrivateKey privateKeyInstance;
    private transient ECPublicKey publicKeyInstance;
    private transient String applicationServerKey;

    private WebPushKeyPair() {
    }

    @Nonnull
    static WebPushKeyPair generate() {
        KeyPair keyPair = b.L.generateKeyPair();
        Base64.Encoder encoder = Base64.getEncoder();
        WebPushKeyPair webPushKeyPair = new WebPushKeyPair();
        webPushKeyPair.privateKey = encoder.encodeToString(keyPair.getPrivate().getEncoded());
        webPushKeyPair.publicKey = encoder.encodeToString(keyPair.getPublic().getEncoded());
        return webPushKeyPair;
    }

    ECPrivateKey getPrivateKey() {
        if (this.privateKeyInstance == null) {
            this.deserializeKeys();
        }
        return this.privateKeyInstance;
    }

    ECPublicKey getPublicKey() {
        if (this.publicKeyInstance == null) {
            this.deserializeKeys();
        }
        return this.publicKeyInstance;
    }

    @Nonnull
    String getApplicationServerKey() {
        String string = this.applicationServerKey;
        if (string != null) {
            return string;
        }
        byte[] byArray = b.a(this.getPublicKey());
        this.applicationServerKey = Base64.getEncoder().encodeToString(byArray);
        return this.applicationServerKey;
    }

    private void deserializeKeys() {
        try {
            KeyFactory keyFactory = b.M;
            Base64.Decoder decoder = Base64.getDecoder();
            this.privateKeyInstance = (ECPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decoder.decode(this.privateKey)));
            this.publicKeyInstance = (ECPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(decoder.decode(this.publicKey)));
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorCode.throwAny((Throwable)generalSecurityException);
        }
    }
}

