/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server;

import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.TimedGenerator;
import com.inet.notification.Times;
import com.inet.notificationui.server.NotificationTime;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonData
public class UserDefinedNotificationGenerator
extends NotificationGenerator
implements TimedGenerator {
    public static final String DEFAULT_LANGUAGE_KEY = "default";
    private GUID id;
    private HashMap<String, String> titles = new HashMap();
    private HashMap<String, String> messages = new HashMap();
    private String targetURL = "";
    private boolean permanent = false;
    private boolean critical = false;
    private Map<Type, Set<GUID>> receivers;
    private NotificationTime timeRestriction;

    private UserDefinedNotificationGenerator() {
    }

    public UserDefinedNotificationGenerator(final String title, final String message) {
        this(new HashMap<String, String>(){
            {
                this.put(UserDefinedNotificationGenerator.DEFAULT_LANGUAGE_KEY, title);
            }
        }, new HashMap<String, String>(){
            {
                this.put(UserDefinedNotificationGenerator.DEFAULT_LANGUAGE_KEY, message);
            }
        });
    }

    public UserDefinedNotificationGenerator(HashMap<String, String> titles, HashMap<String, String> messages) {
        this.id = GUID.generateNew();
        this.titles = titles;
        this.messages = messages;
    }

    public void setId(GUID id) {
        this.id = id;
    }

    public GUID getId() {
        return this.id;
    }

    public void setTitles(HashMap<String, String> titles) {
        this.titles = titles;
    }

    public void setMessages(HashMap<String, String> messages) {
        this.messages = messages;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setTimeRestriction(NotificationTime timeRestriction) {
        this.timeRestriction = timeRestriction;
    }

    public NotificationTime getTimeRestriction() {
        return this.timeRestriction;
    }

    public void setReceiver(Map<Type, Set<GUID>> receivers) {
        this.receivers = receivers;
    }

    public void setTargetURL(String targetURL) {
        this.targetURL = targetURL;
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public boolean isForCurrentUser() {
        return this.isForUser(UserManager.getInstance().getCurrentUserAccountID());
    }

    public boolean isForUser(GUID userId) {
        if (userId == null || this.receivers == null) {
            return false;
        }
        Set<GUID> set = this.receivers.get(Type.user);
        if (set != null && set.contains(userId)) {
            return true;
        }
        Set<GUID> set2 = this.receivers.get(Type.group);
        if (set2 != null) {
            UserGroupManager userGroupManager;
            boolean bl = set2.contains(UsersAndGroups.GROUPID_ALLUSERS);
            Set set3 = Collections.emptySet();
            if (bl) {
                userGroupManager = new SearchCommand("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Temp.name());
                set3 = UserManager.getInstance().getSearchEngine().simpleSearch((SearchCommand)userGroupManager);
                if (!set3.contains(userId)) {
                    return true;
                }
            }
            userGroupManager = UserGroupManager.getInstance();
            Set set4 = userGroupManager.getGroupsForUser(userId);
            for (UserGroupInfo userGroupInfo : set4) {
                if (set2.contains(userGroupInfo.getID()) && !UsersAndGroups.GROUPID_ALLUSERS.equals((Object)userGroupInfo.getID())) {
                    return true;
                }
                GUID gUID = userGroupInfo.getParentID();
                while (gUID != null) {
                    if (set2.contains(gUID)) {
                        return true;
                    }
                    UserGroupInfo userGroupInfo2 = userGroupManager.getGroup(gUID);
                    if (userGroupInfo2 != null) {
                        gUID = userGroupInfo2.getParentID();
                        continue;
                    }
                    gUID = null;
                }
            }
        }
        return false;
    }

    public Set<GUID> getTargetUserIds(Set<GUID> preFilteredUserIds) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        Set set = WebSocketEventHandler.getInstance().getAllConnectedUserIDs();
        for (GUID gUID : set) {
            if (!this.isForUser(gUID)) continue;
            hashSet.add(gUID);
        }
        return hashSet;
    }

    public String getGroupingKey() {
        return "notification.userdefined";
    }

    public Notification createNotification() {
        String string;
        String string2 = this.messages.get(ClientLocale.getThreadLocale().getLanguage());
        if (string2 == null) {
            string2 = this.messages.get(DEFAULT_LANGUAGE_KEY);
        }
        if ((string = this.titles.get(ClientLocale.getThreadLocale().getLanguage())) == null) {
            string = this.titles.get(DEFAULT_LANGUAGE_KEY);
        }
        Notification notification = new Notification(string, string2);
        notification.setCritical(this.isCritical());
        notification.setPermanent(this.isPermanent());
        if (!StringFunctions.isEmpty((String)this.getTargetURL())) {
            notification.setTargetUrl(this.getTargetURL());
        }
        return notification;
    }

    public HashMap<String, String> getTitles() {
        return this.titles;
    }

    public HashMap<String, String> getMessages() {
        return this.messages;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public NotificationTime getNotificationTime() {
        return this.timeRestriction;
    }

    public Map<Type, Set<GUID>> getReceiver() {
        return this.receivers;
    }

    public Times getNextTimes() {
        if (this.timeRestriction != null) {
            return this.timeRestriction.getNextTimes();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        long l2 = calendar.getTimeInMillis();
        return new Times(l, l2);
    }
}

