/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.webapi.model;

import com.inet.annotations.JsonData;
import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.api.backup.BackupJob;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;

@JsonData
@Schema(description="Response data for a backup list entry")
public class BackupListResponse {
    @Schema(description="Unique identifier of the backup", example="550e8400-e29b-41d4-a716-446655440000")
    private String id;
    @Schema(description="Name of the backup", example="Weekly System Backup")
    private String name;

    private BackupListResponse() {
    }

    public static BackupListResponse from(BackupDefinition definition) {
        BackupListResponse backupListResponse = new BackupListResponse();
        backupListResponse.id = definition.getId() == null ? UUID.randomUUID().toString() : definition.getId().toString();
        backupListResponse.name = definition.getName();
        return backupListResponse;
    }

    public static BackupListResponse from(BackupJob job) {
        BackupListResponse backupListResponse = new BackupListResponse();
        backupListResponse.id = job.getJobId() == null ? UUID.randomUUID().toString() : job.getJobId().toString();
        backupListResponse.name = job.getName();
        return backupListResponse;
    }
}

