/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.webapi.definitions;

import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.api.backup.BackupJob;
import com.inet.maintenance.server.backup.handler.f;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;

@Tag(name="Backup", description="Backup management operations")
public class a
extends RequestHandler.WithParentPathToken<Void, Void, UUID> {
    public a() {
        super(new String[]{"execute"});
    }

    @Operation(summary="Execute a backup", description="Executes a backup definition and returns the job ID", responses={@ApiResponse(responseCode="200", description="Backup job started successfully", content={@Content(mediaType="application/json", schema=@Schema(type="string", description="UUID of the created backup job", example="550e8400-e29b-41d4-a716-446655440000"))}), @ApiResponse(responseCode="404", description="Backup definition not found")})
    public Void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable UUID uUID, boolean bl) throws IOException {
        BackupDefinition backupDefinition = com.inet.maintenance.server.backup.a.b(uUID);
        if (backupDefinition == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            return null;
        }
        BackupJob backupJob = f.a(backupDefinition, bl);
        ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)backupJob.getJobId().toString());
        return null;
    }

    public String getHelpPageKey() {
        return "maintenance.backup.api.definition.execute";
    }

    @Operation(summary="Execute a backup", description="Executes a backup definition and returns the job ID", responses={@ApiResponse(responseCode="200", description="Backup job started successfully", content={@Content(mediaType="application/json", schema=@Schema(type="string", description="UUID of the created backup job", example="550e8400-e29b-41d4-a716-446655440000"))}), @ApiResponse(responseCode="404", description="Backup definition not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (UUID)object2, bl);
    }
}

