/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.tasks;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ConfigurationBackupVeto;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.maintenance.api.backup.tasks.BackupConfigurationKey;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public class b
implements BackupTask,
BackupConfigurationKey {
    @Override
    public String getKey() {
        return "general.configuration";
    }

    @Override
    public String getTitle() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.configuration.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.configuration.description", new Object[0]);
    }

    @Override
    public URL getIconURL() {
        return b.class.getResource("/com/inet/maintenance/resources/images/config_32.png");
    }

    @Override
    public Set<String> getKeysToBackup() {
        return null;
    }

    @Override
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        String string2;
        progressUpdater.updateProgress(0);
        HashSet<String> hashSet = this.l();
        progressUpdater.updateProgress(15);
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        Properties properties = configuration.getProperties();
        for (String string2 : hashSet) {
            properties.remove(string2);
        }
        progressUpdater.updateProgress(30);
        BackupHelper backupHelper = new BackupHelper();
        string2 = backupHelper.normalizeName(configuration.getName(), false);
        try (FileOutputStream fileOutputStream = new FileOutputStream(taskPath.resolve(ConfigurationManager.getScopeName((int)configuration.getScope()) + "_" + string2 + ".properties").toFile());){
            properties.store(fileOutputStream, null);
        }
        contentInformation.addTaskDetails(this.getKey(), InetMaintenanceServerPlugin.MSG.getMsg("backup.task.configuration.taskdetail", new Object[]{properties.size()}));
        progressUpdater.updateProgress(100);
    }

    private HashSet<String> l() {
        Object object;
        Set<String> set;
        Object object22;
        HashSet<String> hashSet = new HashSet<String>();
        List list = ServerPluginManager.getInstance().get(BackupTask.class);
        for (Object object22 : list) {
            if (!(object22 instanceof b) || (set = ((b)(object = (b)object22)).getKeysToBackup()) == null) continue;
            hashSet.addAll(set);
        }
        List list2 = ServerPluginManager.getInstance().get(ConfigurationBackupVeto.class);
        object22 = list2.iterator();
        while (object22.hasNext()) {
            object = (ConfigurationBackupVeto)object22.next();
            set = object.getVetoProperties();
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        progressUpdater.updateProgress(0);
        File[] fileArray = taskPath.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().endsWith(".properties");
            }
        });
        HashSet<String> hashSet = this.l();
        if (fileArray != null && fileArray.length > 0) {
            File file = fileArray[0];
            Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
            int n = 0;
            int n2 = properties.size();
            for (Map.Entry<Object, Object> object : properties.entrySet()) {
                hashSet.add((String)object.getKey());
                configuration.put((String)object.getKey(), (String)object.getValue());
                progressUpdater.updateProgress((int)Math.ceil((double)(++n) / (double)n2 * 90.0));
            }
            Properties properties2 = configuration.getProperties();
            for (Object object : properties2.keySet()) {
                if (hashSet.contains((String)object)) continue;
                configuration.put((String)object, null);
            }
        }
        progressUpdater.updateProgress(100);
    }

    @Override
    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

