/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.api.usercleanup;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;

@JsonData
public class User {
    private GUID id;
    private String name = "";
    private long lastaccess = 0L;
    private long profilesize = 0L;
    private boolean active;
    private String lockmsg = "";

    public User() {
    }

    public User(GUID id, String name, long lastaccess, long profilesize) {
        this(id, name, lastaccess, profilesize, null, true);
    }

    public User(GUID id, String name, long lastaccess, long profilesize, String lockmsg, boolean active) {
        this.id = id;
        this.name = name;
        this.lastaccess = lastaccess;
        this.profilesize = profilesize;
        this.lockmsg = lockmsg != null && !lockmsg.isEmpty() ? lockmsg : null;
        this.active = active;
    }

    public GUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getLastAccess() {
        return this.lastaccess;
    }

    public long getProfilesize() {
        return this.profilesize;
    }

    public void mergeWithUser(User addidtionalUser) {
        this.lastaccess = Math.max(this.lastaccess, addidtionalUser.getLastAccess());
        this.profilesize += addidtionalUser.getProfilesize();
    }
}

