/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance;

import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.MaintenanceExtension;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheExtension;
import com.inet.maintenance.server.backup.a;
import com.inet.maintenance.server.backup.b;
import com.inet.maintenance.server.c;
import com.inet.maintenance.server.cache.UsersAndGroupsCacheAction;
import com.inet.maintenance.server.d;
import com.inet.maintenance.server.taskplanner.BackupJobFactory;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.remote.gui.IModule;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.theme.server.ThemeResource;
import java.net.URL;
import javax.annotation.Nonnull;

@PluginInfo(id="maintenance", dependencies="remotegui", optionalDependencies="theme;help;taskplanner;webapi.core", group="administration", packages="com.inet.maintenance.api;com.inet.maintenance.server.taskplanner", version="25.10.259", icon="com/inet/maintenance/resources/images/maintenance_48.png")
public class InetMaintenanceServerPlugin
implements ServerPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Maintenance");
    public static final I18nMessages MSG = new I18nMessages("com.inet.maintenance.i18n.LanguageResources", InetMaintenanceServerPlugin.class);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.maintenance.resources.i18n.LanguageResources", InetMaintenanceServerPlugin.class);
    private com.inet.maintenance.a a = null;

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9150, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!super.isVisible(helpPage)) {
                    return false;
                }
                if ("taskplanner.job.backup".equals(helpPage.getKey())) {
                    try {
                        JobFactory jobFactory = (JobFactory)ServerPluginManager.getInstance().getSingleInstanceByName(JobFactory.class, "job.backup", false);
                        return jobFactory.isAvailable();
                    }
                    catch (IllegalStateException illegalStateException) {
                        return false;
                    }
                }
                return true;
            }
        }, new String[]{"taskplanner"});
        container.add((HelpProvider)new HelpProviderImpl("maintenance", 9350, new Permission[]{Permission.valueOfExistingOrCreate((String)"configuration")}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!super.isVisible(helpPage)) {
                    return false;
                }
                if ("cache".equals(helpPage.getKey()) && helpPage.getParentPage() != null && "maintenance".equals(helpPage.getParentPage().getKey())) {
                    return ServerPluginManager.getInstance().get(MaintenanceCacheExtension.class).size() > 0;
                }
                return true;
            }
        }, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("programming", 9151, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core"), Permission.valueOfExistingOrCreate((String)"configuration")}){}, new String[]{"webapi.core"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (!ServerPluginManager.IS_SERVLET_API) {
            return;
        }
        spm.register(IModule.class, (Object)new com.inet.maintenance.b());
        this.a = new com.inet.maintenance.a("/maintenance");
        spm.register(PluginServlet.class, (Object)this.a);
        if (spm.isPluginLoaded("webapi.core")) {
            new Runnable(){

                @Override
                public void run() {
                    spm.register(WebAPIExtension.class, (Object)new b());
                }
            }.run();
        }
        if (spm.isPluginLoaded("taskplanner")) {
            new Runnable(){

                @Override
                public void run() {
                    spm.register(JobFactory.class, (Object)new BackupJobFactory());
                }
            }.run();
        }
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/main/js/controller.js");
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/main/js/filechooser.js");
        if (Persistence.getRecoveryEnabledInstance() instanceof FilePersistence) {
            combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/programdata/js/controller.js");
        }
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/cache/js/controller.js");
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/backup/js/controller.js");
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/usercleanup/js/controller.js");
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/usercleanup/js/multieditusers.js");
        combinedFile.addMessages(MSG_CLIENT);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "maintenance.js", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        combinedFile.add(InetMaintenanceServerPlugin.class, "/com/inet/maintenance/resources/usercleanup/multieditusers.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "multieditusers.html", combinedFile));
        FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        combinedFile2.add(InetMaintenanceServerPlugin.class, "resources/main/css/maintenance.css");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile2));
        if (spm.isPluginLoaded("theme")) {
            spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", InetMaintenanceServerPlugin.class.getResource("resources/main/css/maintenance.less")));
            spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", InetMaintenanceServerPlugin.class.getResource("resources/main/css/sprites.less")));
        }
        if (Persistence.getRecoveryEnabledInstance() instanceof FilePersistence) {
            spm.register(MaintenanceExtension.class, (Object)new c());
        }
        spm.register(MaintenanceExtension.class, (Object)new com.inet.maintenance.server.b());
        spm.register(MaintenanceExtension.class, (Object)new com.inet.maintenance.server.a());
        spm.register(MaintenanceExtension.class, (Object)new d());
        UsersAndGroupsCacheAction usersAndGroupsCacheAction = new UsersAndGroupsCacheAction();
        spm.register(MaintenanceCacheAction.class, (Object)usersAndGroupsCacheAction);
        spm.register(MaintenanceCacheExtension.class, (Object)new com.inet.maintenance.server.cache.a(usersAndGroupsCacheAction));
        spm.register(BackupTask.class, (Object)new com.inet.maintenance.server.backup.tasks.a());
        spm.register(BackupTask.class, (Object)new com.inet.maintenance.server.backup.tasks.b());
        spm.register(BackupTask.class, (Object)new com.inet.maintenance.server.backup.tasks.c());
    }

    public void init(ServerPluginManager spm) {
        if (!ServerPluginManager.IS_SERVLET_API) {
            return;
        }
        if (this.a != null) {
            this.a.a();
        }
        new a().f();
    }

    public void reset() {
    }

    public void restart() {
    }
}

