/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.tasks;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.lib.json.Json;
import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.maintenance.api.backup.tasks.BackupConfigurationKey;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public class a
implements BackupTask,
BackupConfigurationKey {
    @Override
    public String getKey() {
        return "general.backupsettings";
    }

    @Override
    public String getTitle() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.backupsettings.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.backupsettings.description", new Object[0]);
    }

    @Override
    public URL getIconURL() {
        return a.class.getResource("/com/inet/maintenance/resources/images/backup_32.png");
    }

    @Override
    public Set<String> getKeysToBackup() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(ConfigKey.BACKUP_DEFINITIONS.getKey());
        hashSet.add(ConfigKey.BACKUP_LOCATION.getKey());
        return hashSet;
    }

    @Override
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        progressUpdater.updateProgress(0);
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        String string = configuration.get(ConfigKey.BACKUP_DEFINITIONS.getKey());
        String string2 = configuration.get(ConfigKey.BACKUP_LOCATION.getKey());
        progressUpdater.updateProgress(15);
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty(ConfigKey.BACKUP_DEFINITIONS.getKey(), string);
        }
        if (string2 != null) {
            properties.setProperty(ConfigKey.BACKUP_LOCATION.getKey(), string2);
        }
        progressUpdater.updateProgress(30);
        int n = 0;
        if (string != null && string.startsWith("[")) {
            n = ((BackupDefinition[])new Json().fromJson(string, BackupDefinition[].class)).length;
        }
        progressUpdater.updateProgress(70);
        try (FileOutputStream fileOutputStream = new FileOutputStream(taskPath.resolve("backupsettings.properties").toFile());){
            properties.store(fileOutputStream, null);
        }
        contentInformation.addTaskDetails(this.getKey(), InetMaintenanceServerPlugin.MSG.getMsg("backup.task.backupsettings.taskdetail", new Object[]{n}));
        progressUpdater.updateProgress(100);
    }

    @Override
    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        progressUpdater.updateProgress(0);
        File file = taskPath.resolve("backupsettings.properties").toFile();
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        progressUpdater.updateProgress(60);
        fileInputStream = MaintenanceHelper.getCurrentConfiguration();
        String string = properties.getProperty(ConfigKey.BACKUP_LOCATION.getKey());
        fileInputStream.put(ConfigKey.BACKUP_LOCATION.getKey(), string);
        progressUpdater.updateProgress(80);
        string = properties.getProperty(ConfigKey.BACKUP_DEFINITIONS.getKey());
        fileInputStream.put(ConfigKey.BACKUP_DEFINITIONS.getKey(), string);
        progressUpdater.updateProgress(100);
    }

    @Override
    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

