/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.tasks;

import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.UsersAndGroupsEventLog;
import com.inet.usersandgroups.UsersAndGroupsEventLogWrapper;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class c
implements BackupTask {
    private String A;
    private String B;
    private UsersAndGroupsEventLogWrapper C = UsersAndGroupsEventLog::log;

    @Override
    public String getKey() {
        return "general.usersettings";
    }

    @Override
    public String getTitle() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        if (persistence.resolve("usersandgroups").exists()) {
            return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.description", new Object[0]);
        }
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.description.allusers", new Object[0]);
    }

    @Override
    public URL getIconURL() {
        return c.class.getResource("/com/inet/maintenance/resources/images/usersettings_32.png");
    }

    @Override
    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        this.A = null;
        this.B = null;
        backupHelper.createZipFromFolderContent(persistence.resolve("usersandgroups"), taskPath.resolve("usersandgroups.zip"), new FileProgress(){

            @Override
            public void progressUpdate(int progress, int files) {
                c.this.A = InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.taskdetail.users", new Object[]{files});
                c.this.a(contentInformation);
                progressUpdater.updateProgress(progress * 9 / 10);
            }
        });
        progressUpdater.updateProgress(90);
        backupHelper.createZipFromFolderContent(persistence.resolve("AllUsers"), taskPath.resolve("allusers.zip"), new FileProgress(){

            @Override
            public void progressUpdate(int progress, int files) {
                c.this.B = InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.taskdetail.allusers", new Object[]{files});
                c.this.a(contentInformation);
                progressUpdater.updateProgress(90 + progress / 10);
            }
        });
        progressUpdater.updateProgress(100);
    }

    private void a(BackupContentInformation backupContentInformation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.A != null) {
            arrayList.add(this.A);
        }
        if (this.B != null) {
            arrayList.add(this.B);
        }
        backupContentInformation.putTaskDetails(this.getKey(), arrayList);
    }

    @Override
    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        Path path = taskPath.resolve("usersandgroups.zip");
        PersistenceEntry persistenceEntry = persistence.resolve("usersandgroups");
        backupHelper.extractZipIntoFolder(path, persistenceEntry, true, (n, n2) -> progressUpdater.updateProgress(n * 9 / 10));
        UserManager.getRecoveryEnabledInstance().hardReset();
        UserGroupManager.getRecoveryEnabledInstance().hardReset();
        progressUpdater.updateProgress(90);
        path = taskPath.resolve("allusers.zip");
        persistenceEntry = persistence.resolve("AllUsers");
        backupHelper.extractZipIntoFolder(path, persistenceEntry, true, (n, n2) -> progressUpdater.updateProgress(90 + n / 10));
        progressUpdater.updateProgress(100);
        this.C.log(UsersAndGroupsEventLog.DataRestoredFromBackup, null, null, new Object[0]);
        if (new Version("25.4").isHigherThan(backupVersion)) {
            PersistenceEntry persistenceEntry2 = Persistence.getInstance().resolve("usersandgroups/userbackupfrombefore254restored");
            persistenceEntry2.setBytes(new byte[]{1, 2, 3});
        }
    }

    @Override
    public boolean isSupported() {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("usersandgroups/users");
        return persistenceEntry.getChildren().size() > 0;
    }

    @Override
    public String getWarningMessage() {
        return InetMaintenanceServerPlugin.MSG.getMsg("backup.task.usersettings.warningMsg", new Object[0]);
    }

    @Override
    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

