/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.api;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTaskParameter;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCareStatusResponseData;
import com.inet.id.GUID;
import com.inet.plugin.NamedExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DataCareTask
extends NamedExtension {
    public static final Map<GUID, DataCareStatusResponseData> TASK_STATUSES = new MemoryStoreMap(300000, true);
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    public static final int MAX_PREVIEW_ENTRIES = 6;

    public String getTitle();

    public String getDescription();

    public int getPriority();

    public DataCarePreview getPreview(HashMap<String, String> var1) throws ServerDataException;

    @Nullable
    public GUID executeDelete(HashMap<String, String> var1) throws ServerDataException;

    @Nonnull
    default public DataCareStatusResponseData getStatus(@Nullable GUID taskId) {
        if (taskId == null) {
            return DataCareStatusResponseData.notFound();
        }
        DataCareStatusResponseData status = TASK_STATUSES.get(taskId);
        if (status == null) {
            return DataCareStatusResponseData.notFound();
        }
        return status;
    }

    default public DataCareTaskParameter getParameter() {
        return null;
    }
}

