/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.backup.tasks;

import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class ReportsBackupTask
implements BackupTask {
    private String detailReports;

    public String getKey() {
        return "helpdesk.reports";
    }

    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.report.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.report.description", new Object[0]);
    }

    public URL getIconURL() {
        return ReportsBackupTask.class.getResource("/com/inet/helpdesk/plugins/maintenance/server/images/reports_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        this.detailReports = null;
        final AtomicInteger reportsCount = new AtomicInteger(0);
        helper.createZipFromFolderContent(persistence.resolve("print"), taskPath.resolve("print.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                ReportsBackupTask.this.detailReports = HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.report.taskdetail.reports", new Object[]{reportsCount.get() + files});
                ReportsBackupTask.this.setDetails(contentInformation);
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    private void setDetails(BackupContentInformation contentInformation) {
        ArrayList<String> details = new ArrayList<String>();
        if (this.detailReports != null) {
            details.add(this.detailReports);
        }
        contentInformation.putTaskDetails(this.getKey(), details);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, final ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        Path source = taskPath.resolve("print.zip");
        PersistenceEntry target = persistence.resolve("print");
        helper.extractZipIntoFolder(source, target, false, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

