/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.dbmigration.handler;

import com.inet.classloader.LoaderUtils;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.MigrateDbSettings;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.ValidateDbSettingsResponseData;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.SuppressFBWarnings;

public class ValidateDBSettingsHandler
extends MaintenanceHandler<MigrateDbSettings, ValidateDbSettingsResponseData> {
    public String getMethodName() {
        return "maintenance_dbmigration_validatedbsettings";
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="No user values are used for the statement")
    public ValidateDbSettingsResponseData invoke(MigrateDbSettings input) throws ClientMessageException {
        String driver = input.getDriver();
        String catalog = input.getCatalog();
        String useraction = input.getUseraction();
        String user = input.getUser();
        String systemuser = input.getSystemuser();
        String systempassword = input.getSystempassword();
        String password = input.getPassword();
        String host = input.getHost();
        String port = input.getPort();
        if (driver == null || driver.trim().isEmpty()) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nodriver", new Object[0]));
        }
        if (host == null || host.trim().isEmpty()) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nohost", new Object[0]));
        }
        if (!(port != null && !port.trim().isEmpty() || driver.equals(DatabaseConfigInfo.DatabaseType.mysql.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.inetdae7.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.inetora.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.mariadb.name()))) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.noport", new Object[0]));
        }
        if ((driver.equals(DatabaseConfigInfo.DatabaseType.mysql.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.inetdae7.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.mariadb.name())) && (catalog == null || catalog.trim().isEmpty())) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nocatalog", new Object[0]));
        }
        if (driver.equals(DatabaseConfigInfo.DatabaseType.mysql.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.mariadb.name())) {
            if (user == null || user.trim().isEmpty()) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nouser", new Object[0]));
            }
            if ("new".equals(useraction)) {
                if (systemuser == null || systemuser.trim().isEmpty()) {
                    throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nosystemuser", new Object[0]));
                }
                if (user.length() > 16) {
                    throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.usernametolong", new Object[]{16}));
                }
            }
        }
        if (driver.equals(DatabaseConfigInfo.DatabaseType.inetora.name()) && "new".equals(useraction)) {
            if (systemuser == null || systemuser.trim().isEmpty()) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nosystemuser", new Object[0]));
            }
            if (user.length() > 30) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.usernametolong", new Object[]{30}));
            }
        }
        if (driver.equals(DatabaseConfigInfo.DatabaseType.inetdae7.name()) && "new".equals(useraction) && user.length() > 128) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.usernametolong", new Object[]{128}));
        }
        if ("new".equals(useraction) && (password == null || password.trim().isEmpty())) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.nopassword", new Object[0]));
        }
        DatabaseConfigInfo databaseInfo = ValidateDBSettingsHandler.convertInput(input);
        String urlWithDb = databaseInfo.getUrl();
        String urlWithoutDb = databaseInfo.getUrlWithoutDB();
        ConnectionFactory conFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        if ("new".equals(useraction)) {
            String msg = conFactory.testDBConnection(urlWithDb, databaseInfo.getDecodedPassword(), databaseInfo.getUser(), databaseInfo.getDriverClassName(), null);
            if (msg == null) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.existinguseranddatabase", new Object[0]));
            }
            if ((driver.equals(DatabaseConfigInfo.DatabaseType.inetdae7.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.inetora.name())) && (msg = conFactory.testDBConnection(urlWithoutDb, databaseInfo.getDecodedPassword(), databaseInfo.getUser(), databaseInfo.getDriverClassName(), null)) == null) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.existinguser", new Object[0]));
            }
            msg = conFactory.testDBConnection(urlWithoutDb, systempassword, systemuser, databaseInfo.getDriverClassName(), null);
            if (msg != null) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.systemloginfailed", new Object[]{msg}));
            }
            if (!driver.equals(DatabaseConfigInfo.DatabaseType.inetora.name())) {
                msg = conFactory.testDBConnection(urlWithDb, systempassword, systemuser, databaseInfo.getDriverClassName(), null);
                if (msg == null) {
                    throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.databaseexists", new Object[0]));
                }
            } else {
                try {
                    LoaderUtils.classForName((String)databaseInfo.getDriverClassName(), (Object)((Object)this));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Connection connection = DriverManager.getConnection(urlWithDb, systemuser, systempassword);
                    try {
                        Statement stmt = connection.createStatement();
                        try {
                            stmt.executeUpdate("ALTER SESSION SET CURRENT_SCHEMA = " + databaseInfo.getUser());
                            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.databaseexists", new Object[0]));
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {}
            }
        } else {
            String msg = conFactory.testDBConnection(urlWithDb, databaseInfo.getDecodedPassword(), databaseInfo.getUser(), databaseInfo.getDriverClassName(), null);
            if (msg == null) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.databaseexists", new Object[0]));
            }
            if (msg.contains("Msg 18456") || msg.contains("Access denied for user") || msg.contains("ORA-01017")) {
                throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.error.loginfailed", new Object[0]));
            }
            msg = conFactory.testDBConnection(urlWithoutDb, databaseInfo.getDecodedPassword(), databaseInfo.getUser(), databaseInfo.getDriverClassName(), null);
            if (msg != null) {
                throw new ClientMessageException(msg);
            }
        }
        return new ValidateDbSettingsResponseData(input.getRequestID());
    }

    static DatabaseConfigInfo convertInput(MigrateDbSettings input) {
        DatabaseConfigInfo result = new DatabaseConfigInfo();
        result.setCatalog(input.getCatalog());
        if (!"windows".equals(input.getUseraction())) {
            result.setUser(input.getUser());
            result.setDecodedPassword(input.getPassword().toCharArray());
        }
        String driver = input.getDriver();
        result.setDriver(DatabaseConfigInfo.DatabaseType.valueOf((String)driver));
        result.setHost(input.getHost());
        result.setSid(input.getSid());
        String port = input.getPort();
        if (port == null || port.trim().isEmpty()) {
            if (driver.equals(DatabaseConfigInfo.DatabaseType.mysql.name()) || driver.equals(DatabaseConfigInfo.DatabaseType.mariadb.name())) {
                port = "3306";
            }
            if (driver.equals(DatabaseConfigInfo.DatabaseType.inetdae7.name())) {
                port = "1433";
            }
            if (driver.equals(DatabaseConfigInfo.DatabaseType.inetora.name())) {
                port = "1521";
            }
        }
        result.setPort(port);
        return result;
    }
}

