/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceDeactivatedLocationCleanupExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries.LocationPreviewEntry;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeactivatedLocationsDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.deactivatedlocations";
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.deactivatedlocations.title", new Object[]{this.getLocationDisplayName()});
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.deactivatedlocations.description", new Object[]{StringFunctions.encodeHTML((String)this.getLocationDisplayName(), (boolean)false)});
    }

    @Override
    public int getPriority() {
        return 200;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List deactivatedLocations = LocationManager.getInstance().getAll(false);
        deactivatedLocations.removeIf(l -> !l.isDeleted());
        int numOfWidgetsStillUsing = this.findUsersUsingOneOfLocations(deactivatedLocations).size();
        @Nonnull List instances = spm.get(MaintenanceDeactivatedLocationCleanupExtension.class);
        for (Object instance : instances) {
            numOfWidgetsStillUsing += instance.findWidgetsStillUsingLocation(deactivatedLocations);
        }
        ArrayList<LocationPreviewEntry> list = new ArrayList<LocationPreviewEntry>();
        for (LocationVO locationVO : deactivatedLocations) {
            list.add(new LocationPreviewEntry().from(locationVO));
            if (list.size() != 6) continue;
            break;
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = deactivatedLocations.size();
        String stillUsed = numOfWidgetsStillUsing == 0 ? "" : HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.deactivatedlocations.preview.stillused", new Object[]{numOfWidgetsStillUsing});
        preview.setPreviewMsg(HelpDeskMaintenanceServerPlugin.MSG.getMsg(entriesCount > 0 ? "dataCare.deactivatedlocations.preview" : "dataCare.deactivatedlocations.nopreview", new Object[]{entriesCount, stillUsed}));
        preview.setExamples(list);
        return preview;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List deactivatedLocations = LocationManager.getInstance().getAll(false);
        deactivatedLocations.removeIf(l -> !l.isDeleted());
        UserManager userManager = UserManager.getInstance();
        Integer defaultValue = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        Set<GUID> users = this.findUsersUsingOneOfLocations(deactivatedLocations);
        users.forEach(userId -> userManager.updateUserData(userId, MutableUserData.of((UserField)HDUsersAndGroups.FIELD_LOCATION_ID, (Object)defaultValue)));
        @Nonnull List instances = spm.get(MaintenanceDeactivatedLocationCleanupExtension.class);
        for (MaintenanceDeactivatedLocationCleanupExtension instance : instances) {
            instance.cleanUpWidgetsStillUsingOneOfLocations(deactivatedLocations);
        }
        for (LocationVO loc : deactivatedLocations) {
            try {
                LocationManager.getInstance().remove(loc.getId());
            }
            catch (SQLException e) {
                throw new ServerDataException((Exception)e);
            }
        }
        return null;
    }

    private Set<GUID> findUsersUsingOneOfLocations(List<LocationVO> deactivatedLocations) {
        OrSearchExpression or = new OrSearchExpression();
        for (LocationVO locationVO : deactivatedLocations) {
            or.add((Object)new SearchCondition(HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)locationVO.getId()));
        }
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{or});
        Set users = UserManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
        return users;
    }

    private String getLocationDisplayName() {
        return HDUsersAndGroups.FIELD_LOCATION_ID.getLabel();
    }
}

