/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification;

import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationResultResponseData;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class LoginModificationDataExecuter {
    private String newDomainDisplay;
    private String newDomain;
    private String existingDomain;
    private Set<String> alreadyExistingNames;
    private UserManager manager;
    private int problemCount = 0;
    private int activeUsers = 0;
    private int inactiveUsers = 0;
    private int newLoginCount = 0;

    protected LoginModificationDataExecuter(UserManager manager, String newDomain, String existingDomain) {
        this.newDomain = newDomain.toUpperCase();
        this.newDomainDisplay = newDomain;
        this.existingDomain = existingDomain.toUpperCase();
        this.manager = manager;
        this.alreadyExistingNames = new HashSet<String>();
        List accoutLoginList = new UserIterator().getUserSystemLogins(manager);
        for (UserIterator.AccountLogins accountLogins : accoutLoginList) {
            this.collectAlreadyExistingNames(accountLogins);
        }
        for (UserIterator.AccountLogins accountLogins : accoutLoginList) {
            this.executeModification(accountLogins);
        }
    }

    private void collectAlreadyExistingNames(UserIterator.AccountLogins accountLogins) {
        for (UserIterator.LoginData data : accountLogins.getSystemLogins()) {
            if (!this.newDomain.equals(data.getDomain())) continue;
            this.alreadyExistingNames.add(data.getNormalizedUserName());
        }
    }

    private void executeModification(UserIterator.AccountLogins accountLogins) {
        boolean affected = false;
        for (UserIterator.LoginData data : accountLogins.getSystemLogins()) {
            String domain = data.getDomain();
            if (!this.existingDomain.equals(domain)) continue;
            String newName = this.newDomain + "\\" + data.getSimpleUserName().toUpperCase();
            if (this.alreadyExistingNames.contains(newName)) {
                ++this.problemCount;
                continue;
            }
            this.handleExecution(this.manager, accountLogins.getUserAccount(), data.getOriginalName(), this.newDomainDisplay + "\\" + data.getSimpleUserName());
            affected = true;
            ++this.newLoginCount;
        }
        if (affected) {
            if (accountLogins.getUserAccount().isActive()) {
                ++this.activeUsers;
            } else {
                ++this.inactiveUsers;
            }
        }
    }

    protected int getHandledLoginsCount() {
        return this.newLoginCount;
    }

    protected int getAlreadyExistingCount() {
        return this.alreadyExistingNames.size();
    }

    protected int getProblemCount() {
        return this.problemCount;
    }

    protected abstract void handleExecution(UserManager var1, UserAccount var2, String var3, String var4);

    protected LoginModificationResultResponseData getResult(String msgKey) {
        LoginModificationResultResponseData result = new LoginModificationResultResponseData();
        ArrayList<String> resultData = new ArrayList<String>();
        resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg(msgKey, new Object[]{this.getHandledLoginsCount(), this.newDomainDisplay}));
        resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.affected.execution.count", new Object[]{this.activeUsers, this.inactiveUsers}));
        if (this.problemCount > 0) {
            resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.problem.execution.count", new Object[]{this.getProblemCount()}));
        }
        result.setResult(resultData);
        return result;
    }
}

