/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.LoginModificationDataAnalyzer;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.LoginModificationDataExecuter;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.api.LoginModificationTask;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationResultResponseData;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;

public class AddLoginModificationTask
implements LoginModificationTask {
    @Override
    public String getKey() {
        return "loginmodification.addlogin";
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.addlogin.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.addlogin.description", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public LoginModificationResultResponseData executeLoginModification(HashMap<String, String> parameters) throws ServerDataException {
        return this.executeAddOperation(UserManager.getInstance(), parameters);
    }

    protected LoginModificationResultResponseData executeAddOperation(UserManager manager, HashMap<String, String> parameters) {
        String newDomain = parameters.get("newDomain");
        HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Execution of add domain current \"" + parameters.get("existingDomain") + "\" new \"" + newDomain + "\""));
        AddExecutor ae = new AddExecutor(manager, parameters.get("newDomain"), parameters.get("existingDomain"));
        LoginModificationResultResponseData lmrrd = ae.getResult("loginmodification.addlogin.execution.count");
        if (ae.getHandledLoginsCount() > 0) {
            LocalizedKey[] modifiedElements = new LocalizedKey[]{new LocalizedKey(newDomain.toUpperCase(), HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.entry.name.count", new Object[]{newDomain, ae.getHandledLoginsCount() + ae.getAlreadyExistingCount()}))};
            lmrrd.setModifiedEntrys(modifiedElements);
        }
        return lmrrd;
    }

    @Override
    public LoginModificationResultResponseData calcLoginModificationResult(HashMap<String, String> parameters) throws ServerDataException {
        return this.generateResults(UserManager.getInstance(), parameters);
    }

    protected LoginModificationResultResponseData generateResults(UserManager manager, HashMap<String, String> parameters) throws ClientMessageException {
        String newDomain = parameters.get("newDomain");
        String selectedDomain = parameters.get("existingDomain");
        if (newDomain == null || newDomain.length() == 0 || newDomain.equalsIgnoreCase(selectedDomain)) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.error.nodomain", new Object[0]));
        }
        HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Information for add domain current \"" + selectedDomain + "\" new \"" + newDomain + "\""));
        LoginModificationDataAnalyzer lmda = new LoginModificationDataAnalyzer(manager, newDomain, parameters.get("existingDomain"));
        LoginModificationResultResponseData lmrrd = lmda.generateResult("loginmodification.addlogin.information.count");
        lmrrd.setKey(this.getKey());
        return lmrrd;
    }

    private class AddExecutor
    extends LoginModificationDataExecuter {
        private AddExecutor(UserManager manager, String newDomain, String existingDomain) {
            super(manager, newDomain, existingDomain);
        }

        @Override
        protected void handleExecution(UserManager manager, UserAccount userAccount, String oldName, String newName) {
            ArrayList<LoginSettings> settingsToAdd = new ArrayList<LoginSettings>();
            settingsToAdd.add(new LoginSettings("system", newName, null));
            ArrayList settingsToRemove = new ArrayList();
            manager.updateLoginSettings(userAccount.getID(), settingsToAdd, settingsToRemove);
        }
    }
}

