/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare;

import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareDateFormat;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries.TicketPreviewEntry;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCareStatusResponseData;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.ticket";
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.description", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException, ClientMessageException {
        MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        String activeSelection = parameters.getOrDefault("activeSelection", "");
        MaintenanceConnector.TicketsToDelete matchingTickets = null;
        String ticketsBydate = "";
        switch (activeSelection) {
            case "DELETEDTICKETS": {
                matchingTickets = connector.findAllTicketsMarkedAsDeleted();
                break;
            }
            case "TICKETS_BY_ID": {
                int fromId = -1;
                try {
                    String fromIdString = parameters.get("delTicketsByIDStart");
                    Objects.requireNonNull(fromIdString);
                    fromId = Integer.parseInt(fromIdString);
                }
                catch (Throwable t) {
                    throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByIDStart", new Object[0]));
                }
                int toId = fromId;
                String idEnd = parameters.get("delTicketsByIDEnd");
                if (idEnd != null && !idEnd.isEmpty()) {
                    try {
                        toId = (int)Math.min(Integer.MAX_VALUE, Long.parseLong(idEnd));
                    }
                    catch (Throwable t) {
                        HelpDeskMaintenanceServerPlugin.LOGGER.error(t);
                        throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByIDEnd", new Object[0]));
                    }
                }
                matchingTickets = connector.findTicketsById(Math.min(fromId, toId), Math.max(fromId, toId));
                break;
            }
            case "TICKETS_BY_DATE": {
                try {
                    DateFormat formatter = DataCareDateFormat.getDateFormat(ClientLocale.getThreadLocale());
                    Calendar instance = Calendar.getInstance();
                    instance.setTime(formatter.parse(parameters.get("delTicketsByDate")));
                    instance.set(10, 23);
                    instance.set(12, 59);
                    instance.set(13, 59);
                    ticketsBydate = formatter.format(instance.getTime());
                    matchingTickets = connector.findTicketsByDate(instance.getTime());
                    break;
                }
                catch (Throwable t) {
                    HelpDeskMaintenanceServerPlugin.LOGGER.error(t);
                    throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByDate", new Object[0]));
                }
            }
        }
        ArrayList<TicketPreviewEntry> list = new ArrayList<TicketPreviewEntry>();
        if (matchingTickets != null) {
            for (Ticket ticket : matchingTickets.getExemplaryTickets()) {
                list.add(new TicketPreviewEntry().from(ticket));
            }
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = matchingTickets == null ? 0 : matchingTickets.getFoundTicketsCount() + matchingTickets.getFoundBundledTicketsCount();
        String previewMsg = null;
        previewMsg = entriesCount == 0 ? HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.nopreview", new Object[0]) : (matchingTickets != null && matchingTickets.getFoundBundledTicketsCount() > 0 ? (activeSelection.equals("TICKETS_BY_DATE") ? HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.preview.date.bundled", new Object[]{matchingTickets.getFoundTicketsCount(), matchingTickets.getFoundBundledTicketsCount(), ticketsBydate}) : HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.preview.bundled", new Object[]{matchingTickets.getFoundTicketsCount(), matchingTickets.getFoundBundledTicketsCount()})) : (activeSelection.equals("TICKETS_BY_DATE") ? HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.preview.date", new Object[]{entriesCount, ticketsBydate}) : HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.preview", new Object[]{entriesCount})));
        preview.setPreviewMsg(previewMsg);
        preview.setExamples(list);
        return preview;
    }

    @Override
    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        GUID taskId = GUID.generateNew();
        DataCareStatusResponseData status = new DataCareStatusResponseData();
        TASK_STATUSES.put(taskId, status);
        GUID account = UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID();
        EXECUTOR_SERVICE.submit(() -> {
            try {
                UserAccountScope scope = UserAccountScope.create((GUID)account);
                try {
                    String activeSelection;
                    MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
                    switch (activeSelection = parameters.getOrDefault("activeSelection", "")) {
                        case "DELETEDTICKETS": {
                            connector.deleteAllTicketsMarkedAsDeleted();
                            break;
                        }
                        case "TICKETS_BY_ID": {
                            int fromId = -1;
                            try {
                                String fromIdString = (String)parameters.get("delTicketsByIDStart");
                                Objects.requireNonNull(fromIdString);
                                fromId = Integer.parseInt(fromIdString);
                            }
                            catch (Throwable t) {
                                status.setError(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByIDStart", new Object[0]));
                                if (scope != null) {
                                    scope.close();
                                }
                                return;
                            }
                            int toId = fromId;
                            String idEnd = (String)parameters.get("delTicketsByIDEnd");
                            if (idEnd != null && !idEnd.isEmpty()) {
                                try {
                                    toId = (int)Math.min(Integer.MAX_VALUE, Long.parseLong(idEnd));
                                }
                                catch (Throwable t) {
                                    HelpDeskMaintenanceServerPlugin.LOGGER.error(t);
                                    status.setError(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByIDEnd", new Object[0]));
                                    if (scope != null) {
                                        scope.close();
                                    }
                                    return;
                                }
                            }
                            connector.deleteTicketsById(Math.min(fromId, toId), Math.max(fromId, toId));
                            break;
                        }
                        case "TICKETS_BY_DATE": {
                            try {
                                DateFormat formatter = DataCareDateFormat.getDateFormat(ClientLocale.getThreadLocale());
                                Calendar instance = Calendar.getInstance();
                                instance.setTime(formatter.parse((String)parameters.get("delTicketsByDate")));
                                instance.set(10, 23);
                                instance.set(12, 59);
                                instance.set(13, 59);
                                connector.deleteTicketsByDate(instance.getTime());
                                break;
                            }
                            catch (Throwable t) {
                                HelpDeskMaintenanceServerPlugin.LOGGER.error(t);
                                status.setError(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.ticket.error.delTicketsByDate", new Object[0]));
                                if (scope != null) {
                                    scope.close();
                                }
                                return;
                            }
                        }
                    }
                    try {
                        TicketManager.getMaintenance().resetTicketIDGenerator();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    status.setCompleted();
                }
                finally {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Exception e) {
                status.setError(e.getMessage());
            }
        });
        return taskId;
    }
}

