/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.dbmigration.runner;

import com.inet.config.Configuration;
import com.inet.config.internal.NodeRestarter;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.MigrateDbSettings;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.runner.DbMigrationStatus;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.persistence.MaintenanceMode;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;

public class DbMigrationRunner {
    private static final DbMigrationRunner INSTANCE = new DbMigrationRunner();
    private Thread runner;
    private DbMigrationStatus status = new DbMigrationStatus();
    private static final String DATASTRUCTURE_PATH = "setup/databasestructure.xml";

    DbMigrationRunner() {
    }

    public static DbMigrationRunner getInstance() {
        return INSTANCE;
    }

    public boolean isRunning() {
        return this.runner != null && this.runner.isAlive();
    }

    public DbMigrationStatus getStatus() {
        return this.status;
    }

    public void startMigration(final DatabaseConfigInfo sourceInfo, final DatabaseConfigInfo targetInfo, final String systemUser, final String systemPassword, final MigrateDbSettings targetDB) {
        if (this.isRunning()) {
            return;
        }
        this.status = new DbMigrationStatus(true, false, null, HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.progress.serverstopping", new Object[0]), 100, targetDB);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ServerPluginManager spm = ServerPluginManager.getInstance();
                    MaintenanceMode.start();
                    DbMigrationRunner.this.status = new DbMigrationStatus(true, false, null, HelpDeskMaintenanceServerPlugin.MSG.getMsg("dbMigration.progress.updatestarting", new Object[0]), 100, targetDB);
                    DBUpdateBackdoor dbUpdater = (DBUpdateBackdoor)spm.getSingleInstance(DBUpdateBackdoor.class);
                    Map<String, SupplierWithIOException<InputStream>> pluginStructures = DbMigrationRunner.this.getPluginStructures();
                    dbUpdater.migrateDB(sourceInfo, targetInfo, systemUser, systemPassword, event -> {
                        int progress = (int)Math.floor((double)event.getCurrentJob() / (double)event.getJobCount() * 100.0);
                        DbMigrationRunner.this.status = new DbMigrationStatus(true, false, null, event, progress, targetDB);
                    }, new ArrayList<SupplierWithIOException<InputStream>>(pluginStructures.values()));
                    DbMigrationRunner.this.status = new DbMigrationStatus(false, true, null, (String)null, 0, targetDB);
                    Configuration currentConfiguration = MaintenanceHelper.getCurrentConfiguration();
                    String dbConfigValue = currentConfiguration.get(HDConfigKeys.DB_CONFIGS.getKey(), HDConfigKeys.DB_CONFIGS.getDefault());
                    DatabaseConfigInfoList dbConfigs = (DatabaseConfigInfoList)new Json().fromJson(dbConfigValue, DatabaseConfigInfoList.class);
                    DatabaseConfigInfo hdsConfig = dbConfigs.get("HDS");
                    if (hdsConfig != null) {
                        dbConfigs.remove((Object)hdsConfig);
                    }
                    targetInfo.setDbName("HDS");
                    dbConfigs.add((Object)targetInfo);
                    currentConfiguration.put(HDConfigKeys.DB_CONFIGS.getKey(), new Json().toJson((Object)dbConfigs));
                    DatabaseVersionChecker checker = new DatabaseVersionChecker();
                    pluginStructures.entrySet().forEach(e -> checker.markDatabaseStructureChanged((String)e.getKey(), (SupplierWithIOException)e.getValue()));
                    NodeRestarter.restartAllServerNodes();
                    MaintenanceMode.finish();
                }
                catch (Throwable e2) {
                    HelpDeskMaintenanceServerPlugin.LOGGER.error(e2);
                    DbMigrationRunner.this.status = new DbMigrationStatus(false, false, StringFunctions.getUserFriendlyErrorMessage((Throwable)e2), (String)null, 0, targetDB);
                }
            }
        };
        this.runner = new Thread(runnable);
        this.runner.setName("DB-Migration");
        this.runner.setDaemon(true);
        this.runner.start();
    }

    private Map<String, SupplierWithIOException<InputStream>> getPluginStructures() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        String coreID = spm.getCorePluginId();
        ServerPluginDescription coreDesc = spm.getPluginDescription(coreID);
        LinkedHashMap<String, SupplierWithIOException<InputStream>> pluginSuppliers = new LinkedHashMap<String, SupplierWithIOException<InputStream>>();
        for (String id : spm.getAvailablePlugins()) {
            String pluginId;
            Object provider;
            ServerPluginDescription desc = spm.getPluginDescription(id);
            if (desc == null) {
                HelpDeskMaintenanceServerPlugin.LOGGER.warn((Object)("Cannot check for database migration data for plugin '" + id + "' since there is not plugin descrption loaded."));
                continue;
            }
            if (!spm.isPluginLoaded(id) && !desc.getVersion().equals(coreDesc.getVersion())) {
                HelpDeskMaintenanceServerPlugin.LOGGER.warn((Object)("Cannot check for database migration data for inactive plugin '" + id + "' since it is outdated."));
                continue;
            }
            ServerPlugin serverPLugin = this.getServerPluginFromDescription(desc);
            if (serverPLugin != null) {
                provider = new StreamProviderFromClassLoader(serverPLugin.getClass());
                pluginId = desc.getId();
            } else {
                ResourceFile location = desc.getLocation();
                if (location == null) {
                    HelpDeskMaintenanceServerPlugin.LOGGER.warn((Object)("Cannot check for database migration data for inactive plugin '" + id + "' since it is a developer instance."));
                    continue;
                }
                try (ArchiveFile zip = location.createArchiveFile();){
                    ZipEntry pluginProps = zip.getEntry("plugin.properties");
                    if (pluginProps == null) {
                        HelpDeskMaintenanceServerPlugin.LOGGER.warn((Object)("Cannot check for database migration data for inactive plugin '" + id + "' since the entry point value is missing."));
                        continue;
                    }
                    Properties props = new Properties();
                    props.load(zip.getInputStream(pluginProps));
                    pluginId = props.getProperty("id");
                    String entryPoint = props.getProperty("entrypoint");
                    String basePath = entryPoint.substring(0, entryPoint.lastIndexOf(46)).replace('.', '/');
                    provider = new StreamProviderFromPluginZIP(id, basePath + "/setup/databasestructure.xml");
                }
                catch (Throwable e) {
                    HelpDeskMaintenanceServerPlugin.LOGGER.error(e);
                    continue;
                }
            }
            try (InputStream in = (InputStream)provider.get();){
                if (in == null) continue;
                pluginSuppliers.put(pluginId, (SupplierWithIOException<InputStream>)provider);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pluginSuppliers;
    }

    ServerPlugin getServerPluginFromDescription(ServerPluginDescription desc) {
        return desc.getServerPlugin();
    }

    private static class StreamProviderFromClassLoader
    implements SupplierWithIOException<InputStream> {
        private Class<?> pluginEntryPoint;

        public StreamProviderFromClassLoader(Class<?> pluginEntryPoint) {
            this.pluginEntryPoint = pluginEntryPoint;
        }

        public InputStream get() throws IOException {
            return this.pluginEntryPoint.getResourceAsStream(DbMigrationRunner.DATASTRUCTURE_PATH);
        }
    }

    private static class StreamProviderFromPluginZIP
    implements SupplierWithIOException<InputStream> {
        private String path;
        private String pluginId;

        public StreamProviderFromPluginZIP(String pluginId, String path) {
            this.pluginId = pluginId;
            this.path = path;
        }

        public InputStream get() throws IOException {
            ResourceFile resource = ServerPluginManager.getInstance().getPluginFile(this.pluginId, this.path);
            return resource != null ? resource.getInputStream() : null;
        }
    }
}

